/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.core.http;

import com.googlecode.xremoting.core.spi.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public class HttpRequest
implements Request {
    private HttpURLConnection connection;

    public HttpRequest(HttpURLConnection connection) {
        this.connection = connection;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    public void commitRequest() throws IOException {
        this.connection.getOutputStream().flush();
        this.checkStatusCode(this.connection);
    }

    protected void checkStatusCode(HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() != 200) {
            throw new IOException("Wrong status code: 200 expected but got " + connection.getResponseCode() + " (" + connection.getResponseMessage() + ")");
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public void releaseRequest() {
        this.connection.disconnect();
    }
}

