/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.groupon.mesos.state;

import java.io.File;

import com.google.common.io.Files;

import org.apache.mesos.state.State;
import org.junit.After;
import org.junit.Before;

public class TestJLevelDBState
    extends AbstractTestState
{
    private File levelDbFolder;
    private JLevelDBState state;

    @Before
    public void setUp()
        throws Exception
    {
        levelDbFolder = Files.createTempDir();
        state = new JLevelDBState(levelDbFolder.getAbsolutePath());
    }

    @After
    public void tearDown()
        throws Exception
    {
        state.close();

        for (final File file : Files.fileTreeTraverser().postOrderTraversal(levelDbFolder)) {
            file.delete();
        }
    }

    @Override
    protected State getState()
    {
        return state;
    }
}
