/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.state;

import com.google.protobuf.ByteString;
import com.groupon.mesos.state.JVariable;
import com.groupon.mesos.util.UUIDUtil;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import mesos.internal.state.State;
import org.apache.mesos.state.Variable;
import org.junit.Assert;
import org.junit.Test;

public class TestJVariable {
    @Test
    public void testEntry() {
        UUID uuid = UUID.randomUUID();
        String name = "test-name";
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        State.Entry entry = State.Entry.newBuilder().setName("test-name").setValue(ByteString.copyFrom((byte[])value)).setUuid(UUIDUtil.uuidBytes((UUID)uuid)).build();
        JVariable v = new JVariable(entry);
        Assert.assertEquals((Object)"test-name", (Object)v.getName());
        Assert.assertEquals((Object)uuid, (Object)v.getUuid());
        Assert.assertArrayEquals((byte[])value, (byte[])v.value());
    }

    @Test
    public void testNameValue() {
        String name = "test-name";
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        JVariable v = new JVariable("test-name", value);
        Assert.assertEquals((Object)"test-name", (Object)v.getName());
        Assert.assertArrayEquals((byte[])value, (byte[])v.value());
    }

    @Test
    public void testMutate() {
        String name = "test-name";
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        byte[] newValue = "Ich esse Autos zum Abendbrot und mache Kopfsprung ins Sandbecken. Gruen. Rot. Pferderennen.".getBytes(StandardCharsets.UTF_8);
        JVariable v = new JVariable("test-name", value);
        Variable w = v.mutate(newValue);
        Assert.assertEquals(JVariable.class, w.getClass());
        Assert.assertArrayEquals((byte[])newValue, (byte[])w.value());
        Assert.assertEquals((Object)"test-name", (Object)v.getName());
        Assert.assertArrayEquals((byte[])value, (byte[])v.value());
        JVariable v2 = (JVariable)w;
        Assert.assertEquals((Object)v.getName(), (Object)v2.getName());
        Assert.assertEquals((Object)v.getUuid(), (Object)v2.getUuid());
    }
}

