/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.eventbus.Subscribe;
import com.google.protobuf.Message;
import com.groupon.mesos.scheduler.SchedulerCallback;
import com.groupon.mesos.scheduler.SchedulerDriverContext;
import com.groupon.mesos.scheduler.SchedulerMessageEnvelope;
import com.groupon.mesos.util.Log;
import com.groupon.mesos.util.ManagedEventBus;
import com.groupon.mesos.util.UPID;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import mesos.internal.Messages;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

class LocalSchedulerMessageProcessor {
    private static final Log LOG = Log.getLog(LocalSchedulerMessageProcessor.class);
    private final SchedulerDriverContext context;
    private final ManagedEventBus eventBus;

    LocalSchedulerMessageProcessor(SchedulerDriverContext context, ManagedEventBus eventBus) {
        this.context = (SchedulerDriverContext)Preconditions.checkNotNull((Object)context, (Object)"context is null");
        this.eventBus = (ManagedEventBus)Preconditions.checkNotNull((Object)eventBus, (Object)"eventBus is null");
    }

    @Subscribe
    public void frameworkRegistered(SchedulerMessageEnvelope.FrameworkRegisteredMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        Messages.FrameworkRegisteredMessage frameworkRegisteredMessage = (Messages.FrameworkRegisteredMessage)envelope.getMessage();
        if (!this.masterIsValid(frameworkRegisteredMessage.getMasterInfo())) {
            return;
        }
        final Protos.FrameworkID frameworkId = frameworkRegisteredMessage.getFrameworkId();
        this.context.connected();
        this.context.setFailover(false);
        this.context.setFrameworkId(frameworkId);
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        scheduler.registered(schedulerDriver, frameworkId, LocalSchedulerMessageProcessor.this.context.getMaster());
                    }
                };
            }
        });
    }

    @Subscribe
    public void frameworkReregistered(SchedulerMessageEnvelope.FrameworkReregisteredMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        Messages.FrameworkReregisteredMessage frameworkReregisteredMessage = (Messages.FrameworkReregisteredMessage)envelope.getMessage();
        if (!this.masterIsValid(frameworkReregisteredMessage.getMasterInfo())) {
            return;
        }
        Protos.FrameworkID frameworkId = frameworkReregisteredMessage.getFrameworkId();
        Preconditions.checkState((frameworkId != null ? 1 : 0) != 0, (Object)"Received null framework reregistration message!");
        Preconditions.checkState((boolean)frameworkId.equals((Object)this.context.getFrameworkId()), (String)"Received framework reregistration for %s but expected %s", (Object[])new Object[]{frameworkId.getValue(), this.context.getFrameworkId().getValue()});
        this.context.connected();
        this.context.setFailover(false);
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        scheduler.reregistered(schedulerDriver, LocalSchedulerMessageProcessor.this.context.getMaster());
                    }
                };
            }
        });
    }

    @Subscribe
    public void frameworkResourceOffers(SchedulerMessageEnvelope.ResourceOffersMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        UPID sender = envelope.getSender();
        if (!this.driverIsConnected(sender)) {
            return;
        }
        final Messages.ResourceOffersMessage resourceOffersMessage = (Messages.ResourceOffersMessage)envelope.getMessage();
        List<Protos.Offer> offers = resourceOffersMessage.getOffersList();
        ImmutableList pids = ImmutableList.copyOf((Collection)Lists.transform(resourceOffersMessage.getPidsList(), UPID.getCreateFunction()));
        Preconditions.checkState((offers.size() == pids.size() ? 1 : 0) != 0, (String)"Received %s offers but only %s pids!", (Object[])new Object[]{offers.size(), pids.size()});
        int pidIndex = 0;
        for (Protos.Offer offer : offers) {
            this.context.addOffer(offer.getId(), offer.getSlaveId(), (UPID)pids.get(pidIndex++));
        }
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        scheduler.resourceOffers(schedulerDriver, resourceOffersMessage.getOffersList());
                    }
                };
            }
        });
    }

    @Subscribe
    public void frameworkRescindOffer(SchedulerMessageEnvelope.RescindResourceOfferMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        UPID sender = envelope.getSender();
        if (!this.driverIsConnected(sender)) {
            return;
        }
        final Messages.RescindResourceOfferMessage rescindResourceOfferMessage = (Messages.RescindResourceOfferMessage)envelope.getMessage();
        this.context.removeAllOffers(rescindResourceOfferMessage.getOfferId());
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        scheduler.offerRescinded(schedulerDriver, rescindResourceOfferMessage.getOfferId());
                    }
                };
            }
        });
    }

    @Subscribe
    public void frameworkStatusUpdate(SchedulerMessageEnvelope.StatusUpdateMessageEnvelope envelope) throws IOException {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        UPID sender = envelope.getSender();
        if (!this.driverIsConnected(sender)) {
            return;
        }
        Messages.StatusUpdateMessage statusUpdateMessage = (Messages.StatusUpdateMessage)envelope.getMessage();
        final Protos.TaskStatus taskStatus = statusUpdateMessage.getUpdate().getStatus();
        Protos.FrameworkID frameworkId = this.context.getFrameworkId();
        Protos.FrameworkID messageFrameworkId = statusUpdateMessage.getUpdate().getFrameworkId();
        Preconditions.checkState((boolean)frameworkId.equals((Object)messageFrameworkId), (String)"Received Message for framework %s, but local id is %s", (Object[])new Object[]{messageFrameworkId, frameworkId});
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        scheduler.statusUpdate(schedulerDriver, taskStatus);
                    }
                };
            }
        });
        if (statusUpdateMessage.hasPid()) {
            Messages.StatusUpdateAcknowledgementMessage statusUpdateAcknowledgementMessage = Messages.StatusUpdateAcknowledgementMessage.newBuilder().setFrameworkId(frameworkId).setSlaveId(statusUpdateMessage.getUpdate().getSlaveId()).setTaskId(taskStatus.getTaskId()).setUuid(statusUpdateMessage.getUpdate().getUuid()).build();
            UPID pid = UPID.create(statusUpdateMessage.getPid());
            this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), pid, (Message)statusUpdateAcknowledgementMessage));
        }
    }

    @Subscribe
    public void frameworkLostSlave(SchedulerMessageEnvelope.LostSlaveMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        UPID sender = envelope.getSender();
        if (!this.driverIsConnected(sender)) {
            return;
        }
        Messages.LostSlaveMessage lostSlaveMessage = (Messages.LostSlaveMessage)envelope.getMessage();
        final Protos.SlaveID slaveId = lostSlaveMessage.getSlaveId();
        this.context.removeSlave(slaveId);
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        scheduler.slaveLost(schedulerDriver, slaveId);
                    }
                };
            }
        });
    }

    @Subscribe
    public void frameworkFrameworkMessage(SchedulerMessageEnvelope.ExecutorToFrameworkMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        UPID sender = envelope.getSender();
        if (!this.driverIsConnected(sender)) {
            return;
        }
        final Messages.ExecutorToFrameworkMessage executorToFrameworkMessage = (Messages.ExecutorToFrameworkMessage)envelope.getMessage();
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        scheduler.frameworkMessage(schedulerDriver, executorToFrameworkMessage.getExecutorId(), executorToFrameworkMessage.getSlaveId(), executorToFrameworkMessage.getData().toByteArray());
                    }
                };
            }
        });
    }

    @Subscribe
    public void frameworkError(SchedulerMessageEnvelope.FrameworkErrorMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        UPID sender = envelope.getSender();
        if (!this.driverIsConnected(sender)) {
            return;
        }
        final Messages.FrameworkErrorMessage frameworkErrorMessage = (Messages.FrameworkErrorMessage)envelope.getMessage();
        this.eventBus.post(new SchedulerCallback(){

            @Override
            public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        schedulerDriver.abort();
                        scheduler.error(schedulerDriver, frameworkErrorMessage.getMessage());
                    }
                };
            }
        });
    }

    private boolean masterIsValid(Protos.MasterInfo masterInfo) {
        Preconditions.checkNotNull((Object)masterInfo, (Object)"masterInfo is null");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return false;
        }
        Protos.MasterInfo currentMaster = this.context.getMaster();
        if (currentMaster == null) {
            LOG.warn("Received registration from  %s, but no master is leading, ignoring!", masterInfo.getId());
            return false;
        }
        if (!masterInfo.equals((Object)currentMaster)) {
            LOG.warn("Received registration from %s, leading master is %s, ignoring!", masterInfo, currentMaster);
            return false;
        }
        return true;
    }

    private boolean driverIsConnected(UPID messageSender) {
        Protos.MasterInfo master = this.context.connectedMaster();
        if (master == null) {
            LOG.warn("Received message from  %s, but no master is leading, ignoring!", messageSender);
            return false;
        }
        UPID masterUpid = UPID.create(master.getPid());
        if (!masterUpid.equals(messageSender)) {
            LOG.warn("Received message from %s, leading master is %s, ignoring!", messageSender, masterUpid);
            return false;
        }
        return true;
    }
}

