/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.groupon.mesos.util.Log;
import com.groupon.mesos.util.ManagedEventBus;
import com.groupon.mesos.util.UPID;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.CanonicalPathHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import mesos.internal.Messages;

public class HttpProtocolReceiver
implements HttpHandler,
Closeable {
    private static final Log LOG = Log.getLog(HttpProtocolReceiver.class);
    private final Undertow httpServer;
    private final GracefulShutdownHandler shutdownHandler;
    private final ManagedEventBus eventBus;
    private final UPID localAddress;
    private final Class<?> messageBaseClass;
    private final Set<String> typesSeen = Sets.newConcurrentHashSet();
    private final ConcurrentMap<String, Method> parseMethodMap = Maps.newConcurrentMap();
    private final ConcurrentMap<String, Constructor<?>> constructorMap = Maps.newConcurrentMap();

    public HttpProtocolReceiver(UPID localAddress, Class<?> messageBaseClass, ManagedEventBus eventBus) {
        this.localAddress = localAddress;
        this.messageBaseClass = messageBaseClass;
        this.eventBus = eventBus;
        PathHandler pathHandler = new PathHandler();
        pathHandler.addPrefixPath(localAddress.getId(), (HttpHandler)new CanonicalPathHandler((HttpHandler)new BlockingHandler((HttpHandler)this)));
        this.shutdownHandler = new GracefulShutdownHandler((HttpHandler)pathHandler);
        this.httpServer = Undertow.builder().setIoThreads(2).setWorkerThreads(16).addHttpListener(localAddress.getPort(), localAddress.getHost()).setHandler((HttpHandler)this.shutdownHandler).build();
    }

    @Override
    public void close() throws IOException {
        this.shutdownHandler.shutdown();
        try {
            this.shutdownHandler.awaitShutdown();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.httpServer.stop();
    }

    public void start() {
        this.httpServer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Constructor<?> envelopeConstructor;
        Method parseFromMethod;
        UPID sender;
        String libprocessFrom = exchange.getRequestHeaders().getFirst("Libprocess-From");
        if (libprocessFrom != null) {
            sender = UPID.create(libprocessFrom);
        } else {
            String userAgent = exchange.getRequestHeaders().getFirst("User-Agent");
            Preconditions.checkState((userAgent != null && userAgent.startsWith("libprocess/") ? 1 : 0) != 0, (Object)"No User-Agent or Libprocess-From header found! Not a valid message!");
            sender = UPID.create(userAgent.substring(11));
        }
        int dotIndex = exchange.getRelativePath().lastIndexOf(46);
        String name = exchange.getRelativePath().substring(dotIndex + 1);
        exchange.setResponseCode(202);
        if (this.typesSeen.contains(name)) {
            if (!this.parseMethodMap.containsKey(name)) {
                LOG.warn("Unparseable message type %s", name);
                return;
            }
            parseFromMethod = (Method)this.parseMethodMap.get(name);
            envelopeConstructor = (Constructor<?>)this.constructorMap.get(name);
        } else {
            try {
                Class<?> clazz = Class.forName(Messages.class.getName() + "$" + name);
                parseFromMethod = clazz.getMethod("parseFrom", InputStream.class);
                Class<?> envelopeClazz = Class.forName(this.messageBaseClass.getName() + "$" + name + "Envelope");
                envelopeConstructor = envelopeClazz.getConstructor(UPID.class, UPID.class, clazz);
                this.parseMethodMap.put(name, parseFromMethod);
                this.constructorMap.put(name, envelopeConstructor);
            }
            catch (ReflectiveOperationException | SecurityException e) {
                LOG.warn(e, "While constructing objects for message type %s", name);
                return;
            }
            finally {
                this.typesSeen.add(name);
            }
        }
        try {
            Object o = parseFromMethod.invoke(null, exchange.getInputStream());
            this.eventBus.post(envelopeConstructor.newInstance(sender, this.localAddress, o));
            LOG.debug("Received from %s: %s", sender.asString(), o);
        }
        catch (ReflectiveOperationException e) {
            LOG.warn(e, "Can not decode message type %s", name);
        }
    }
}

