/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;

public final class NetworkUtil {
    private NetworkUtil() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static int findUnusedPort() throws IOException {
        int port;
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        return port;
    }

    public static String findPublicIp() throws UnknownHostException {
        InetAddress localAddress = InetAddress.getLocalHost();
        if (NetworkUtil.isV4Address(localAddress) && NetworkUtil.getGoodAddresses().contains(localAddress)) {
            return localAddress.getHostAddress();
        }
        for (InetAddress address : NetworkUtil.getGoodAddresses()) {
            if (!NetworkUtil.isV4Address(address)) continue;
            return address.getHostAddress();
        }
        return localAddress.getHostAddress();
    }

    private static List<InetAddress> getGoodAddresses() {
        ImmutableList.Builder list = ImmutableList.builder();
        for (NetworkInterface networkInterface : NetworkUtil.getGoodNetworkInterfaces()) {
            for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
                if (!NetworkUtil.isGoodAddress(address)) continue;
                list.add((Object)address);
            }
        }
        return list.build();
    }

    private static List<NetworkInterface> getGoodNetworkInterfaces() {
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (NetworkInterface networkInterface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                try {
                    if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                    builder.add((Object)networkInterface);
                }
                catch (SocketException se) {}
            }
            return builder.build();
        }
        catch (SocketException se) {
            return ImmutableList.of();
        }
    }

    private static boolean isV4Address(InetAddress address) {
        return address.getAddress().length == 4;
    }

    private static boolean isGoodAddress(InetAddress address) {
        return !address.isAnyLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }
}

