/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

public final class UUIDUtil {
    private UUIDUtil() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static ByteString uuidBytes(UUID uuid) {
        ByteBuffer longBuffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        longBuffer.mark();
        longBuffer.putLong(uuid.getMostSignificantBits());
        longBuffer.putLong(uuid.getLeastSignificantBits());
        longBuffer.reset();
        return ByteString.copyFrom((ByteBuffer)longBuffer);
    }

    public static UUID bytesUuid(ByteString byteString) {
        ByteBuffer uuidBuffer = byteString.asReadOnlyByteBuffer();
        return new UUID(uuidBuffer.getLong(), uuidBuffer.getLong());
    }
}

