/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.Message;
import com.groupon.mesos.util.Log;
import com.groupon.mesos.util.UPID;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpProtocolSender
implements Callback,
Closeable {
    private static final Log LOG = Log.getLog(HttpProtocolSender.class);
    private static final MediaType PROTOBUF_MEDIATYPE = MediaType.parse((String)"application/x-protobuf");
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final OkHttpClient client;
    private final String sender;
    private final Map<UUID, SettableFuture<Void>> inFlight = new ConcurrentHashMap<UUID, SettableFuture<Void>>(16, 0.75f, 2);

    public HttpProtocolSender(UPID sender) {
        this.client = new OkHttpClient();
        this.client.setProtocols((List)ImmutableList.of((Object)Protocol.HTTP_1_1));
        this.sender = sender.asString();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            while (!this.inFlight.isEmpty()) {
                try {
                    Futures.allAsList(this.inFlight.values()).get();
                }
                catch (ExecutionException e) {
                    LOG.warn(e.getCause(), "While waiting for in flight requests to drain", new Object[0]);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    public void sendHttpMessage(UPID recipient, Message message) throws IOException {
        if (this.closed.get()) {
            return;
        }
        Preconditions.checkNotNull((Object)recipient, (Object)"recipient is null");
        Preconditions.checkNotNull((Object)message, (Object)"message is null");
        Preconditions.checkArgument((recipient.getHost() != null ? 1 : 0) != 0, (String)"%s is not a valid recipient for %s", (Object[])new Object[]{recipient, message});
        Preconditions.checkArgument((recipient.getPort() > 0 ? 1 : 0) != 0, (String)"%s is not a valid recipient for %s", (Object[])new Object[]{recipient, message});
        String path = String.format("/%s/%s", recipient.getId(), message.getDescriptorForType().getFullName());
        URL url = new URL("http", recipient.getHost(), recipient.getPort(), path);
        UUID tag = UUID.randomUUID();
        this.inFlight.put(tag, (SettableFuture<Void>)SettableFuture.create());
        RequestBody body = RequestBody.create((MediaType)PROTOBUF_MEDIATYPE, (byte[])message.toByteArray());
        Request request = new Request.Builder().header("Libprocess-From", this.sender).url(url).post(body).tag((Object)tag).build();
        LOG.debug("Sending from %s to URL %s: %s", this.sender, url, message);
        this.client.newCall(request).enqueue((Callback)this);
    }

    public void onFailure(Request request, IOException e) {
        Object tag = request.tag();
        Preconditions.checkState((tag != null ? 1 : 0) != 0, (Object)"saw a request with null tag");
        SettableFuture<Void> future = this.inFlight.remove(tag);
        Preconditions.checkState((future != null ? 1 : 0) != 0, (String)"Saw tag %s but not in in flight map", (Object[])new Object[]{tag});
        future.setException((Throwable)e);
        LOG.warn("While running %s %s: %s", request.method(), request.urlString(), e.getMessage());
    }

    public void onResponse(Response response) throws IOException {
        Object tag = response.request().tag();
        Preconditions.checkState((tag != null ? 1 : 0) != 0, (Object)"saw a request with null tag");
        SettableFuture<Void> future = this.inFlight.remove(tag);
        Preconditions.checkState((future != null ? 1 : 0) != 0, (String)"Saw tag %s but not in in flight map", (Object[])new Object[]{tag});
        future.set(null);
        LOG.debug("Response %s %s: %d", response.request().method(), response.request().urlString(), response.code());
    }
}

