/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Log {
    private final Logger logger;

    public static Log getLog(String categoryName) {
        return new Log(categoryName);
    }

    public static Log getLog(Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"clazz is null");
        return new Log(clazz.getName());
    }

    private Log(String categoryName) {
        this.logger = LoggerFactory.getLogger((String)categoryName);
    }

    public void debug(String formatString, Object ... values) {
        Preconditions.checkNotNull((Object)formatString, (Object)"format is null");
        if (values.length == 0) {
            this.logger.debug(formatString);
        } else {
            this.logger.debug(String.format(formatString, values));
        }
    }

    public void info(String formatString, Object ... values) {
        Preconditions.checkNotNull((Object)formatString, (Object)"format is null");
        if (values.length == 0) {
            this.logger.info(formatString);
        } else {
            this.logger.info(String.format(formatString, values));
        }
    }

    public void warn(String formatString, Object ... values) {
        Preconditions.checkNotNull((Object)formatString, (Object)"format is null");
        if (values.length == 0) {
            this.logger.warn(formatString);
        } else {
            this.logger.warn(String.format(formatString, values));
        }
    }

    public void warn(Throwable t, String formatString, Object ... values) {
        Preconditions.checkNotNull((Object)formatString, (Object)"format is null");
        if (values.length == 0) {
            this.logger.warn(formatString, t);
        } else {
            this.logger.warn(String.format(formatString, values), t);
        }
    }

    public void error(String formatString, Object ... values) {
        Preconditions.checkNotNull((Object)formatString, (Object)"format is null");
        if (values.length == 0) {
            this.logger.error(formatString);
        } else {
            this.logger.error(String.format(formatString, values));
        }
    }

    public void error(Throwable t, String formatString, Object ... values) {
        Preconditions.checkNotNull((Object)formatString, (Object)"format is null");
        if (values.length == 0) {
            this.logger.error(formatString, t);
        } else {
            this.logger.error(String.format(formatString, values), t);
        }
    }
}

