/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.groupon.mesos.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;

public final class UPID {
    private static final Log LOG = Log.getLog(UPID.class);
    private final String id;
    private final HostAndPort hostAndPort;
    private final Integer ip;
    private final String pidAsString;

    public static UPID create(String master) {
        Preconditions.checkNotNull((Object)master, (Object)"master is null");
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)":@")).limit(3).split((CharSequence)master));
        Preconditions.checkState((parts.size() == 3 ? 1 : 0) != 0, (String)"%s is not a valid master definition", (Object[])new Object[]{master});
        Integer ip = null;
        try {
            ip = UPID.resolveIp((String)parts.get(1));
        }
        catch (IOException e) {
            LOG.warn("Could not resolve %s: %s", parts.get(1), e.getMessage());
        }
        return new UPID((String)parts.get(0), HostAndPort.fromParts((String)((String)parts.get(1)), (int)Integer.parseInt((String)parts.get(2))), ip);
    }

    public static UPID fromParts(String id, HostAndPort hostAndPort) throws IOException {
        Preconditions.checkNotNull((Object)id, (Object)"id is null");
        Preconditions.checkNotNull((Object)hostAndPort, (Object)"hostAndPort is null");
        return new UPID(id, hostAndPort, UPID.resolveIp(hostAndPort.getHostText()));
    }

    private static Integer resolveIp(String hostname) throws IOException {
        InetAddress addr = InetAddress.getByName(hostname);
        if (addr == null) {
            return null;
        }
        if (addr.getAddress().length != 4) {
            LOG.warn("Received non-IPv4 address (%s), see https://issues.apache.org/jira/browse/MESOS-1562", hostname);
            return null;
        }
        ByteBuffer b = ByteBuffer.wrap(addr.getAddress()).order(ByteOrder.BIG_ENDIAN);
        return b.getInt();
    }

    private UPID(String id, HostAndPort hostAndPort, Integer ip) {
        this.id = id;
        this.hostAndPort = hostAndPort;
        this.ip = ip;
        this.pidAsString = String.format("%s@%s:%d", id, hostAndPort.getHostText(), hostAndPort.getPort());
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.hostAndPort.getHostText();
    }

    public int getPort() {
        return this.hostAndPort.getPort();
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public Integer getIp() {
        return this.ip;
    }

    public String asString() {
        return this.pidAsString;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.hostAndPort, this.ip});
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        UPID that = (UPID)other;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.hostAndPort, (Object)that.hostAndPort) && Objects.equal((Object)this.ip, (Object)that.ip);
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("id", (Object)this.id).add("hostAndPort", (Object)this.hostAndPort).add("ip", (Object)this.ip).toString();
    }

    public static Function<String, UPID> getCreateFunction() {
        return new Function<String, UPID>(){

            public UPID apply(@Nonnull String value) {
                try {
                    return UPID.create(value);
                }
                catch (Throwable t) {
                    throw Throwables.propagate((Throwable)t);
                }
            }
        };
    }
}

