/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.groupon.mesos.util;

import org.apache.mesos.Protos;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ExtensionRegistry;

import mesos.internal.Messages;

public enum ProtobufRegistry
{
    INSTANCE;

    private final ExtensionRegistry extensionRegistry;

    private ProtobufRegistry() {
        final ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();
        Protos.registerAllExtensions(extensionRegistry);
        Messages.registerAllExtensions(extensionRegistry);

        this.extensionRegistry = extensionRegistry;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return extensionRegistry.getUnmodifiable();
    }

    @VisibleForTesting
    ExtensionRegistry mutableExtensionRegistry() {
        return extensionRegistry;
    }
}
