/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.executor;

import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.groupon.mesos.util.NetworkUtil;
import com.groupon.mesos.util.UPID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import mesos.internal.Messages;
import org.apache.mesos.Protos;

class ExecutorDriverContext {
    private final AtomicReference<Protos.Status> stateMachine = new AtomicReference<Protos.Status>(Protos.Status.DRIVER_NOT_STARTED);
    private final BlockingQueue<SettableFuture<Protos.Status>> stateMachineFutures = new LinkedBlockingQueue<SettableFuture<Protos.Status>>();
    private final UPID driverUpid;
    private final UPID slaveUpid;
    private final Protos.SlaveID slaveId;
    private final Protos.FrameworkID frameworkId;
    private final Protos.ExecutorID executorId;
    private final ConcurrentMap<UUID, Messages.StatusUpdate> updates = new ConcurrentHashMap<UUID, Messages.StatusUpdate>(16, 0.75f, 3);

    ExecutorDriverContext(String hostName, UPID slaveUpid, Protos.SlaveID slaveId, Protos.FrameworkID frameworkId, Protos.ExecutorID executorId) throws IOException {
        this.slaveUpid = slaveUpid;
        this.slaveId = slaveId;
        this.frameworkId = frameworkId;
        this.executorId = executorId;
        this.driverUpid = UPID.fromParts(UUID.randomUUID().toString(), HostAndPort.fromParts((String)hostName, (int)NetworkUtil.findUnusedPort()));
    }

    UPID getSlaveUPID() {
        return this.slaveUpid;
    }

    Protos.SlaveID getSlaveId() {
        return this.slaveId;
    }

    Protos.FrameworkID getFrameworkId() {
        return this.frameworkId;
    }

    Protos.ExecutorID getExecutorId() {
        return this.executorId;
    }

    UPID getDriverUPID() {
        return this.driverUpid;
    }

    void addUpdate(UUID key, Messages.StatusUpdate update) {
        this.updates.put(key, update);
    }

    void removeUpdate(UUID key) {
        this.updates.remove(key);
    }

    Iterable<Messages.StatusUpdate> getUpdates() {
        return this.updates.values();
    }

    synchronized void setStateMachine(Protos.Status status) {
        Protos.Status oldStatus = this.stateMachine.getAndSet(status);
        if (status != oldStatus) {
            ArrayList settableFutures = new ArrayList(this.stateMachineFutures.size());
            this.stateMachineFutures.drainTo(settableFutures);
            for (SettableFuture future : settableFutures) {
                future.set((Object)status);
            }
        }
    }

    synchronized Protos.Status getStateMachine() {
        return this.stateMachine.get();
    }

    synchronized ListenableFuture<Protos.Status> waitForStateChange(Protos.Status expectedStatus) {
        SettableFuture future = SettableFuture.create();
        if (!this.isStateMachine(expectedStatus)) {
            future.set((Object)this.stateMachine.get());
        } else {
            this.stateMachineFutures.add((SettableFuture<Protos.Status>)future);
        }
        return future;
    }

    synchronized boolean isStateMachine(Protos.Status ... statusWanted) {
        Protos.Status currentState = this.stateMachine.get();
        for (Protos.Status status : statusWanted) {
            if (currentState != status) continue;
            return true;
        }
        return false;
    }
}

