/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.executor;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.groupon.mesos.executor.ExecutorCallback;
import com.groupon.mesos.executor.ExecutorDriverContext;
import com.groupon.mesos.executor.ExecutorMessageEnvelope;
import com.groupon.mesos.executor.LocalExecutorMessageProcessor;
import com.groupon.mesos.util.CloseableExecutors;
import com.groupon.mesos.util.HttpProtocolReceiver;
import com.groupon.mesos.util.HttpProtocolSender;
import com.groupon.mesos.util.Log;
import com.groupon.mesos.util.ManagedEventBus;
import com.groupon.mesos.util.NetworkUtil;
import com.groupon.mesos.util.TimeUtil;
import com.groupon.mesos.util.UPID;
import com.groupon.mesos.util.UUIDUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import mesos.internal.Messages;
import org.apache.mesos.Executor;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;

public abstract class InternalExecutorDriver
implements ExecutorDriver,
Closeable {
    private static final Log LOG = Log.getLog(InternalExecutorDriver.class);
    private final Executor executor;
    private final HttpProtocolReceiver receiver;
    private final HttpProtocolSender sender;
    private final ScheduledExecutorService callbackExecutor;
    private final ManagedEventBus eventBus;
    private final LocalExecutorMessageProcessor localMessageProcessor;
    private final Closer closer = Closer.create();
    private final ExecutorDriverContext context;

    protected InternalExecutorDriver(Executor executor, UPID slaveUpid, Protos.SlaveID slaveId, Protos.FrameworkID frameworkId, Protos.ExecutorID executorId) throws IOException {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor is null");
        Preconditions.checkNotNull((Object)slaveUpid, (Object)"slaveUpid is null");
        Preconditions.checkNotNull((Object)slaveId, (Object)"slaveId is null");
        Preconditions.checkNotNull((Object)frameworkId, (Object)"frameworkId is null");
        Preconditions.checkNotNull((Object)executorId, (Object)"executorId is null");
        LOG.debug("Slave UPID:       %s", slaveUpid.asString());
        LOG.debug("Slave ID:         %s", slaveId.getValue());
        LOG.debug("Framework ID:     %s", frameworkId.getValue());
        LOG.debug("Executor ID:      %s", executorId.getValue());
        String hostName = NetworkUtil.findPublicIp();
        LOG.debug("Host name:        %s", hostName);
        this.context = new ExecutorDriverContext(hostName, slaveUpid, slaveId, frameworkId, executorId);
        this.eventBus = new ManagedEventBus("executor");
        this.localMessageProcessor = new LocalExecutorMessageProcessor(this.context, this.eventBus);
        this.callbackExecutor = (ScheduledExecutorService)((Object)this.closer.register((Closeable)CloseableExecutors.decorate(Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("executor-callback-%d").build()))));
        this.receiver = (HttpProtocolReceiver)this.closer.register((Closeable)new HttpProtocolReceiver(this.context.getDriverUPID(), ExecutorMessageEnvelope.class, this.eventBus));
        this.sender = (HttpProtocolSender)this.closer.register((Closeable)new HttpProtocolSender(this.context.getDriverUPID()));
        this.closer.register((Closeable)this.eventBus);
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    private void driverStart() {
        this.eventBus.register(this);
        this.eventBus.register(this.localMessageProcessor);
        this.receiver.start();
    }

    public Protos.Status start() {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_NOT_STARTED)) {
            return this.context.getStateMachine();
        }
        try {
            this.driverStart();
            Messages.RegisterExecutorMessage message = Messages.RegisterExecutorMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).setExecutorId(this.context.getExecutorId()).build();
            this.eventBus.post(new ExecutorMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getSlaveUPID(), (Message)message));
            this.context.setStateMachine(Protos.Status.DRIVER_RUNNING);
        }
        catch (Exception e) {
            this.context.setStateMachine(Protos.Status.DRIVER_ABORTED);
            LOG.error(e, "Failed to create executor process for '%s'", this.context.getSlaveUPID());
            this.eventBus.post(new ExecutorCallback(){

                @Override
                public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            String message = String.format("Failed to create scheduler process for '%s': %s", InternalExecutorDriver.this.context.getSlaveUPID(), e.getMessage());
                            LOG.debug("calling error(driver, %s)", message);
                            executor.error(executorDriver, message);
                        }
                    };
                }
            });
        }
        return this.context.getStateMachine();
    }

    public Protos.Status stop() {
        Protos.Status status = this.context.getStateMachine();
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING, Protos.Status.DRIVER_ABORTED)) {
            return status;
        }
        try {
            this.closer.close();
        }
        catch (IOException e) {
            LOG.warn(e, "While stopping", new Object[0]);
        }
        this.context.setStateMachine(Protos.Status.DRIVER_STOPPED);
        if (status != Protos.Status.DRIVER_ABORTED) {
            status = Protos.Status.DRIVER_STOPPED;
        }
        return status;
    }

    public Protos.Status abort() {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        this.context.setStateMachine(Protos.Status.DRIVER_ABORTED);
        return this.context.getStateMachine();
    }

    public Protos.Status join() {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        ListenableFuture<Protos.Status> statusFuture = this.context.waitForStateChange(Protos.Status.DRIVER_RUNNING);
        try {
            return (Protos.Status)statusFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            throw Throwables.propagate((Throwable)t);
        }
        return this.context.getStateMachine();
    }

    public Protos.Status run() {
        this.start();
        if (this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            this.join();
        }
        return this.context.getStateMachine();
    }

    public Protos.Status sendStatusUpdate(Protos.TaskStatus taskStatus) {
        Preconditions.checkNotNull((Object)taskStatus, (Object)"status is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        if (taskStatus.getState() == Protos.TaskState.TASK_STAGING) {
            LOG.error("Executor is not allowed to send TASK_STAGING status update. Aborting!", new Object[0]);
            this.eventBus.post(new ExecutorCallback(){

                @Override
                public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            executorDriver.abort();
                            String message = "Executor is not allowed to send TASK_STAGING status update. Aborting!";
                            LOG.debug("calling error(driver, %s)", "Executor is not allowed to send TASK_STAGING status update. Aborting!");
                            executor.error(executorDriver, "Executor is not allowed to send TASK_STAGING status update. Aborting!");
                        }
                    };
                }
            });
            return this.context.getStateMachine();
        }
        UUID uuid = UUID.randomUUID();
        long now = TimeUtil.currentTime();
        Messages.StatusUpdateMessage message = Messages.StatusUpdateMessage.newBuilder().setPid(this.context.getDriverUPID().asString()).setUpdate(Messages.StatusUpdate.newBuilder().setFrameworkId(this.context.getFrameworkId()).setExecutorId(this.context.getExecutorId()).setSlaveId(this.context.getSlaveId()).setStatus(Protos.TaskStatus.newBuilder((Protos.TaskStatus)taskStatus).setTimestamp((double)now)).setTimestamp(now).setUuid(UUIDUtil.uuidBytes(UUID.randomUUID()))).build();
        this.context.addUpdate(uuid, message.getUpdate());
        this.eventBus.post(new ExecutorMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getSlaveUPID(), (Message)message));
        return this.context.getStateMachine();
    }

    public Protos.Status sendFrameworkMessage(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"data is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.ExecutorToFrameworkMessage message = Messages.ExecutorToFrameworkMessage.newBuilder().setSlaveId(this.context.getSlaveId()).setFrameworkId(this.context.getFrameworkId()).setExecutorId(this.context.getExecutorId()).setData(ByteString.copyFrom((byte[])data)).build();
        this.eventBus.post(new ExecutorMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getSlaveUPID(), (Message)message));
        return this.context.getStateMachine();
    }

    @Subscribe
    public void sendMessage(ExecutorMessageEnvelope.RemoteMessageEnvelope envelope) throws Exception {
        Object message = envelope.getMessage();
        UPID recipient = envelope.getRecipient();
        Preconditions.checkState((!recipient.equals(this.context.getDriverUPID()) ? 1 : 0) != 0, (String)"Received a message with local recipient! (%s)", (Object[])new Object[]{message});
        this.sender.sendHttpMessage(recipient, (Message)message);
    }

    @Subscribe
    public void processExecutorCallback(ExecutorCallback callback) {
        this.callbackExecutor.submit(callback.getCallback(this.executor, this));
    }
}

