/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.executor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import com.google.protobuf.Message;
import com.groupon.mesos.executor.ExecutorCallback;
import com.groupon.mesos.executor.ExecutorDriverContext;
import com.groupon.mesos.executor.ExecutorMessageEnvelope;
import com.groupon.mesos.util.Log;
import com.groupon.mesos.util.ManagedEventBus;
import com.groupon.mesos.util.UUIDUtil;
import java.util.concurrent.ConcurrentMap;
import mesos.internal.Messages;
import org.apache.mesos.Executor;
import org.apache.mesos.ExecutorDriver;
import org.apache.mesos.Protos;

class LocalExecutorMessageProcessor {
    private static final Log LOG = Log.getLog(LocalExecutorMessageProcessor.class);
    private final ConcurrentMap<Protos.TaskID, Protos.TaskInfo> tasks = Maps.newConcurrentMap();
    private final ExecutorDriverContext context;
    private final ManagedEventBus eventBus;

    LocalExecutorMessageProcessor(ExecutorDriverContext context, ManagedEventBus eventBus) {
        this.context = (ExecutorDriverContext)Preconditions.checkNotNull((Object)context, (Object)"context is null");
        this.eventBus = (ManagedEventBus)Preconditions.checkNotNull((Object)eventBus, (Object)"eventBus is null");
    }

    @Subscribe
    public void executorRegistered(ExecutorMessageEnvelope.ExecutorRegisteredMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        final Messages.ExecutorRegisteredMessage message = (Messages.ExecutorRegisteredMessage)envelope.getMessage();
        this.eventBus.post(new ExecutorCallback(){

            @Override
            public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executor.registered(executorDriver, message.getExecutorInfo(), message.getFrameworkInfo(), message.getSlaveInfo());
                    }

                    public String toString() {
                        return "callback for registered()";
                    }
                };
            }
        });
    }

    @Subscribe
    public void executorReregistered(ExecutorMessageEnvelope.ExecutorReregisteredMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        final Messages.ExecutorReregisteredMessage message = (Messages.ExecutorReregisteredMessage)envelope.getMessage();
        this.eventBus.post(new ExecutorCallback(){

            @Override
            public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executor.reregistered(executorDriver, message.getSlaveInfo());
                    }

                    public String toString() {
                        return "callback for reregistered()";
                    }
                };
            }
        });
    }

    @Subscribe
    public void reconnectExecutor(ExecutorMessageEnvelope.ReconnectExecutorMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        Messages.ReconnectExecutorMessage message = (Messages.ReconnectExecutorMessage)envelope.getMessage();
        Preconditions.checkState((boolean)message.getSlaveId().equals((Object)this.context.getSlaveId()), (String)"Received reconnect from slave %s (expected %s)", (Object[])new Object[]{message.getSlaveId().getValue(), this.context.getSlaveId().getValue()});
        Messages.ReregisterExecutorMessage.Builder builder = Messages.ReregisterExecutorMessage.newBuilder().setExecutorId(this.context.getExecutorId()).setFrameworkId(this.context.getFrameworkId()).addAllUpdates(this.context.getUpdates()).addAllTasks(this.tasks.values());
        this.eventBus.post(new ExecutorMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getSlaveUPID(), (Message)builder.build()));
    }

    @Subscribe
    public void runTask(ExecutorMessageEnvelope.RunTaskMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        Messages.RunTaskMessage message = (Messages.RunTaskMessage)envelope.getMessage();
        final Protos.TaskInfo task = message.getTask();
        Preconditions.checkState((!this.tasks.containsKey(task.getTaskId()) ? 1 : 0) != 0, (String)"Task %s already started!", (Object[])new Object[]{task.getTaskId().getValue()});
        this.tasks.put(task.getTaskId(), task);
        this.eventBus.post(new ExecutorCallback(){

            @Override
            public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executor.launchTask(executorDriver, task);
                    }

                    public String toString() {
                        return "callback for launchTask()";
                    }
                };
            }
        });
    }

    @Subscribe
    public void killTask(ExecutorMessageEnvelope.KillTaskMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        final Messages.KillTaskMessage message = (Messages.KillTaskMessage)envelope.getMessage();
        this.eventBus.post(new ExecutorCallback(){

            @Override
            public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executor.killTask(executorDriver, message.getTaskId());
                    }

                    public String toString() {
                        return "callback for killTask()";
                    }
                };
            }
        });
    }

    @Subscribe
    public void statusUpdateAcknowledgement(ExecutorMessageEnvelope.StatusUpdateAcknowledgementMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        Messages.StatusUpdateAcknowledgementMessage message = (Messages.StatusUpdateAcknowledgementMessage)envelope.getMessage();
        this.context.removeUpdate(UUIDUtil.bytesUuid(message.getUuid()));
        this.tasks.remove(message.getTaskId());
    }

    @Subscribe
    public void frameworkToExecutor(ExecutorMessageEnvelope.FrameworkToExecutorMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        final Messages.FrameworkToExecutorMessage message = (Messages.FrameworkToExecutorMessage)envelope.getMessage();
        this.eventBus.post(new ExecutorCallback(){

            @Override
            public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executor.frameworkMessage(executorDriver, message.getData().toByteArray());
                    }

                    public String toString() {
                        return "callback for frameworkMessage()";
                    }
                };
            }
        });
    }

    @Subscribe
    public void shutdownExecutor(ExecutorMessageEnvelope.ShutdownExecutorMessageEnvelope envelope) {
        Preconditions.checkState((boolean)envelope.getRecipient().equals(this.context.getDriverUPID()), (Object)"Received a remote message for local delivery");
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.warn("driver is aborted!", new Object[0]);
            return;
        }
        this.eventBus.post(new ExecutorCallback(){

            @Override
            public Runnable getCallback(final Executor executor, final ExecutorDriver executorDriver) {
                return new Runnable(){

                    @Override
                    public void run() {
                        executorDriver.abort();
                        executor.shutdown(executorDriver);
                    }

                    public String toString() {
                        return "callback for abort()";
                    }
                };
            }
        });
    }
}

