/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.groupon.mesos.scheduler.LocalSchedulerMessageProcessor;
import com.groupon.mesos.scheduler.SchedulerCallback;
import com.groupon.mesos.scheduler.SchedulerDriverContext;
import com.groupon.mesos.scheduler.SchedulerMessageEnvelope;
import com.groupon.mesos.util.CloseableExecutors;
import com.groupon.mesos.util.HttpProtocolReceiver;
import com.groupon.mesos.util.HttpProtocolSender;
import com.groupon.mesos.util.Log;
import com.groupon.mesos.util.ManagedEventBus;
import com.groupon.mesos.util.NetworkUtil;
import com.groupon.mesos.util.TimeUtil;
import com.groupon.mesos.util.UPID;
import com.groupon.mesos.util.UUIDUtil;
import com.groupon.mesos.zookeeper.ZookeeperMasterDetector;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mesos.internal.Messages;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

public abstract class InternalSchedulerDriver
implements SchedulerDriver,
Closeable {
    private static final Log LOG = Log.getLog(InternalSchedulerDriver.class);
    private final Scheduler scheduler;
    private final Protos.Credential credential;
    private final ZookeeperMasterDetector detector;
    private final LocalSchedulerMessageProcessor localMessageProcessor;
    private final HttpProtocolReceiver receiver;
    private final HttpProtocolSender sender;
    private final ScheduledExecutorService callbackExecutor;
    private final ManagedEventBus eventBus;
    private final Closer closer = Closer.create();
    private final SchedulerDriverContext context;
    private final FutureCallback<Protos.MasterInfo> masterInfoCallback = new FutureCallback<Protos.MasterInfo>(){

        public void onSuccess(Protos.MasterInfo masterInfo) {
            InternalSchedulerDriver.this.masterChanged(masterInfo);
        }

        public void onFailure(Throwable t) {
            LOG.warn(t, "Master detection failed!", new Object[0]);
            InternalSchedulerDriver.this.masterChanged(null);
        }
    };

    protected InternalSchedulerDriver(Scheduler scheduler, Protos.FrameworkInfo frameworkInfo, String master, Protos.Credential credential) throws IOException {
        this.scheduler = (Scheduler)Preconditions.checkNotNull((Object)scheduler, (Object)"scheduler is null");
        Preconditions.checkNotNull((Object)frameworkInfo, (Object)"frameworkInfo is null");
        Preconditions.checkNotNull((Object)master, (Object)"master is null");
        this.credential = credential;
        Preconditions.checkState((!master.equals("local") ? 1 : 0) != 0, (Object)"Java client can not launch a local cluster!");
        Preconditions.checkState((this.credential == null ? 1 : 0) != 0, (Object)"Credential is not supported yet.");
        Protos.FrameworkInfo.Builder frameworkInfoBuilder = Protos.FrameworkInfo.newBuilder((Protos.FrameworkInfo)frameworkInfo);
        if (!frameworkInfo.hasHostname()) {
            frameworkInfoBuilder.setHostname(NetworkUtil.findPublicIp());
        }
        if (!frameworkInfo.hasUser() || "".equals(frameworkInfo.getUser())) {
            frameworkInfoBuilder.setUser(System.getProperty("user.name"));
        }
        this.context = new SchedulerDriverContext(frameworkInfoBuilder.build());
        this.eventBus = new ManagedEventBus("scheduler");
        this.localMessageProcessor = new LocalSchedulerMessageProcessor(this.context, this.eventBus);
        this.callbackExecutor = (ScheduledExecutorService)((Object)this.closer.register((Closeable)CloseableExecutors.decorate(Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("scheduler-callback-%d").build()))));
        this.receiver = (HttpProtocolReceiver)this.closer.register((Closeable)new HttpProtocolReceiver(this.context.getDriverUPID(), SchedulerMessageEnvelope.class, this.eventBus));
        this.sender = (HttpProtocolSender)this.closer.register((Closeable)new HttpProtocolSender(this.context.getDriverUPID()));
        this.closer.register((Closeable)this.eventBus);
        this.detector = (ZookeeperMasterDetector)this.closer.register((Closeable)new ZookeeperMasterDetector(master, this.eventBus));
    }

    @Override
    public void close() throws IOException {
        this.stop();
    }

    private void driverStart() {
        this.eventBus.register(this.localMessageProcessor);
        this.eventBus.register(this.detector);
        this.eventBus.register(this);
        this.receiver.start();
        this.detector.start();
    }

    public Protos.Status start() {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_NOT_STARTED)) {
            return this.context.getStateMachine();
        }
        try {
            this.driverStart();
            this.masterChanged(null);
            this.context.setStateMachine(Protos.Status.DRIVER_RUNNING);
        }
        catch (Exception e) {
            this.context.setStateMachine(Protos.Status.DRIVER_ABORTED);
            LOG.error(e, "Failed to create scheduler process for '%s'", this.context.getDriverUPID());
            this.eventBus.post(new SchedulerCallback(){

                @Override
                public Runnable getCallback(final Scheduler scheduler, final SchedulerDriver schedulerDriver) {
                    return new Runnable(){

                        @Override
                        public void run() {
                            scheduler.error(schedulerDriver, String.format("Failed to create scheduler process for '%s': %s", InternalSchedulerDriver.this.context.getDriverUPID(), e.getMessage()));
                        }
                    };
                }
            });
        }
        return this.context.getStateMachine();
    }

    public Protos.Status stop() {
        return this.stop(false);
    }

    public Protos.Status stop(boolean failover) {
        Protos.Status status = this.context.getStateMachine();
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING, Protos.Status.DRIVER_ABORTED)) {
            return status;
        }
        if (this.context.isConnected() && !failover) {
            Messages.UnregisterFrameworkMessage message = Messages.UnregisterFrameworkMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).build();
            this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)message));
        }
        try {
            this.closer.close();
        }
        catch (IOException e) {
            LOG.warn(e, "While stopping", new Object[0]);
        }
        this.context.setStateMachine(Protos.Status.DRIVER_STOPPED);
        if (status != Protos.Status.DRIVER_ABORTED) {
            status = Protos.Status.DRIVER_STOPPED;
        }
        return status;
    }

    public Protos.Status abort() {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        if (this.context.isConnected()) {
            Messages.DeactivateFrameworkMessage message = Messages.DeactivateFrameworkMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).build();
            this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)message));
        }
        this.context.setStateMachine(Protos.Status.DRIVER_ABORTED);
        return this.context.getStateMachine();
    }

    public Protos.Status join() {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        ListenableFuture<Protos.Status> statusFuture = this.context.waitForStateChange(Protos.Status.DRIVER_RUNNING);
        try {
            return (Protos.Status)statusFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            throw Throwables.propagate((Throwable)t);
        }
        return this.context.getStateMachine();
    }

    public Protos.Status run() {
        this.start();
        if (this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            this.join();
        }
        return this.context.getStateMachine();
    }

    public Protos.Status killTask(Protos.TaskID taskId) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.KillTaskMessage message = Messages.KillTaskMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).setTaskId(taskId).build();
        this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)message));
        return this.context.getStateMachine();
    }

    public Protos.Status launchTasks(Protos.OfferID offerId, Collection<Protos.TaskInfo> tasks) {
        Preconditions.checkNotNull((Object)offerId, (Object)"offerId is null");
        Preconditions.checkNotNull(tasks, (Object)"tasks is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.LaunchTasksMessage message = Messages.LaunchTasksMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addOfferIds(offerId).addAllTasks(tasks).setFilters(Protos.Filters.newBuilder().build()).build();
        this.doLaunchTasks(message);
        return this.context.getStateMachine();
    }

    public Protos.Status launchTasks(Protos.OfferID offerId, Collection<Protos.TaskInfo> tasks, Protos.Filters filters) {
        Preconditions.checkNotNull((Object)offerId, (Object)"offerId is null");
        Preconditions.checkNotNull(tasks, (Object)"tasks is null");
        Preconditions.checkNotNull((Object)filters, (Object)"filters is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.LaunchTasksMessage message = Messages.LaunchTasksMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addOfferIds(offerId).addAllTasks(tasks).setFilters(filters).build();
        this.doLaunchTasks(message);
        return this.context.getStateMachine();
    }

    public Protos.Status launchTasks(Collection<Protos.OfferID> offerIds, Collection<Protos.TaskInfo> tasks) {
        Preconditions.checkNotNull(offerIds, (Object)"offerIds is null");
        Preconditions.checkNotNull(tasks, (Object)"tasks is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.LaunchTasksMessage message = Messages.LaunchTasksMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addAllOfferIds(offerIds).addAllTasks(tasks).setFilters(Protos.Filters.newBuilder().build()).build();
        this.doLaunchTasks(message);
        return this.context.getStateMachine();
    }

    public Protos.Status launchTasks(Collection<Protos.OfferID> offerIds, Collection<Protos.TaskInfo> tasks, Protos.Filters filters) {
        Preconditions.checkNotNull(offerIds, (Object)"offerIds is null");
        Preconditions.checkNotNull(tasks, (Object)"tasks is null");
        Preconditions.checkNotNull((Object)filters, (Object)"filters is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.LaunchTasksMessage message = Messages.LaunchTasksMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addAllOfferIds(offerIds).addAllTasks(tasks).setFilters(filters).build();
        this.doLaunchTasks(message);
        return this.context.getStateMachine();
    }

    public Protos.Status declineOffer(Protos.OfferID offerId, Protos.Filters filters) {
        Preconditions.checkNotNull((Object)offerId, (Object)"offerId is null");
        Preconditions.checkNotNull((Object)filters, (Object)"filters is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.LaunchTasksMessage message = Messages.LaunchTasksMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addOfferIds(offerId).setFilters(filters).build();
        this.doLaunchTasks(message);
        return this.context.getStateMachine();
    }

    public Protos.Status declineOffer(Protos.OfferID offerId) {
        Preconditions.checkNotNull((Object)offerId, (Object)"offerId is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.LaunchTasksMessage message = Messages.LaunchTasksMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addOfferIds(offerId).setFilters(Protos.Filters.newBuilder().build()).build();
        this.doLaunchTasks(message);
        return this.context.getStateMachine();
    }

    public Protos.Status reviveOffers() {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.ReviveOffersMessage message = Messages.ReviveOffersMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).build();
        this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)message));
        return this.context.getStateMachine();
    }

    public Protos.Status sendFrameworkMessage(Protos.ExecutorID executorId, Protos.SlaveID slaveId, byte[] data) {
        Preconditions.checkNotNull((Object)executorId, (Object)"executorId is null");
        Preconditions.checkNotNull((Object)slaveId, (Object)"slaveId is null");
        Preconditions.checkNotNull((Object)data, (Object)"data is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.FrameworkToExecutorMessage message = Messages.FrameworkToExecutorMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).setExecutorId(executorId).setSlaveId(slaveId).setData(ByteString.copyFrom((byte[])data)).build();
        if (this.context.containsSlave(message.getSlaveId())) {
            UPID slave = this.context.getSlaveUPID(message.getSlaveId());
            this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), slave, (Message)message));
        } else {
            this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)message));
        }
        return this.context.getStateMachine();
    }

    public Protos.Status reconcileTasks(Collection<Protos.TaskStatus> statuses) {
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.ReconcileTasksMessage message = Messages.ReconcileTasksMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addAllStatuses(statuses).build();
        this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)message));
        return this.context.getStateMachine();
    }

    public Protos.Status requestResources(Collection<Protos.Request> requests) {
        Preconditions.checkNotNull(requests, (Object)"requests is null");
        if (!this.context.isStateMachine(Protos.Status.DRIVER_RUNNING)) {
            return this.context.getStateMachine();
        }
        Messages.ResourceRequestMessage message = Messages.ResourceRequestMessage.newBuilder().setFrameworkId(this.context.getFrameworkId()).addAllRequests(requests).build();
        this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)message));
        return this.context.getStateMachine();
    }

    @Subscribe
    public void sendMessage(SchedulerMessageEnvelope.RemoteMessageEnvelope envelope) throws Exception {
        Object message = envelope.getMessage();
        UPID recipient = envelope.getRecipient();
        Preconditions.checkState((!recipient.equals(this.context.getDriverUPID()) ? 1 : 0) != 0, (String)"Received a message with local recipient! (%s)", (Object[])new Object[]{message});
        this.sender.sendHttpMessage(recipient, (Message)message);
    }

    @Subscribe
    public void processSchedulerCallback(SchedulerCallback callback) {
        this.callbackExecutor.submit(callback.getCallback(this.scheduler, this));
    }

    /*
     * WARNING - void declaration
     */
    private void doLaunchTasks(Messages.LaunchTasksMessage message) {
        Protos.MasterInfo masterInfo = this.context.connectedMaster();
        if (masterInfo == null) {
            this.loseAllTasks(message.getTasksList(), "Master disconnected");
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Protos.TaskInfo taskInfo : message.getTasksList()) {
            void var5_5;
            if (taskInfo.hasExecutor() == taskInfo.hasCommand()) {
                this.loseTask(taskInfo, "TaskInfo must have either an 'executor' or a 'command'");
                continue;
            }
            if (taskInfo.hasExecutor()) {
                if (taskInfo.getExecutor().hasFrameworkId()) {
                    Protos.FrameworkID executorFrameworkId = taskInfo.getExecutor().getFrameworkId();
                    if (!executorFrameworkId.equals((Object)this.context.getFrameworkId())) {
                        this.loseTask(taskInfo, String.format("ExecutorInfo has an invalid FrameworkID (Actual: %s vs Expected: %s)", executorFrameworkId.getValue(), this.context.getFrameworkId().getValue()));
                        continue;
                    }
                } else {
                    Protos.TaskInfo taskInfo2 = Protos.TaskInfo.newBuilder((Protos.TaskInfo)taskInfo).setExecutor(Protos.ExecutorInfo.newBuilder((Protos.ExecutorInfo)taskInfo.getExecutor()).setFrameworkId(this.context.getFrameworkId())).build();
                }
            }
            builder.add((Object)var5_5);
        }
        ImmutableList launchTasks = builder.build();
        for (Protos.OfferID offer : message.getOfferIdsList()) {
            if (!this.context.hasOffers(offer)) {
                LOG.warn("Unknown offer %s ignored!", offer.getValue());
            }
            for (Protos.TaskInfo launchTask : launchTasks) {
                if (!this.context.hasOffer(offer, launchTask.getSlaveId())) continue;
                this.context.addSlave(launchTask.getSlaveId(), this.context.getOffer(offer, launchTask.getSlaveId()));
            }
            this.context.removeAllOffers(offer);
        }
        Messages.LaunchTasksMessage launchTasksMessage = Messages.LaunchTasksMessage.newBuilder(message).setFrameworkId(this.context.getFrameworkId()).clearTasks().addAllTasks((Iterable<? extends Protos.TaskInfo>)launchTasks).build();
        this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(this.context.getDriverUPID(), this.context.getMasterUPID(), (Message)launchTasksMessage));
    }

    private void loseAllTasks(Iterable<Protos.TaskInfo> taskInfos, String reason) {
        for (Protos.TaskInfo taskInfo : taskInfos) {
            this.loseTask(taskInfo, reason);
        }
    }

    private void loseTask(Protos.TaskInfo taskInfo, String reason) {
        Messages.StatusUpdateMessage statusUpdate = Messages.StatusUpdateMessage.newBuilder().setUpdate(Messages.StatusUpdate.newBuilder().setFrameworkId(this.context.getFrameworkId()).setSlaveId(taskInfo.getSlaveId()).setExecutorId(taskInfo.getExecutor().getExecutorId()).setStatus(Protos.TaskStatus.newBuilder().setTaskId(taskInfo.getTaskId()).setState(Protos.TaskState.TASK_LOST).setMessage(reason)).setTimestamp(TimeUtil.currentTime()).setUuid(UUIDUtil.uuidBytes(UUID.randomUUID()))).build();
        this.eventBus.post(new SchedulerMessageEnvelope.StatusUpdateMessageEnvelope(this.context.getDriverUPID(), this.context.getDriverUPID(), statusUpdate));
    }

    private void masterChanged(Protos.MasterInfo masterInfo) {
        if (this.context.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.debug("driver is aborted!", new Object[0]);
            return;
        }
        try {
            if (masterInfo != null) {
                LOG.debug("Master detected: %s", UPID.create(masterInfo.getPid()).asString());
            } else {
                LOG.debug("No master detected.", new Object[0]);
            }
            this.context.setMaster(masterInfo);
            if (this.context.disconnected()) {
                this.callbackExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        InternalSchedulerDriver.this.scheduler.disconnected((SchedulerDriver)InternalSchedulerDriver.this);
                    }
                });
            }
            if (masterInfo != null) {
                this.callbackExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Protos.MasterInfo master = InternalSchedulerDriver.this.context.getMaster();
                        if (InternalSchedulerDriver.this.context.isConnected() || master == null) {
                            return;
                        }
                        Protos.FrameworkInfo frameworkInfo = InternalSchedulerDriver.this.context.getFrameworkInfo();
                        if (!InternalSchedulerDriver.this.context.hasFrameworkId()) {
                            Messages.RegisterFrameworkMessage message = Messages.RegisterFrameworkMessage.newBuilder().setFramework(frameworkInfo).build();
                            InternalSchedulerDriver.this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(InternalSchedulerDriver.this.context.getDriverUPID(), InternalSchedulerDriver.this.context.getMasterUPID(), (Message)message));
                        } else {
                            Messages.ReregisterFrameworkMessage message = Messages.ReregisterFrameworkMessage.newBuilder().setFramework(frameworkInfo).setFailover(InternalSchedulerDriver.this.context.isFailover()).build();
                            InternalSchedulerDriver.this.eventBus.post(new SchedulerMessageEnvelope.RemoteMessageEnvelope(InternalSchedulerDriver.this.context.getDriverUPID(), InternalSchedulerDriver.this.context.getMasterUPID(), (Message)message));
                        }
                        InternalSchedulerDriver.this.callbackExecutor.schedule(this, 1L, TimeUnit.SECONDS);
                    }
                });
            }
        }
        finally {
            ListenableFuture<Protos.MasterInfo> masterFuture = this.detector.detect(masterInfo);
            Futures.addCallback(masterFuture, this.masterInfoCallback);
        }
    }
}

