/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.groupon.mesos.util.Log;
import com.groupon.mesos.util.NetworkUtil;
import com.groupon.mesos.util.UPID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.mesos.Protos;

class SchedulerDriverContext {
    private static final Log LOG = Log.getLog(SchedulerDriverContext.class);
    private final AtomicReference<Protos.Status> stateMachine = new AtomicReference<Protos.Status>(Protos.Status.DRIVER_NOT_STARTED);
    private final AtomicReference<Protos.FrameworkInfo> frameworkInfo = new AtomicReference();
    private final AtomicReference<Protos.MasterInfo> masterInfo = new AtomicReference();
    private final AtomicReference<UPID> masterUpid = new AtomicReference();
    private final BlockingQueue<SettableFuture<Protos.Status>> stateMachineFutures = new LinkedBlockingQueue<SettableFuture<Protos.Status>>();
    private final AtomicBoolean connected = new AtomicBoolean();
    private final AtomicBoolean failover = new AtomicBoolean(false);
    private final UPID driverUpid;
    private final Table<Protos.OfferID, Protos.SlaveID, UPID> offerCache = HashBasedTable.create();
    private final Map<Protos.SlaveID, UPID> slaveCache = new ConcurrentHashMap<Protos.SlaveID, UPID>(16, 0.75f, 3);

    SchedulerDriverContext(Protos.FrameworkInfo frameworkInfo) throws IOException {
        this.frameworkInfo.set((Protos.FrameworkInfo)Preconditions.checkNotNull((Object)frameworkInfo, (Object)"frameworkInfo is null"));
        this.driverUpid = UPID.fromParts(UUID.randomUUID().toString(), HostAndPort.fromParts((String)frameworkInfo.getHostname(), (int)NetworkUtil.findUnusedPort()));
        this.failover.set(SchedulerDriverContext.hasFrameworkId(frameworkInfo));
    }

    UPID getDriverUPID() {
        return this.driverUpid;
    }

    boolean connected() {
        return this.connected.getAndSet(true);
    }

    boolean disconnected() {
        return this.connected.getAndSet(false);
    }

    boolean isConnected() {
        return this.connected.get();
    }

    void setFailover(boolean failover) {
        this.failover.set(failover);
    }

    boolean isFailover() {
        return this.failover.get();
    }

    synchronized Protos.MasterInfo getMaster() {
        return this.masterInfo.get();
    }

    synchronized Protos.MasterInfo connectedMaster() {
        if (this.isStateMachine(Protos.Status.DRIVER_ABORTED)) {
            LOG.debug("driver is aborted!", new Object[0]);
            return null;
        }
        if (!this.isConnected()) {
            LOG.debug("Not connected!", new Object[0]);
            return null;
        }
        return this.masterInfo.get();
    }

    synchronized void setMaster(Protos.MasterInfo newMasterInfo) {
        this.masterInfo.set(newMasterInfo);
        this.masterUpid.set(newMasterInfo == null ? null : UPID.create(newMasterInfo.getPid()));
    }

    synchronized UPID getMasterUPID() {
        return this.masterUpid.get();
    }

    void setFrameworkId(Protos.FrameworkID frameworkId) {
        Preconditions.checkNotNull((Object)frameworkId, (Object)"frameworkId is null");
        this.frameworkInfo.set(Protos.FrameworkInfo.newBuilder((Protos.FrameworkInfo)this.frameworkInfo.get()).setId(frameworkId).build());
    }

    Protos.FrameworkID getFrameworkId() {
        return this.frameworkInfo.get().getId();
    }

    boolean hasFrameworkId() {
        return SchedulerDriverContext.hasFrameworkId(this.frameworkInfo.get());
    }

    Protos.FrameworkInfo getFrameworkInfo() {
        return this.frameworkInfo.get();
    }

    synchronized void setStateMachine(Protos.Status status) {
        Protos.Status oldStatus = this.stateMachine.getAndSet(status);
        if (status != oldStatus) {
            ArrayList settableFutures = new ArrayList(this.stateMachineFutures.size());
            this.stateMachineFutures.drainTo(settableFutures);
            for (SettableFuture future : settableFutures) {
                future.set((Object)status);
            }
        }
    }

    synchronized Protos.Status getStateMachine() {
        return this.stateMachine.get();
    }

    synchronized ListenableFuture<Protos.Status> waitForStateChange(Protos.Status expectedStatus) {
        SettableFuture future = SettableFuture.create();
        if (!this.isStateMachine(expectedStatus)) {
            future.set((Object)this.stateMachine.get());
        } else {
            this.stateMachineFutures.add((SettableFuture<Protos.Status>)future);
        }
        return future;
    }

    synchronized boolean isStateMachine(Protos.Status ... statusWanted) {
        Protos.Status currentState = this.stateMachine.get();
        for (Protos.Status status : statusWanted) {
            if (currentState != status) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOffer(Protos.OfferID offerId, Protos.SlaveID slaveId, UPID pid) {
        Table<Protos.OfferID, Protos.SlaveID, UPID> table = this.offerCache;
        synchronized (table) {
            this.offerCache.put((Object)offerId, (Object)slaveId, (Object)pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllOffers(Protos.OfferID offerId) {
        Table<Protos.OfferID, Protos.SlaveID, UPID> table = this.offerCache;
        synchronized (table) {
            this.offerCache.row((Object)offerId).clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasOffers(Protos.OfferID offerId) {
        Table<Protos.OfferID, Protos.SlaveID, UPID> table = this.offerCache;
        synchronized (table) {
            return this.offerCache.containsRow((Object)offerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasOffer(Protos.OfferID offerId, Protos.SlaveID slaveId) {
        Table<Protos.OfferID, Protos.SlaveID, UPID> table = this.offerCache;
        synchronized (table) {
            return this.offerCache.contains((Object)offerId, (Object)slaveId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UPID getOffer(Protos.OfferID offerId, Protos.SlaveID slaveId) {
        Table<Protos.OfferID, Protos.SlaveID, UPID> table = this.offerCache;
        synchronized (table) {
            return (UPID)this.offerCache.get((Object)offerId, (Object)slaveId);
        }
    }

    void addSlave(Protos.SlaveID slaveId, UPID upid) {
        this.slaveCache.put(slaveId, upid);
    }

    void removeSlave(Protos.SlaveID slaveId) {
        this.slaveCache.remove(slaveId);
    }

    boolean containsSlave(Protos.SlaveID slaveId) {
        return this.slaveCache.containsKey(slaveId);
    }

    UPID getSlaveUPID(Protos.SlaveID slaveId) {
        return this.slaveCache.get(slaveId);
    }

    private static boolean hasFrameworkId(Protos.FrameworkInfo frameworkInfo) {
        return frameworkInfo.hasId() && !"".equals(frameworkInfo.getId().getValue());
    }
}

