/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.groupon.mesos.state.JVariable;
import com.groupon.mesos.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import mesos.internal.state.State;
import org.apache.mesos.state.State;
import org.apache.mesos.state.Variable;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;
import org.iq80.leveldb.impl.Iq80DBFactory;

public class JLevelDBState
implements State,
Closeable {
    private static final Log LOG = Log.getLog(JLevelDBState.class);
    private final DB db;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("JLevelDB-State-%d").build());

    public JLevelDBState(String path) throws IOException {
        Preconditions.checkNotNull((Object)path, (Object)"path is null");
        Options options = new Options();
        options.createIfMissing(true);
        this.db = Iq80DBFactory.factory.open(new File(path), options);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.db.close();
        }
    }

    public Future<Variable> fetch(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        return this.executor.submit(new Callable<Variable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Variable call() throws Exception {
                String internedName;
                String string = internedName = name.intern();
                synchronized (string) {
                    JVariable var = JLevelDBState.this.load(name);
                    if (var == null) {
                        return new JVariable(name, JVariable.EMPTY_BYTES);
                    }
                    return var;
                }
            }
        });
    }

    public Future<Variable> store(Variable variable) {
        Preconditions.checkNotNull((Object)variable, (Object)"variable is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        Preconditions.checkState((boolean)(variable instanceof JVariable), (Object)"can not process native variable, use JVariable");
        final JVariable v = (JVariable)variable;
        return this.executor.submit(new Callable<Variable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Variable call() throws Exception {
                String internedName;
                WriteOptions writeOptions = new WriteOptions();
                writeOptions.sync(true);
                String string = internedName = v.getName().intern();
                synchronized (string) {
                    JVariable current = JLevelDBState.this.load(internedName);
                    if (current == null || current.getUuid().equals(v.getUuid())) {
                        JVariable update = new JVariable(internedName, v.value());
                        WriteBatch writeBatch = JLevelDBState.this.db.createWriteBatch();
                        writeBatch.delete(Iq80DBFactory.bytes((String)internedName));
                        writeBatch.put(Iq80DBFactory.bytes((String)internedName), update.getEntry().toByteArray());
                        JLevelDBState.this.db.write(writeBatch, writeOptions);
                        return update;
                    }
                    return null;
                }
            }
        });
    }

    public Future<Boolean> expunge(Variable variable) {
        Preconditions.checkNotNull((Object)variable, (Object)"variable is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        Preconditions.checkState((boolean)(variable instanceof JVariable), (Object)"can not process native variable, use JVariable");
        final JVariable v = (JVariable)variable;
        return this.executor.submit(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                String internedName;
                WriteOptions writeOptions = new WriteOptions();
                writeOptions.sync(true);
                String string = internedName = v.getName().intern();
                synchronized (string) {
                    JVariable current = JLevelDBState.this.load(internedName);
                    if (current != null && current.getUuid().equals(v.getUuid())) {
                        JLevelDBState.this.db.delete(Iq80DBFactory.bytes((String)internedName));
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            }
        });
    }

    public Future<Iterator<String>> names() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        return this.executor.submit(new Callable<Iterator<String>>(){

            @Override
            public Iterator<String> call() throws Exception {
                return new ClosingIterator(JLevelDBState.this.db.iterator());
            }
        });
    }

    private JVariable load(String name) throws IOException {
        byte[] value = this.db.get(Iq80DBFactory.bytes((String)name));
        if (value == null) {
            return null;
        }
        State.Entry entry = State.Entry.parseFrom(value);
        return new JVariable(entry);
    }

    private static class ClosingIterator
    extends AbstractIterator<String>
    implements Iterator<String>,
    Closeable {
        private final DBIterator dbIterator;
        private final AtomicBoolean closed = new AtomicBoolean();

        private ClosingIterator(DBIterator dbIterator) {
            this.dbIterator = (DBIterator)Preconditions.checkNotNull((Object)dbIterator, (Object)"dbIterator is null");
            this.dbIterator.seekToFirst();
        }

        protected String computeNext() {
            if (!this.closed.get() && this.dbIterator.hasNext()) {
                Map.Entry value = (Map.Entry)this.dbIterator.next();
                return Iq80DBFactory.asString((byte[])((byte[])value.getKey()));
            }
            if (!this.closed.getAndSet(true)) {
                try {
                    this.dbIterator.close();
                }
                catch (IOException ioe) {
                    LOG.warn(ioe, "while closing iterator", new Object[0]);
                }
            }
            return (String)this.endOfData();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                this.dbIterator.close();
            }
        }
    }
}

