/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.state;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.groupon.mesos.util.UUIDUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import mesos.internal.state.State;
import org.apache.mesos.state.Variable;

public class JVariable
extends Variable {
    static final byte[] EMPTY_BYTES = new byte[0];
    private final State.Entry entry;

    JVariable(String name, byte[] value) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        this.entry = State.Entry.newBuilder().setName(name).setValue(ByteString.copyFrom((byte[])value)).setUuid(UUIDUtil.uuidBytes(UUID.randomUUID())).build();
    }

    JVariable(State.Entry entry) {
        this.entry = entry;
    }

    public byte[] value() {
        return this.entry.getValue().toByteArray();
    }

    String getName() {
        return this.entry.getName();
    }

    UUID getUuid() {
        return UUIDUtil.bytesUuid(this.entry.getUuid());
    }

    State.Entry getEntry() {
        return this.entry;
    }

    public Variable mutate(byte[] value) {
        Preconditions.checkNotNull((Object)value, (Object)"value is null");
        return new JVariable(State.Entry.newBuilder().setName(this.entry.getName()).setValue(ByteString.copyFrom((byte[])value)).setUuid(this.entry.getUuid()).build());
    }

    @SuppressFBWarnings(value={"FI_NULLIFY_SUPER"})
    protected void finalize() {
    }
}

