/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.state;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.groupon.mesos.state.JVariable;
import com.groupon.mesos.state.ZookeeperVariable;
import com.groupon.mesos.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import mesos.internal.state.State;
import org.apache.mesos.state.State;
import org.apache.mesos.state.Variable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class JZookeeperState
implements State,
Closeable {
    private static final Log LOG = Log.getLog(JZookeeperState.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ExecutorService executor = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("JZookeeper-State-%d").build());
    private final ZooKeeper client;
    private final String path;

    public JZookeeperState(String servers, long timeout, TimeUnit unit, String znode) throws IOException {
        this(servers, timeout, unit, znode, null, null);
    }

    public JZookeeperState(String servers, long timeout, TimeUnit unit, String znode, String scheme, byte[] credentials) throws IOException {
        Preconditions.checkNotNull((Object)servers, (Object)"servers is null");
        Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit is null");
        Preconditions.checkNotNull((Object)znode, (Object)"znode is null");
        Preconditions.checkState((scheme == null && credentials == null ? 1 : 0) != 0, (Object)"Authentication is currently not supported!");
        this.client = new ZooKeeper(servers, Ints.checkedCast((long)unit.toMillis(timeout)), (Watcher)new StateWatcher());
        String path = znode.startsWith("/") ? znode : "/" + znode;
        this.path = path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        try {
            if (this.client.exists(path, false) == null) {
                LOG.debug("Creating Zookeeper path: %s", path);
                try {
                    this.client.create(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException e) {
                    LOG.debug("Node %s already exists", path);
                }
            }
        }
        catch (KeeperException e) {
            LOG.warn(e, "While creating path %s", path);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.getAndSet(true)) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                this.client.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public Future<Variable> fetch(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        return this.executor.submit(new Callable<Variable>(){

            @Override
            public Variable call() throws Exception {
                ZookeeperVariable var = JZookeeperState.this.load(JZookeeperState.this.getFullPath(name));
                if (var == null) {
                    return new ZookeeperVariable(name, JVariable.EMPTY_BYTES);
                }
                return var;
            }
        });
    }

    public Future<Variable> store(Variable variable) {
        Preconditions.checkNotNull((Object)variable, (Object)"variable is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        Preconditions.checkState((boolean)(variable instanceof ZookeeperVariable), (Object)"can not process native variable, use ZookeeperVariable");
        final ZookeeperVariable v = (ZookeeperVariable)variable;
        Preconditions.checkState((v.asBytes().length < 0x100000 ? 1 : 0) != 0, (Object)"Entry size exceeds 1 MB");
        final String fullName = this.getFullPath(v.getName());
        return this.executor.submit(new Callable<Variable>(){

            @Override
            public Variable call() throws Exception {
                ZookeeperVariable update = new ZookeeperVariable(v.getName(), v.value());
                ZookeeperVariable current = JZookeeperState.this.load(fullName);
                while (true) {
                    if (current == null) {
                        LOG.debug("Node %s does not exist", fullName);
                        try {
                            JZookeeperState.this.client.create(fullName, update.asBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                            LOG.debug("Node %s successfully created", fullName);
                            return update;
                        }
                        catch (KeeperException.NodeExistsException e) {
                            LOG.debug("Lost Node %s race, reloading", fullName);
                            current = JZookeeperState.this.load(fullName);
                        }
                    }
                    if (current != null) {
                        if (!current.getUuid().equals(v.getUuid())) {
                            return null;
                        }
                        Preconditions.checkState((current.getZookeeperVersion() != null ? 1 : 0) != 0, (String)"store with unknown zookeeper version (%s)", (Object[])new Object[]{current.getEntry()});
                        try {
                            JZookeeperState.this.client.setData(fullName, update.asBytes(), current.getZookeeperVersion().intValue());
                            return update;
                        }
                        catch (KeeperException.BadVersionException | KeeperException.NoNodeException e) {
                            LOG.debug("Could not change version %d, retry writing", current.getZookeeperVersion());
                        }
                    }
                    current = JZookeeperState.this.load(fullName);
                }
            }
        });
    }

    public Future<Boolean> expunge(Variable variable) {
        Preconditions.checkNotNull((Object)variable, (Object)"variable is null");
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        Preconditions.checkState((boolean)(variable instanceof ZookeeperVariable), (Object)"can not process native variable, use ZookeeperVariable");
        final ZookeeperVariable v = (ZookeeperVariable)variable;
        final String fullName = this.getFullPath(v.getName());
        return this.executor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                ZookeeperVariable current = JZookeeperState.this.load(fullName);
                while (current != null) {
                    if (!current.getUuid().equals(v.getUuid())) {
                        return false;
                    }
                    Preconditions.checkState((current.getZookeeperVersion() != null ? 1 : 0) != 0, (String)"expunge with unknown zookeeper version (%s)", (Object[])new Object[]{current.getEntry()});
                    try {
                        JZookeeperState.this.client.delete(fullName, current.getZookeeperVersion().intValue());
                        return true;
                    }
                    catch (KeeperException.BadVersionException | KeeperException.NoNodeException e) {
                        LOG.debug("Could not change version %d, retry expunging", current.getZookeeperVersion());
                        current = JZookeeperState.this.load(fullName);
                        continue;
                    }
                    break;
                }
                return false;
            }
        });
    }

    public Future<Iterator<String>> names() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0, (Object)"already closed");
        return this.executor.submit(new Callable<Iterator<String>>(){

            @Override
            public Iterator<String> call() throws Exception {
                List children = JZookeeperState.this.client.getChildren(JZookeeperState.this.path, false);
                return children.iterator();
            }
        });
    }

    private ZookeeperVariable load(String name) throws KeeperException, IOException {
        Stat stat = new Stat();
        try {
            State.Entry entry = State.Entry.parseFrom(this.client.getData(name, false, stat));
            return new ZookeeperVariable(entry, stat.getVersion());
        }
        catch (KeeperException.NoNodeException e) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private String getFullPath(String name) {
        return String.format("%s/%s", this.path, name);
    }

    private static class StateWatcher
    implements Watcher {
        private StateWatcher() {
        }

        public void process(WatchedEvent event) {
            LOG.info("Received watched event %s", event);
        }
    }
}

