/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class CloseableExecutors {
    private CloseableExecutors() {
        throw new AssertionError((Object)"do not instantiate");
    }

    public static CloseableExecutorServiceDecorator decorate(ExecutorService service) {
        return new CloseableExecutorServiceDecorator(service);
    }

    public static CloseableScheduledExecutorServiceDecorator decorate(ScheduledExecutorService service) {
        return new CloseableScheduledExecutorServiceDecorator(service);
    }

    private static class CloseableScheduledExecutorServiceDecorator
    extends CloseableExecutorServiceDecorator
    implements ScheduledExecutorService {
        private final ScheduledExecutorService delegate;

        CloseableScheduledExecutorServiceDecorator(ScheduledExecutorService delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public void close() {
            this.delegate.shutdown();
        }

        @Override
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            return this.delegate.schedule(command, delay, unit);
        }

        @Override
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            return this.delegate.schedule(callable, delay, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
        }

        @Override
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
        }
    }

    private static class CloseableExecutorServiceDecorator
    extends AbstractExecutorService
    implements Closeable {
        private final ExecutorService delegate;

        CloseableExecutorServiceDecorator(ExecutorService delegate) {
            this.delegate = (ExecutorService)Preconditions.checkNotNull((Object)delegate, (Object)"delegate is null");
        }

        @Override
        public void close() {
            this.delegate.shutdown();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public void execute(Runnable command) {
            this.delegate.execute(command);
        }
    }
}

