/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.util;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.groupon.mesos.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class ManagedEventBus
implements Closeable {
    private final AsyncEventBus eventBus;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final AtomicReference<PoisonPill> pillHolder = new AtomicReference<PoisonPill>(new PoisonPill());
    private final ExecutorService executor;

    public ManagedEventBus(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        this.executor = Executors.newScheduledThreadPool(10, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("eventbus-" + name + "-%d").build());
        this.eventBus = new AsyncEventBus((Executor)this.executor, (SubscriberExceptionHandler)new EventBusExceptionHandler(name));
    }

    public void register(Object listener) {
        Preconditions.checkState((!this.finished.get() ? 1 : 0) != 0, (Object)"event bus is shut down");
        this.eventBus.register(listener);
    }

    public void post(Object event) {
        Preconditions.checkState((!this.finished.get() ? 1 : 0) != 0, (Object)"event bus is shut down");
        this.eventBus.post(event);
    }

    @Override
    public void close() throws IOException {
        if (!this.finished.getAndSet(true)) {
            this.eventBus.register((Object)this);
            PoisonPill pill = this.pillHolder.getAndSet(null);
            if (pill != null) {
                this.eventBus.post((Object)pill);
                try {
                    pill.awaitTermination(1L, TimeUnit.DAYS);
                    this.executor.shutdown();
                    this.executor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    @Subscribe
    public void receivePoisonPill(PoisonPill poisonPill) {
        poisonPill.trigger();
    }

    public static class EventBusExceptionHandler
    implements SubscriberExceptionHandler {
        public static final Log LOG = Log.getLog(EventBusExceptionHandler.class);
        private final String name;

        public EventBusExceptionHandler(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name is null");
        }

        public void handleException(Throwable e, SubscriberExceptionContext context) {
            LOG.error(e, "Could not call %s/%s on bus %s", context.getSubscriber().getClass().getSimpleName(), context.getSubscriberMethod().getName(), this.name);
        }
    }

    public static class PoisonPill {
        private final SettableFuture<Void> future = SettableFuture.create();

        public void trigger() {
            this.future.set(null);
        }

        public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            try {
                this.future.get(timeout, unit);
            }
            catch (ExecutionException | TimeoutException e) {
                return;
            }
        }
    }
}

