/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.groupon.mesos.state.JVariable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.mesos.state.State;
import org.apache.mesos.state.Variable;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractTestState {
    protected abstract State getState();

    @Test
    public void testNonExistentValue() throws Exception {
        State state = this.getState();
        Variable empty = (Variable)state.fetch("does-not-exist").get();
        Assert.assertNotNull((Object)empty);
        Assert.assertTrue((empty.value().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetAndGet() throws Exception {
        State state = this.getState();
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        Variable var = (Variable)state.fetch("someValue").get();
        Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
        Variable newVar = var.mutate(value);
        JVariable storedVar = (JVariable)state.store(newVar).get();
        Assert.assertNotNull((Object)storedVar);
        JVariable retrievedVar = (JVariable)state.fetch("someValue").get();
        Assert.assertNotNull((Object)retrievedVar);
        Assert.assertArrayEquals((byte[])newVar.value(), (byte[])retrievedVar.value());
        Assert.assertArrayEquals((byte[])storedVar.value(), (byte[])retrievedVar.value());
        Assert.assertEquals((Object)storedVar.getName(), (Object)retrievedVar.getName());
        Assert.assertEquals((Object)storedVar.getUuid(), (Object)retrievedVar.getUuid());
    }

    @Test
    public void testNames() throws Exception {
        State state = this.getState();
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (int i = 0; i < 10; ++i) {
            String key = "name-" + UUID.randomUUID().toString();
            builder.add((Object)key);
            Variable var = (Variable)state.fetch(key).get();
            Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
            state.store(var.mutate(value)).get();
        }
        ImmutableSortedSet keys = builder.build();
        Iterator it = (Iterator)state.names().get();
        ImmutableSortedSet entries = ImmutableSortedSet.copyOf((Iterator)it);
        Assert.assertEquals((Object)keys, (Object)entries);
    }

    @Test
    public void testUpdateOk() throws Exception {
        State state = this.getState();
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        byte[] newValue = "Ich esse Autos zum Abendbrot und mache Kopfsprung ins Sandbecken. Gruen. Rot. Pferderennen.".getBytes(StandardCharsets.UTF_8);
        Variable var = (Variable)state.fetch("someValue").get();
        Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
        JVariable storedVar = (JVariable)state.store(var.mutate(value)).get();
        storedVar = (JVariable)state.store(storedVar.mutate(newValue)).get();
        Assert.assertNotNull((Object)storedVar);
        JVariable retrievedVar = (JVariable)state.fetch("someValue").get();
        Assert.assertNotNull((Object)retrievedVar);
        Assert.assertArrayEquals((byte[])storedVar.value(), (byte[])retrievedVar.value());
        Assert.assertEquals((Object)storedVar.getName(), (Object)retrievedVar.getName());
        Assert.assertEquals((Object)storedVar.getUuid(), (Object)retrievedVar.getUuid());
    }

    @Test
    public void testOldUpdateRefused() throws Exception {
        State state = this.getState();
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        byte[] newValue = "Ich esse Autos zum Abendbrot und mache Kopfsprung ins Sandbecken. Gruen. Rot. Pferderennen.".getBytes(StandardCharsets.UTF_8);
        Variable var = (Variable)state.fetch("someValue").get();
        Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
        JVariable storedVar = (JVariable)state.store(var.mutate(value)).get();
        storedVar = (JVariable)state.store(var.mutate(newValue)).get();
        Assert.assertNull((Object)storedVar);
    }

    @Test
    public void testExpungeOk() throws Exception {
        State state = this.getState();
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        Variable var = (Variable)state.fetch("someValue").get();
        Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
        JVariable storedVar = (JVariable)state.store(var.mutate(value)).get();
        boolean expunged = (Boolean)state.expunge((Variable)storedVar).get();
        Assert.assertTrue((boolean)expunged);
        JVariable retrievedVar = (JVariable)state.fetch("someValue").get();
        Assert.assertNotNull((Object)retrievedVar);
        Assert.assertEquals((long)0L, (long)retrievedVar.value().length);
    }

    @Test
    public void testOldExpungeRefused() throws Exception {
        State state = this.getState();
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        Variable var = (Variable)state.fetch("someValue").get();
        Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
        JVariable storedVar = (JVariable)state.store(var.mutate(value)).get();
        boolean expunged = (Boolean)state.expunge(var).get();
        Assert.assertFalse((boolean)expunged);
        JVariable retrievedVar = (JVariable)state.fetch("someValue").get();
        Assert.assertNotNull((Object)retrievedVar);
        Assert.assertArrayEquals((byte[])storedVar.value(), (byte[])retrievedVar.value());
        Assert.assertEquals((Object)storedVar.getName(), (Object)retrievedVar.getName());
        Assert.assertEquals((Object)storedVar.getUuid(), (Object)retrievedVar.getUuid());
    }

    @Test
    public void testExpungeNonExistentValue() throws Exception {
        State state = this.getState();
        Variable empty = (Variable)state.fetch("does-not-exist").get();
        Assert.assertNotNull((Object)empty);
        Assert.assertTrue((empty.value().length == 0 ? 1 : 0) != 0);
        boolean expunged = (Boolean)state.expunge(empty).get();
        Assert.assertFalse((boolean)expunged);
    }

    @Test
    public void testTenMonkeysPressTenKeys() throws Exception {
        final State state = this.getState();
        final byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        final byte[] newValue = "Ich esse Autos zum Abendbrot und mache Kopfsprung ins Sandbecken. Gruen. Rot. Pferderennen.".getBytes(StandardCharsets.UTF_8);
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            builder.add((Object)executor.submit((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    String key = "key-" + UUID.randomUUID().toString();
                    Variable var = (Variable)state.fetch(key).get();
                    Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
                    JVariable storedVar = (JVariable)state.store(var.mutate(value)).get();
                    storedVar = (JVariable)state.store(storedVar.mutate(newValue)).get();
                    Assert.assertNotNull((Object)storedVar);
                    JVariable retrievedVar = (JVariable)state.fetch(key).get();
                    Assert.assertNotNull((Object)retrievedVar);
                    Assert.assertArrayEquals((byte[])storedVar.value(), (byte[])retrievedVar.value());
                    Assert.assertEquals((Object)storedVar.getName(), (Object)retrievedVar.getName());
                    Assert.assertEquals((Object)storedVar.getUuid(), (Object)retrievedVar.getUuid());
                    return key;
                }
            }));
        }
        List keys = (List)Futures.allAsList((Iterable)builder.build()).get();
        for (String key : keys) {
            JVariable retrievedVar = (JVariable)state.fetch(key).get();
            Assert.assertNotNull((Object)retrievedVar);
            Assert.assertArrayEquals((byte[])newValue, (byte[])retrievedVar.value());
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
    }

    @Test
    public void testTenMonkeysHammerOnTenKeys() throws Exception {
        State state = this.getState();
        byte[] value = "The quick brown fox jumps over the lazy dog.".getBytes(StandardCharsets.UTF_8);
        byte[] newValue = "Ich esse Autos zum Abendbrot und mache Kopfsprung ins Sandbecken. Gruen. Rot. Pferderennen.".getBytes(StandardCharsets.UTF_8);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ImmutableList.Builder varBuilder = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            String key = "key-" + UUID.randomUUID().toString();
            Variable var = (Variable)state.fetch(key).get();
            Assert.assertTrue((var.value().length == 0 ? 1 : 0) != 0);
            Variable storedVar = (Variable)state.store(var.mutate(value)).get();
            Assert.assertNotNull((Object)storedVar);
            builder.add((Object)key);
            varBuilder.add((Object)storedVar);
        }
        ImmutableSet keys = builder.build();
        ImmutableList variables = varBuilder.build();
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            resultBuilder.add((Object)executor.submit((Callable)new Callable<Integer>((List)variables, state, newValue){
                final /* synthetic */ List val$variables;
                final /* synthetic */ State val$state;
                final /* synthetic */ byte[] val$newValue;
                {
                    this.val$variables = list;
                    this.val$state = state;
                    this.val$newValue = byArray;
                }

                @Override
                public Integer call() throws Exception {
                    ArrayList vars = new ArrayList(this.val$variables);
                    Collections.shuffle(vars);
                    int updateCount = 0;
                    for (Variable var : vars) {
                        Variable storedVar = (Variable)this.val$state.store(var.mutate(this.val$newValue)).get();
                        if (storedVar == null) continue;
                        ++updateCount;
                        Thread.sleep(2L);
                    }
                    return updateCount;
                }
            }));
        }
        List results = (List)Futures.allAsList((Iterable)resultBuilder.build()).get();
        int finalTally = 0;
        for (Integer result : results) {
            finalTally += result.intValue();
        }
        Assert.assertEquals((long)10L, (long)finalTally);
        for (String key : keys) {
            Variable retrievedVar = (Variable)state.fetch(key).get();
            Assert.assertNotNull((Object)retrievedVar);
            Assert.assertArrayEquals((byte[])newValue, (byte[])retrievedVar.value());
        }
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
    }
}

