/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.mesos.testutil;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.groupon.mesos.util.NetworkUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;

public class EmbeddedZookeeper
implements Closeable {
    private final int port;
    private final File zkDataDir;
    private final ZooKeeperServer zkServer;
    private final NIOServerCnxn.Factory cnxnFactory;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();

    public EmbeddedZookeeper() throws IOException {
        this(NetworkUtil.findUnusedPort());
    }

    public EmbeddedZookeeper(int port) throws IOException {
        this.port = port;
        this.zkDataDir = Files.createTempDir();
        this.zkServer = new ZooKeeperServer();
        FileTxnSnapLog ftxn = new FileTxnSnapLog(this.zkDataDir, this.zkDataDir);
        this.zkServer.setTxnLogFactory(ftxn);
        this.cnxnFactory = new NIOServerCnxn.Factory(new InetSocketAddress(this.port), 0);
    }

    public void start() throws InterruptedException, IOException {
        if (!this.started.getAndSet(true)) {
            this.cnxnFactory.startup(this.zkServer);
        }
    }

    @Override
    public void close() {
        if (this.started.get() && !this.stopped.getAndSet(true)) {
            this.cnxnFactory.shutdown();
            try {
                this.cnxnFactory.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.zkServer.isRunning()) {
                this.zkServer.shutdown();
            }
        }
    }

    public String getConnectString() {
        return "127.0.0.1:" + Integer.toString(this.port);
    }

    public int getPort() {
        return this.port;
    }

    public void cleanup() {
        Preconditions.checkState((boolean)this.stopped.get(), (Object)"not stopped");
        for (File file : Files.fileTreeTraverser().postOrderTraversal((Object)this.zkDataDir)) {
            file.delete();
        }
    }
}

