/*
 * Decompiled with CFR 0.152.
 */
package com.gu.googleauth;

import cats.ApplicativeError;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.instances.package;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import com.gu.googleauth.Actions$;
import com.gu.googleauth.GoogleAuth$;
import com.gu.googleauth.GoogleAuthConfig;
import com.gu.googleauth.GoogleAuthException;
import com.gu.googleauth.GoogleAuthFilters$;
import com.gu.googleauth.GoogleGroupChecker;
import com.gu.googleauth.UserIdentity;
import com.gu.googleauth.UserIdentity$;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.Serializable;
import play.api.Logging;
import play.api.MarkerContext$;
import play.api.libs.json.Json$;
import play.api.libs.ws.WSClient;
import play.api.mvc.Call;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005eca\u0002\b\u0010!\u0003\r\tA\u0006\u0005\u0006K\u0001!\tA\n\u0005\u0006U\u00011\u0019a\u000b\u0005\u0006i\u00011\t!\u000e\u0005\bu\u0001\u0011\rQ\"\u0001<\u0011\u001d\u0011\u0005A1A\u0007\u0002mBQa\u0011\u0001\u0005\u0002\u0011CQ!\u0017\u0001\u0005\u0002iCQA\u001b\u0001\u0005\u0002-D\u0011\"a\u0005\u0001#\u0003%\t!!\u0006\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u00111\u0006\u0001\u0005\u0002\u0005U\u0002bBA\"\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003\u001f\u0002A\u0011AA)\u00051aunZ5o'V\u0004\bo\u001c:u\u0015\t\u0001\u0012#\u0001\u0006h_><G.Z1vi\"T!AE\n\u0002\u0005\u001d,(\"\u0001\u000b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\n1!\u00199j\u0015\u0005\u0011\u0013\u0001\u00029mCfL!\u0001J\u0010\u0003\u000f1{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012a\n\t\u00031!J!!K\r\u0003\tUs\u0017\u000e^\u0001\toN\u001cE.[3oiV\tA\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005\u0011qo\u001d\u0006\u0003c}\tA\u0001\\5cg&\u00111G\f\u0002\t/N\u001bE.[3oi\u0006Q\u0011-\u001e;i\u0007>tg-[4\u0016\u0003Y\u0002\"a\u000e\u001d\u000e\u0003=I!!O\b\u0003!\u001d{wn\u001a7f\u0003V$\bnQ8oM&<\u0017!\u00064bS2,(/\u001a*fI&\u0014Xm\u0019;UCJ<W\r^\u000b\u0002yA\u0011Q\bQ\u0007\u0002})\u0011qhH\u0001\u0004[Z\u001c\u0017BA!?\u0005\u0011\u0019\u0015\r\u001c7\u0002+\u0011,g-Y;miJ+G-\u001b:fGR$\u0016M]4fi\u0006\u00012\u000f^1si\u001e{wn\u001a7f\u0019><\u0017N\u001c\u000b\u0002\u000bR\u0019ai\u0014+\u0011\u0007\u001dSE*D\u0001I\u0015\tI\u0015$\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u0013%\u0003\r\u0019+H/\u001e:f!\tiT*\u0003\u0002O}\t1!+Z:vYRDQ\u0001\u0015\u0004A\u0004E\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0002>%&\u00111K\u0010\u0002\u000e%\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\t\u000bU3\u00019\u0001,\u0002\u0005\u0015\u001c\u0007CA$X\u0013\tA\u0006J\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006i1\r[3dW&#WM\u001c;jif$\u0012a\u0017\u000b\u00049\"L\u0007#B/cI2+W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00023bi\u0006T\u0011!Y\u0001\u0005G\u0006$8/\u0003\u0002d=\n9Q)\u001b;iKJ$\u0006CA$K!\t9d-\u0003\u0002h\u001f\taQk]3s\u0013\u0012,g\u000e^5us\")\u0001k\u0002a\u0002#\")Qk\u0002a\u0002-\u0006\u0019RM\u001c4pe\u000e,wi\\8hY\u0016<%o\\;qgR9A\u000e\u001d:\u0002\u0006\u0005=AcA7o_B)QL\u00193MO!)\u0001\u000b\u0003a\u0002#\")Q\u000b\u0003a\u0002-\")\u0011\u000f\u0003a\u0001K\u0006aQo]3s\u0013\u0012,g\u000e^5us\")1\u000f\u0003a\u0001i\u0006!\"/Z9vSJ,GmR8pO2,wI]8vaN\u00042!\u001e?\u0000\u001d\t1(\u0010\u0005\u0002x35\t\u0001P\u0003\u0002z+\u00051AH]8pizJ!a_\r\u0002\rA\u0013X\rZ3g\u0013\tihPA\u0002TKRT!a_\r\u0011\u0007U\f\t!C\u0002\u0002\u0004y\u0014aa\u0015;sS:<\u0007bBA\u0004\u0011\u0001\u0007\u0011\u0011B\u0001\u0013O>|w\r\\3He>,\bo\u00115fG.,'\u000fE\u00028\u0003\u0017I1!!\u0004\u0010\u0005I9un\\4mK\u001e\u0013x.\u001e9DQ\u0016\u001c7.\u001a:\t\u0011\u0005E\u0001\u0002%AA\u0002}\fA\"\u001a:s_JlUm]:bO\u0016\fQ$\u001a8g_J\u001cWmR8pO2,wI]8vaN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003/Q3a`A\rW\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\u0013Ut7\r[3dW\u0016$'bAA\u00133\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0012q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00069s_\u000e,7o](bkRD'gQ1mY\n\f7m\u001b\u000b\u0003\u0003_!RARA\u0019\u0003gAQ\u0001\u0015\u0006A\u0004ECQ!\u0016\u0006A\u0004Y#b!a\u000e\u0002>\u0005}B#\u0002$\u0002:\u0005m\u0002\"\u0002)\f\u0001\b\t\u0006\"B+\f\u0001\b1\u0006\"B:\f\u0001\u0004!\bbBA!\u0017\u0001\u0007\u0011\u0011B\u0001\rOJ|W\u000f]\"iK\u000e\\WM]\u0001\u0012e\u0016$\u0017N]3di^KG\u000f[#se>\u0014H#\u0002'\u0002H\u0005-\u0003BBA%\u0019\u0001\u0007A(\u0001\u0004uCJ<W\r\u001e\u0005\u0007\u0003\u001bb\u0001\u0019A@\u0002\u000f5,7o]1hK\u0006Q2/\u001a;vaN+7o]5p]^CWM\\*vG\u000e,7o\u001d4vYR!\u00111KA,)\ra\u0015Q\u000b\u0005\u0006!6\u0001\u001d!\u0015\u0005\u0006c6\u0001\r!\u001a")
public interface LoginSupport
extends Logging {
    public WSClient wsClient();

    public GoogleAuthConfig authConfig();

    public Call failureRedirectTarget();

    public Call defaultRedirectTarget();

    public static /* synthetic */ Future startGoogleLogin$(LoginSupport $this, RequestHeader request, ExecutionContext ec) {
        return $this.startGoogleLogin(request, ec);
    }

    default public Future<Result> startGoogleLogin(RequestHeader request, ExecutionContext ec) {
        return this.authConfig().antiForgeryChecker().ensureUserHasSessionId((Function1<String, Future<Result>>)(Function1 & Serializable & scala.Serializable)sessionId -> GoogleAuth$.MODULE$.redirectToGoogle(this.authConfig(), (String)sessionId, request, ec, this.wsClient()), request, ec);
    }

    public static /* synthetic */ EitherT checkIdentity$(LoginSupport $this, RequestHeader request, ExecutionContext ec) {
        return $this.checkIdentity(request, ec);
    }

    default public EitherT<Future, Result, UserIdentity> checkIdentity(RequestHeader request, ExecutionContext ec) {
        return ApplicativeErrorOps$.MODULE$.attemptT$extension(package.applicativeError$.MODULE$.catsSyntaxApplicativeError(GoogleAuth$.MODULE$.validatedUserIdentity(this.authConfig(), request, ec, this.wsClient()), (ApplicativeError)package.future$.MODULE$.catsStdInstancesForFuture(ec)), (ApplicativeError)package.future$.MODULE$.catsStdInstancesForFuture(ec)).leftSemiflatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Throwable throwable = x0$1;
            if (throwable instanceof ExpiredJwtException) {
                ExpiredJwtException expiredJwtException = (ExpiredJwtException)throwable;
                this.logWarn$1("resend-user-with-expired-anti-forgery-token-to-google", (Throwable)expiredJwtException);
                future = this.startGoogleLogin(request, ec);
            } else if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                this.logWarn$1("anti-forgery-token-invalid", illegalArgumentException);
                future = Future$.MODULE$.successful((Object)this.redirectWithError(this.failureRedirectTarget(), "The anti forgery token is not valid"));
            } else if (throwable instanceof GoogleAuthException) {
                GoogleAuthException googleAuthException = (GoogleAuthException)throwable;
                this.logWarn$1("GoogleAuthException", googleAuthException);
                future = Future$.MODULE$.successful((Object)this.redirectWithError(this.failureRedirectTarget(), googleAuthException.getMessage()));
            } else if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logWarn$1(throwable2.getClass().getSimpleName(), throwable2);
                future = Future$.MODULE$.successful((Object)this.redirectWithError(this.failureRedirectTarget(), throwable2.getMessage()));
            } else {
                throw new MatchError((Object)throwable);
            }
            return future;
        }, (Monad)package.future$.MODULE$.catsStdInstancesForFuture(ec));
    }

    public static /* synthetic */ EitherT enforceGoogleGroups$(LoginSupport $this, UserIdentity userIdentity, Set requiredGoogleGroups, GoogleGroupChecker googleGroupChecker, String errorMessage, RequestHeader request, ExecutionContext ec) {
        return $this.enforceGoogleGroups(userIdentity, (Set<String>)requiredGoogleGroups, googleGroupChecker, errorMessage, request, ec);
    }

    default public EitherT<Future, Result, BoxedUnit> enforceGoogleGroups(UserIdentity userIdentity, Set<String> requiredGoogleGroups, GoogleGroupChecker googleGroupChecker, String errorMessage, RequestHeader request, ExecutionContext ec) {
        return ApplicativeErrorOps$.MODULE$.attemptT$extension(package.applicativeError$.MODULE$.catsSyntaxApplicativeError(googleGroupChecker.retrieveGroupsFor(userIdentity.email(), ec), (ApplicativeError)package.future$.MODULE$.catsStdInstancesForFuture(ec)), (ApplicativeError)package.future$.MODULE$.catsStdInstancesForFuture(ec)).leftMap((Function1 & Serializable & scala.Serializable)t -> {
            this.logger().warn((Function0 & Serializable & scala.Serializable)() -> "Login failure, Could not look up user's Google groups", (Function0 & Serializable & scala.Serializable)() -> t, MarkerContext$.MODULE$.NoMarker());
            return this.redirectWithError(this.failureRedirectTarget(), "Login failure. Unable to look up Google Group membership");
        }, (Functor)package.future$.MODULE$.catsStdInstancesForFuture(ec)).subflatMap((Function1 & Serializable & scala.Serializable)userGroups -> {
            Right right;
            if (Actions$.MODULE$.checkGoogleGroups((Set<String>)userGroups, requiredGoogleGroups)) {
                right = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            } else {
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Login failure, user not in required Google groups", MarkerContext$.MODULE$.NoMarker());
                right = package$.MODULE$.Left().apply((Object)this.redirectWithError(this.failureRedirectTarget(), errorMessage));
            }
            return right;
        }, (Functor)package.future$.MODULE$.catsStdInstancesForFuture(ec));
    }

    public static /* synthetic */ String enforceGoogleGroups$default$4$(LoginSupport $this) {
        return $this.enforceGoogleGroups$default$4();
    }

    default public String enforceGoogleGroups$default$4() {
        return "Login failure. You do not belong to the required Google groups";
    }

    public static /* synthetic */ Future processOauth2Callback$(LoginSupport $this, RequestHeader request, ExecutionContext ec) {
        return $this.processOauth2Callback(request, ec);
    }

    default public Future<Result> processOauth2Callback(RequestHeader request, ExecutionContext ec) {
        return (Future)this.checkIdentity(request, ec).map((Function1 & Serializable & scala.Serializable)identity -> this.setupSessionWhenSuccessful((UserIdentity)identity, request), (Functor)package.future$.MODULE$.catsStdInstancesForFuture(ec)).merge(Predef$.MODULE$.$conforms(), (Functor)package.future$.MODULE$.catsStdInstancesForFuture(ec));
    }

    public static /* synthetic */ Future processOauth2Callback$(LoginSupport $this, Set requiredGoogleGroups, GoogleGroupChecker groupChecker, RequestHeader request, ExecutionContext ec) {
        return $this.processOauth2Callback((Set<String>)requiredGoogleGroups, groupChecker, request, ec);
    }

    default public Future<Result> processOauth2Callback(Set<String> requiredGoogleGroups, GoogleGroupChecker groupChecker, RequestHeader request, ExecutionContext ec) {
        return (Future)this.checkIdentity(request, ec).flatMap((Function1 & Serializable & scala.Serializable)identity -> this.enforceGoogleGroups((UserIdentity)identity, requiredGoogleGroups, groupChecker, this.enforceGoogleGroups$default$4(), request, ec).map((Function1 & Serializable & scala.Serializable)_ -> this.setupSessionWhenSuccessful((UserIdentity)identity, request), (Functor)package.future$.MODULE$.catsStdInstancesForFuture(ec)), (Monad)package.future$.MODULE$.catsStdInstancesForFuture(ec)).merge(Predef$.MODULE$.$conforms(), (Functor)package.future$.MODULE$.catsStdInstancesForFuture(ec));
    }

    public static /* synthetic */ Result redirectWithError$(LoginSupport $this, Call target, String message) {
        return $this.redirectWithError(target, message);
    }

    default public Result redirectWithError(Call target, String message) {
        return Results$.MODULE$.Redirect(target).flashing((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)new StringBuilder(15).append("Login failure. ").append(message).toString())}));
    }

    public static /* synthetic */ Result setupSessionWhenSuccessful$(LoginSupport $this, UserIdentity userIdentity, RequestHeader request) {
        return $this.setupSessionWhenSuccessful(userIdentity, request);
    }

    default public Result setupSessionWhenSuccessful(UserIdentity userIdentity, RequestHeader request) {
        Result result;
        Option option = request.session().get(GoogleAuthFilters$.MODULE$.LOGIN_ORIGIN_KEY());
        if (option instanceof Some) {
            Some some = (Some)option;
            String url = (String)some.value();
            result = Results$.MODULE$.Redirect(url, Results$.MODULE$.Redirect$default$2(), Results$.MODULE$.Redirect$default$3());
        } else if (None$.MODULE$.equals(option)) {
            result = Results$.MODULE$.Redirect(this.defaultRedirectTarget());
        } else {
            throw new MatchError((Object)option);
        }
        Result redirect = result;
        return redirect.withSession(request.session().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)UserIdentity$.MODULE$.KEY()), (Object)Json$.MODULE$.toJson((Object)userIdentity, UserIdentity$.MODULE$.userIdentityFormats()).toString())).$minus(GoogleAuthFilters$.MODULE$.LOGIN_ORIGIN_KEY()));
    }

    private void logWarn$1(String desc, Throwable e) {
        this.logger().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append(this.getClass().getSimpleName()).append(" : failed-oauth-callback : ").append(desc).append(" : '").append(e.getMessage()).append("'").toString(), (Function0 & Serializable & scala.Serializable)() -> e, MarkerContext$.MODULE$.NoMarker());
    }

    public static void $init$(LoginSupport $this) {
    }
}

