/*
 * Decompiled with CFR 0.152.
 */
package com.gu.googleauth;

import com.gu.googleauth.DiscoveryDocument;
import com.gu.googleauth.DiscoveryDocument$;
import com.gu.googleauth.Error$;
import com.gu.googleauth.GoogleAuthConfig;
import com.gu.googleauth.GoogleAuthException;
import com.gu.googleauth.GoogleAuthException$;
import com.gu.googleauth.JsonWebToken;
import com.gu.googleauth.JwtClaims;
import com.gu.googleauth.Token;
import com.gu.googleauth.Token$;
import com.gu.googleauth.UserIdentity;
import com.gu.googleauth.UserIdentity$;
import com.gu.googleauth.UserInfo;
import com.gu.googleauth.UserInfo$;
import java.io.Serializable;
import java.time.Clock;
import play.api.libs.json.JsLookup$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsValue$;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import play.api.libs.ws.package$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxesRunTime;

public final class GoogleAuth$ {
    public static GoogleAuth$ MODULE$;
    private Option<Future<DiscoveryDocument>> discoveryDocumentHolder;

    static {
        new GoogleAuth$();
    }

    public Option<Future<DiscoveryDocument>> discoveryDocumentHolder() {
        return this.discoveryDocumentHolder;
    }

    public void discoveryDocumentHolder_$eq(Option<Future<DiscoveryDocument>> x$1) {
        this.discoveryDocumentHolder = x$1;
    }

    public Future<DiscoveryDocument> discoveryDocument(ExecutionContext context, WSClient ws) {
        if (this.discoveryDocumentHolder().isDefined()) {
            return (Future)this.discoveryDocumentHolder().get();
        }
        Future discoveryDocumentFuture = ws.url(DiscoveryDocument$.MODULE$.url()).get().map((Function1 & Serializable & scala.Serializable)r -> DiscoveryDocument$.MODULE$.fromJson(r.json()), context);
        this.discoveryDocumentHolder_$eq((Option<Future<DiscoveryDocument>>)new Some((Object)discoveryDocumentFuture));
        return discoveryDocumentFuture;
    }

    public <T> T googleResponse(WSResponse r, Function1<JsValue, T> block) {
        int n = r.status();
        switch (n) {
            default: 
        }
        if (n >= 400) {
            Option error = JsLookup$.MODULE$.$bslash$extension1(JsValue$.MODULE$.jsValueToJsLookup(r.json()), "error").asOpt(Error$.MODULE$.errorReads());
            return (T)error.map((Function1 & Serializable & scala.Serializable)e -> {
                throw new GoogleAuthException(new StringBuilder(27).append("Error when calling Google: ").append(e.message()).toString(), GoogleAuthException$.MODULE$.$lessinit$greater$default$2());
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new GoogleAuthException(new StringBuilder(50).append("Unknown error when calling Google [status=").append(n).append(", body=").append(r.body()).append("]").toString(), GoogleAuthException$.MODULE$.$lessinit$greater$default$2());
            });
        }
        return (T)block.apply((Object)r.json());
    }

    private Option<String> hdParameter(List<String> domains) {
        List<String> list = domains;
        if (Nil$.MODULE$.equals(list)) {
            return None$.MODULE$;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String domain = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return new Some((Object)domain);
            }
        }
        return new Some((Object)"*");
    }

    public Future<Result> redirectToGoogle(GoogleAuthConfig config, String sessionId, RequestHeader request, ExecutionContext context, WSClient ws) {
        Option<UserIdentity> userIdentity = UserIdentity$.MODULE$.fromRequest(request);
        Tuple2[] tuple2Array = new Tuple2[5];
        tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)new .colon.colon((Object)config.clientId(), (List)Nil$.MODULE$));
        tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"response_type"), (Object)new .colon.colon((Object)"code", (List)Nil$.MODULE$));
        tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scope"), (Object)new .colon.colon((Object)"openid email profile", (List)Nil$.MODULE$));
        tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"redirect_uri"), (Object)new .colon.colon((Object)config.redirectUrl(), (List)Nil$.MODULE$));
        String x$1 = sessionId;
        Clock x$22 = config.antiForgeryChecker().generateToken$default$2(x$1);
        tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)new .colon.colon((Object)config.antiForgeryChecker().generateToken(x$1, x$22), (List)Nil$.MODULE$));
        Map queryString = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.hdParameter(config.domains()).map((Function1 & Serializable & scala.Serializable)domain -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hd"), (Object)new .colon.colon(domain, (List)Nil$.MODULE$))))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(config.maxAuthAge().map((Function1 & Serializable & scala.Serializable)age -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_auth_age"), (Object)new .colon.colon((Object)String.valueOf(BoxesRunTime.boxToLong((long)age.getStandardSeconds())), (List)Nil$.MODULE$))))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(config.prompt().map((Function1 & Serializable & scala.Serializable)prompt -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prompt"), (Object)new .colon.colon(prompt, (List)Nil$.MODULE$))))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(userIdentity.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.email()).map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"login_hint"), (Object)new .colon.colon(x$3, (List)Nil$.MODULE$)))));
        return this.discoveryDocument(context, ws).map((Function1 & Serializable & scala.Serializable)dd -> Results$.MODULE$.Redirect(String.valueOf(dd.authorization_endpoint()), queryString, Results$.MODULE$.Redirect$default$3()), context);
    }

    private void checkDomains(List<String> domains, JwtClaims claims) {
        Option option;
        if (domains.nonEmpty() && !domains.exists(arg_0 -> GoogleAuth$.$anonfun$checkDomains$1$adapted(option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])claims.email().split("@"))).lastOption(), arg_0))) {
            throw new GoogleAuthException("Configured Google domain does not match", GoogleAuthException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public Future<UserIdentity> validatedUserIdentity(GoogleAuthConfig config, RequestHeader request, ExecutionContext context, WSClient ws) {
        return Future$.MODULE$.fromTry(config.antiForgeryChecker().verifyToken(request)).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.discoveryDocument(context, ws), context).flatMap((Function1 & Serializable & scala.Serializable)dd -> {
            Seq code = (Seq)request.queryString().apply((Object)"code");
            return ws.url(dd.token_endpoint()).post((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"code"), (Object)code), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_id"), (Object)new .colon.colon((Object)config.clientId(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client_secret"), (Object)new .colon.colon((Object)config.clientSecret(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"redirect_uri"), (Object)new .colon.colon((Object)config.redirectUrl(), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"grant_type"), (Object)new .colon.colon((Object)"authorization_code", (List)Nil$.MODULE$))})), package$.MODULE$.writeableOf_urlEncodedForm()).flatMap((Function1 & Serializable & scala.Serializable)response -> (Future)MODULE$.googleResponse((WSResponse)response, (Function1 & Serializable & scala.Serializable)json -> {
                Token token = Token$.MODULE$.fromJson((JsValue)json);
                JsonWebToken jwt = token.jwt();
                MODULE$.checkDomains(config.domains(), jwt.claims());
                return ws.url(dd.userinfo_endpoint()).withHttpHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Authorization"), (Object)new StringBuilder(7).append("Bearer ").append(token.access_token()).toString())})).get().map((Function1 & Serializable & scala.Serializable)response -> (UserIdentity)MODULE$.googleResponse((WSResponse)response, (Function1 & Serializable & scala.Serializable)json -> {
                    UserInfo userInfo = UserInfo$.MODULE$.fromJson((JsValue)json);
                    return new UserIdentity(jwt.claims().sub(), jwt.claims().email(), userInfo.given_name(), userInfo.family_name(), jwt.claims().exp(), userInfo.picture());
                }), context);
            }), context);
        }, context);
    }

    private GoogleAuth$() {
        MODULE$ = this;
        this.discoveryDocumentHolder = None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$checkDomains$1$adapted(Option eta$0$1$1, Object elem) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(elem));
    }
}

