/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.ExtensionFuture;
import com.guardtime.ksi.InconsistentCalendarHashChainException;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.pdu.ExtensionResponse;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationRecord;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.tlv.TLVElement;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.KSISignatureComponentFactory;
import com.guardtime.ksi.unisignature.KSISignatureFactory;
import com.guardtime.ksi.unisignature.SignaturePublicationRecord;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureComponentFactory;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureFactory;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicyAdapter;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExtensionFutureTest {
    @Test(expectedExceptions={InconsistentCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Right links of signature calendar hash chain and extended calendar hash chain do not match")
    public void testCalendarHashChainsMismatch_originalCalendarHashChainHasMoreRightLinks() throws Exception {
        this.createExtensionFuture("signatures/ok-sig-2014-06-2.ksig", "components/calendar-hash-chain/ok-sig-2014-06-2-extended-calendar-chain-right-link-missing.tlv").getResult();
    }

    @Test(expectedExceptions={InconsistentCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Right links of signature calendar hash chain and extended calendar hash chain do not match")
    public void testCalendarHashChainsMismatch_originalCalendarHashChainHasLessRightLinks() throws Exception {
        this.createExtensionFuture("signatures/ok-sig-2014-06-2.ksig", "components/calendar-hash-chain/ok-sig-2014-06-2-extended-calendar-chain-right-link-extra.tlv").getResult();
    }

    @Test(expectedExceptions={InconsistentCalendarHashChainException.class}, expectedExceptionsMessageRegExp="Right links of signature calendar hash chain and extended calendar hash chain do not match")
    public void testCalendarHashChainsMismatch_rightLinkHashDifferent() throws Exception {
        this.createExtensionFuture("signatures/ok-sig-2014-06-2.ksig", "components/calendar-hash-chain/ok-sig-2014-06-2-extended-calendar-chain-right-link-data-hash-mismatch.tlv").getResult();
    }

    @Test
    public void testSignatureExtension_noCalendarChainInSignature() throws Exception {
        KSISignature signature = this.createExtensionFuture("signatures/ok-sig-2014-06-2-only-aggr-chains.ksig", "components/calendar-hash-chain/ok-sig-2014-06-2-extended-calendar-chain.tlv").getResult();
        Assert.assertTrue((boolean)signature.isExtended());
    }

    private ExtensionFuture createExtensionFuture(String signatureFileName, String extendedCalendarChainFileName) throws Exception {
        KSISignature signature = TestUtil.loadSignature(signatureFileName);
        TLVElement calendarChainTlvElement = CommonTestUtil.loadTlv((String)extendedCalendarChainFileName);
        InMemoryKsiSignatureComponentFactory signatureComponentFactory = new InMemoryKsiSignatureComponentFactory();
        InMemoryKsiSignatureFactory signatureFactory = new InMemoryKsiSignatureFactory(ContextAwarePolicyAdapter.createInternalPolicy(), (KSISignatureComponentFactory)signatureComponentFactory);
        String publicationString = "AAAAAA-C2VG3Y-AANAMA-FULJ3X-CMWLPB-F5O2BA-7Y6UE5-VOJKPQ-OV2VFQ-W3SXJM-JIDMWY-4PDBN2";
        SignaturePublicationRecord publicationRecord = signatureComponentFactory.createPublicationRecord(new PublicationData(publicationString), null, null);
        Future future = (Future)Mockito.mock(Future.class);
        ExtensionResponse extensionResponse = (ExtensionResponse)Mockito.mock(ExtensionResponse.class);
        Mockito.when((Object)future.getResult()).thenReturn((Object)extensionResponse);
        Mockito.when((Object)extensionResponse.getCalendarHashChain()).thenReturn((Object)calendarChainTlvElement);
        return new ExtensionFuture(future, (PublicationRecord)publicationRecord, signature, (KSISignatureComponentFactory)signatureComponentFactory, (KSISignatureFactory)signatureFactory);
    }
}

