/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.KSIBuilder;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.pdu.PduIdentifierProvider;
import com.guardtime.ksi.pdu.PduVersion;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.trust.PKITrustStore;
import com.guardtime.ksi.trust.X509CertificateSubjectRdnSelector;
import com.guardtime.ksi.unisignature.verifier.AlwaysSuccessfulPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.util.Util;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.cert.CertSelector;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.Store;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KsiTest {
    private X509CertificateSubjectRdnSelector certSelector;
    private KSISigningClient mockedSigningClient;
    private KSIExtenderClient mockedExtenderClient;
    private KSIPublicationsFileClient mockedPublicationsFileClient;
    private KSI ksi;

    @BeforeMethod
    public void setUp() throws Exception {
        this.certSelector = new X509CertificateSubjectRdnSelector("E=publications@guardtime.com");
        this.mockedSigningClient = (KSISigningClient)Mockito.mock(KSISigningClient.class);
        this.mockedExtenderClient = (KSIExtenderClient)Mockito.mock(KSIExtenderClient.class);
        this.mockedPublicationsFileClient = (KSIPublicationsFileClient)Mockito.mock(KSIPublicationsFileClient.class);
        PKITrustStore mockedTrustStore = (PKITrustStore)Mockito.mock(PKITrustStore.class);
        PduIdentifierProvider mockedIdentifierProvider = (PduIdentifierProvider)Mockito.mock(PduIdentifierProvider.class);
        Mockito.when((Object)this.mockedSigningClient.getPduVersion()).thenReturn((Object)PduVersion.V2);
        Mockito.when((Object)this.mockedExtenderClient.getPduVersion()).thenReturn((Object)PduVersion.V2);
        Mockito.when((Object)mockedIdentifierProvider.getInstanceId()).thenReturn((Object)42L);
        Mockito.when((Object)mockedIdentifierProvider.nextMessageId()).thenReturn((Object)42L);
        Mockito.when((Object)mockedIdentifierProvider.nextRequestId()).thenReturn((Object)42275443333883166L);
        Mockito.when((Object)mockedTrustStore.isTrusted((X509Certificate)Mockito.any(X509Certificate.class), (Store)Mockito.any(Store.class))).thenReturn((Object)true);
        Future mockedPublicationsFileResponse = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)mockedPublicationsFileResponse.getResult()).thenReturn((Object)ByteBuffer.wrap(Util.toByteArray((InputStream)CommonTestUtil.load((String)"publications-files/publications.tlv"))));
        Mockito.when((Object)this.mockedPublicationsFileClient.getPublicationsFile()).thenReturn((Object)mockedPublicationsFileResponse);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(TestUtil.load((String)"ksi-truststore.jks"), "changeit".toCharArray());
        this.ksi = new KSIBuilder().setKsiProtocolExtenderClient(this.mockedExtenderClient).setKsiProtocolPublicationsFileClient(this.mockedPublicationsFileClient).setPublicationsFileTrustedCertSelector((CertSelector)this.certSelector).setKsiProtocolSignerClient(this.mockedSigningClient).setPublicationsFilePkiTrustStore(keyStore).setDefaultVerificationPolicy((Policy)new AlwaysSuccessfulPolicy()).build();
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="KSI signing service can not be null")
    public void testCreateKsiInstanceWithoutSigningClient_ThrowsKsiException() throws Exception {
        new KSIBuilder().setKsiProtocolExtenderClient(this.mockedExtenderClient).setKsiProtocolPublicationsFileClient(this.mockedPublicationsFileClient).setPublicationsFileTrustedCertSelector((CertSelector)this.certSelector).build();
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="KSI publications file can not be null")
    public void testCreateKsiInstanceWithoutPublicationsFileClient_ThrowsKsiException() throws Exception {
        new KSIBuilder().setKsiProtocolSignerClient(this.mockedSigningClient).setKsiProtocolExtenderClient(this.mockedExtenderClient).setPublicationsFileTrustedCertSelector((CertSelector)this.certSelector).build();
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="KSI extending service can not be null")
    public void testCreateKsiInstanceWithoutExtenderClient_ThrowsKsiException() throws Exception {
        new KSIBuilder().setKsiProtocolSignerClient(this.mockedSigningClient).setKsiProtocolPublicationsFileClient(this.mockedPublicationsFileClient).setPublicationsFileTrustedCertSelector((CertSelector)this.certSelector).build();
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="KSI publications file trusted certificate selector can not be null")
    public void testCreateKsiInstanceWithoutPublicationsFileTrustedCertSelector_ThrowsKsiException() throws Exception {
        new KSIBuilder().setKsiProtocolSignerClient(this.mockedSigningClient).setKsiProtocolExtenderClient(this.mockedExtenderClient).setKsiProtocolPublicationsFileClient(this.mockedPublicationsFileClient).build();
    }

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="File not-present-signature.ksig not found")
    public void testReadUniSignatureUsingFileNotPresent_ThrowsKSIException() throws Exception {
        this.ksi.read(new File("not-present-signature.ksig"));
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="File can not be null")
    public void testReadUniSignatureUsingInvalidFileInput_ThrowsKSIException() throws Exception {
        this.ksi.read((File)null);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Byte array can not be null")
    public void testReadUniSignatureUsingInvalidByteArrayInput_ThrowsKSIException() throws Exception {
        this.ksi.read((byte[])null);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Input stream can not be null")
    public void testReadUniSignatureUsingInvalidInputStream_ThrowsKSIException() throws Exception {
        this.ksi.read((InputStream)null);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="Data hash can not be null")
    public void testSignMissingDataHash_ThrowsKSIException() throws Exception {
        this.ksi.sign((DataHash)null);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="File can not be null")
    public void testSignMissingFile_ThrowsKSIException() throws Exception {
        this.ksi.sign((File)null);
    }
}

