/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationsFile;
import com.guardtime.ksi.publication.inmemory.InMemoryPublicationsFileFactory;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIServiceCredentials;
import com.guardtime.ksi.tlv.TLVElement;
import com.guardtime.ksi.tlv.TLVInputStream;
import com.guardtime.ksi.trust.CryptoException;
import com.guardtime.ksi.trust.PKITrustStore;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureFactory;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationContextBuilder;
import com.guardtime.ksi.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.Store;
import org.testng.AssertJUnit;

public final class TestUtil
extends CommonTestUtil {
    public static final KSIServiceCredentials CREDENTIALS_ANONYMOUS = new KSIServiceCredentials("anon", "anon");
    private static InMemoryKsiSignatureFactory signatureFactory = new InMemoryKsiSignatureFactory();
    private static InMemoryPublicationsFileFactory publicationsFileFactory;

    private TestUtil() {
    }

    public static byte[] loadBytes(String file) throws IOException {
        return Util.toByteArray((InputStream)Thread.currentThread().getContextClassLoader().getResourceAsStream(file));
    }

    public static KSISignature loadSignature(String file) throws Exception {
        return signatureFactory.createSignature(TestUtil.loadTlv((String)file), null);
    }

    public static PublicationsFile loadPublicationsFile(String file) throws Exception {
        return publicationsFileFactory.create((InputStream)new TLVInputStream(TestUtil.load((String)file)));
    }

    public static VerificationContext buildContext(KSISignature signature, KSI ksi, KSIExtendingService extendingService, DataHash documentHash) throws Exception {
        return TestUtil.buildContext(signature, ksi, extendingService, documentHash, 0L);
    }

    public static VerificationContext buildContext(KSISignature signature, KSI ksi, KSIExtendingService extendingService, DataHash documentHash, long level) throws Exception {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setPublicationsFile(ksi.getPublicationsFile()).setExtendingService(extendingService);
        return builder.setDocumentHash(documentHash, Long.valueOf(level)).build();
    }

    public static VerificationContext buildContext(KSISignature signature, KSI ksi, KSIExtenderClient extenderClient, DataHash documentHash) throws Exception {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setPublicationsFile(ksi.getPublicationsFile()).setExtenderClient(extenderClient);
        return builder.setDocumentHash(documentHash).build();
    }

    public static VerificationContext buildContext(KSISignature signature, KSI ksi, KSIExtenderClient extenderClient, PublicationData publicationData) throws Exception {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setPublicationsFile(ksi.getPublicationsFile()).setExtenderClient(extenderClient);
        return builder.setUserPublication(publicationData).build();
    }

    public static VerificationContext buildContext(KSISignature signature, KSI ksi, KSIExtenderClient extenderClient, PublicationData publicationData, boolean allowExtending) throws Exception {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setPublicationsFile(ksi.getPublicationsFile()).setExtenderClient(extenderClient);
        return builder.setUserPublication(publicationData).setExtendingAllowed(allowExtending).build();
    }

    public static void assertCause(Class<? extends Exception> expectedClass, String expectedMessage, Throwable thrown) {
        if (thrown == null) {
            AssertJUnit.fail((String)("Expected thrown exception to be caused by " + expectedClass + "(\"" + expectedMessage + "\"), but that was not the case."));
        }
        if (!expectedClass.isAssignableFrom(thrown.getClass()) || !expectedMessage.equals(thrown.getMessage())) {
            TestUtil.assertCause(expectedClass, expectedMessage, thrown.getCause());
        }
    }

    public static DataHash calculateHash(TLVElement rootElement, HashAlgorithm hmacAlgorithm, byte[] loginKey) throws Exception {
        byte[] tlvBytes = rootElement.getEncoded();
        byte[] macCalculationInput = Util.copyOf((byte[])tlvBytes, (int)0, (int)(tlvBytes.length - hmacAlgorithm.getLength()));
        return new DataHash(hmacAlgorithm, Util.calculateHMAC((byte[])macCalculationInput, (byte[])loginKey, (String)hmacAlgorithm.getName()));
    }

    static {
        try {
            publicationsFileFactory = new InMemoryPublicationsFileFactory(new PKITrustStore(){

                public boolean isTrusted(X509Certificate certificate, Store certStore) throws CryptoException {
                    return true;
                }
            });
        }
        catch (KSIException e) {
            throw new RuntimeException(e);
        }
    }
}

