/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.Extender;
import com.guardtime.ksi.ExtenderBuilder;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.KSIBuilder;
import com.guardtime.ksi.PublicationsHandler;
import com.guardtime.ksi.PublicationsHandlerBuilder;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.DataHasher;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.integration.PendingKSIService;
import com.guardtime.ksi.pdu.AggregationRequest;
import com.guardtime.ksi.pdu.AggregationResponse;
import com.guardtime.ksi.pdu.AggregationResponseFuture;
import com.guardtime.ksi.pdu.ExtensionRequest;
import com.guardtime.ksi.pdu.ExtensionResponseFuture;
import com.guardtime.ksi.pdu.KSIRequestContext;
import com.guardtime.ksi.pdu.PduFactory;
import com.guardtime.ksi.pdu.PduVersion;
import com.guardtime.ksi.pdu.RequestContextFactory;
import com.guardtime.ksi.pdu.v2.PduV2Factory;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.KSISigningService;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSIServiceCredentials;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.service.client.ServiceCredentials;
import com.guardtime.ksi.service.client.http.CredentialsAwareHttpSettings;
import com.guardtime.ksi.service.client.http.HTTPConnectionParameters;
import com.guardtime.ksi.service.client.http.HttpSettings;
import com.guardtime.ksi.service.client.http.apache.ApacheHttpExtenderClient;
import com.guardtime.ksi.service.client.http.apache.ApacheHttpPublicationsFileClient;
import com.guardtime.ksi.service.client.http.apache.ApacheHttpSigningClient;
import com.guardtime.ksi.service.ha.HAService;
import com.guardtime.ksi.service.http.simple.SimpleHttpExtenderClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpPublicationsFileClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpSigningClient;
import com.guardtime.ksi.service.tcp.TCPClient;
import com.guardtime.ksi.service.tcp.TCPClientSettings;
import com.guardtime.ksi.tlv.TLVElement;
import com.guardtime.ksi.tlv.TLVParserException;
import com.guardtime.ksi.trust.X509CertificateSubjectRdnSelector;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationContextBuilder;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.InternalVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.util.Util;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public abstract class AbstractCommonIntegrationTest {
    protected static final String KSI_DATA_GROUP_NAME = "ksiDataProvider";
    protected static final String TEST_GROUP_INTEGRATION = "integration";
    protected static final String DEFAULT_HASH_ALGORITHM = "DEFAULT";
    private static final int DEFAULT_TIMEOUT = 5000;
    protected static String javaKeyStorePath = null;
    private static List<Closeable> listOfCloseables = new LinkedList<Closeable>();
    protected KSI ksi;
    protected SimpleHttpSigningClient signerClient;
    protected SimpleHttpExtenderClient extenderClient;
    protected SimpleHttpExtenderClient invalidExtenderClient;
    protected SimpleHttpPublicationsFileClient publicationsFileClient;
    protected static CredentialsAwareHttpSettings signingSettings;
    protected static CredentialsAwareHttpSettings extenderSettings;
    protected static HttpSettings publicationsFileSettings;
    protected static Properties properties;

    @BeforeClass
    public void setUp() throws Exception {
        properties = AbstractCommonIntegrationTest.loadProperties();
        javaKeyStorePath = this.loadJavaKeyStorePath();
        signingSettings = AbstractCommonIntegrationTest.loadSignerSettings();
        extenderSettings = AbstractCommonIntegrationTest.loadExtenderSettings();
        publicationsFileSettings = AbstractCommonIntegrationTest.loadPublicationsFileSettings();
        this.signerClient = new SimpleHttpSigningClient(signingSettings);
        this.extenderClient = new SimpleHttpExtenderClient(extenderSettings);
        this.invalidExtenderClient = new SimpleHttpExtenderClient(signingSettings);
        this.publicationsFileClient = new SimpleHttpPublicationsFileClient(publicationsFileSettings);
        this.ksi = AbstractCommonIntegrationTest.createKsi((KSIExtenderClient)this.extenderClient, (KSISigningClient)this.signerClient, (KSIPublicationsFileClient)this.publicationsFileClient);
    }

    @AfterClass
    public void tearDown() throws Exception {
        if (this.ksi != null) {
            this.ksi.close();
        }
        for (Closeable object : listOfCloseables) {
            object.close();
        }
    }

    public static DataHash getFileHash(String fileName, String name) throws Exception {
        return AbstractCommonIntegrationTest.getFileHash(fileName, HashAlgorithm.getByName((String)name));
    }

    public static DataHash getFileHash(String fileName, HashAlgorithm algorithm) throws Exception {
        DataHasher dataHasher = new DataHasher(algorithm);
        dataHasher.addData(CommonTestUtil.loadFile((String)fileName));
        return dataHasher.getHash();
    }

    public static DataHash getFileHash(String fileName) throws Exception {
        return AbstractCommonIntegrationTest.getFileHash(fileName, DEFAULT_HASH_ALGORITHM);
    }

    protected static TCPClientSettings loadTCPSigningSettings() {
        Properties props = AbstractCommonIntegrationTest.loadProperties();
        String signerIP = AbstractCommonIntegrationTest.getProperty(props, "tcp.signerIP");
        int signerPort = Integer.parseInt(AbstractCommonIntegrationTest.getProperty(props, "tcp.signerPort"));
        int tcpTransactionTimeoutSec = Integer.parseInt(AbstractCommonIntegrationTest.getProperty(props, "tcp.transactionTimeoutSec"));
        KSIServiceCredentials serviceCredentials = new KSIServiceCredentials(AbstractCommonIntegrationTest.getProperty(props, "tcp.signerLoginId", "tcp.loginId"), AbstractCommonIntegrationTest.getProperty(props, "tcp.signerLoginKey", "tcp.loginKey"), HashAlgorithm.getByName((String)props.getProperty("tcp.signerHmacAlgorithm", DEFAULT_HASH_ALGORITHM)));
        return new TCPClientSettings(new InetSocketAddress(signerIP, signerPort), tcpTransactionTimeoutSec, (ServiceCredentials)serviceCredentials);
    }

    protected static TCPClientSettings loadTCPExtendingSettings() {
        Properties props = AbstractCommonIntegrationTest.loadProperties();
        String extenderIp = AbstractCommonIntegrationTest.getProperty(props, "tcp.extenderIP");
        int extenderPort = Integer.parseInt(AbstractCommonIntegrationTest.getProperty(props, "tcp.extenderPort"));
        int tcpTransactionTimeoutSec = Integer.parseInt(AbstractCommonIntegrationTest.getProperty(props, "tcp.transactionTimeoutSec"));
        KSIServiceCredentials serviceCredentials = new KSIServiceCredentials(AbstractCommonIntegrationTest.getProperty(props, "tcp.extenderLoginId", "tcp.loginId"), AbstractCommonIntegrationTest.getProperty(props, "tcp.extenderLoginKey", "tcp.loginKey"), HashAlgorithm.getByName((String)props.getProperty("tcp.extenderHmacAlgorithm", DEFAULT_HASH_ALGORITHM)));
        return new TCPClientSettings(new InetSocketAddress(extenderIp, extenderPort), tcpTransactionTimeoutSec, (ServiceCredentials)serviceCredentials);
    }

    public static HttpSettings loadPublicationsFileSettings() {
        if (publicationsFileSettings == null) {
            Properties props = AbstractCommonIntegrationTest.loadProperties();
            HTTPConnectionParameters params = new HTTPConnectionParameters(5000, 5000);
            publicationsFileSettings = new HttpSettings(AbstractCommonIntegrationTest.getProperty(props, "pubfileUrl"), params);
        }
        return publicationsFileSettings;
    }

    public static CredentialsAwareHttpSettings loadSignerSettings() {
        if (signingSettings == null) {
            signingSettings = AbstractCommonIntegrationTest.loadSignerSettings(PduVersion.V2);
        }
        return signingSettings;
    }

    public static CredentialsAwareHttpSettings loadExtenderSettings() {
        if (extenderSettings == null) {
            extenderSettings = AbstractCommonIntegrationTest.loadExtenderSettings(PduVersion.V2);
        }
        return extenderSettings;
    }

    public static CredentialsAwareHttpSettings loadSignerSettings(PduVersion pduVersion) {
        Properties props = AbstractCommonIntegrationTest.loadProperties();
        KSIServiceCredentials credentials = new KSIServiceCredentials(AbstractCommonIntegrationTest.getProperty(props, "signerLoginId", "loginId"), AbstractCommonIntegrationTest.getProperty(props, "signerLoginKey", "loginKey"), HashAlgorithm.getByName((String)props.getProperty("signerHmacAlgorithm", DEFAULT_HASH_ALGORITHM)));
        return AbstractCommonIntegrationTest.loadSettings(AbstractCommonIntegrationTest.getProperty(props, "signerUrl", "gatewayUrl"), (ServiceCredentials)credentials, pduVersion);
    }

    public static CredentialsAwareHttpSettings loadExtenderSettings(PduVersion pduVersion) {
        Properties props = AbstractCommonIntegrationTest.loadProperties();
        KSIServiceCredentials credentials = new KSIServiceCredentials(AbstractCommonIntegrationTest.getProperty(props, "extenderLoginId", "loginId"), AbstractCommonIntegrationTest.getProperty(props, "extenderLoginKey", "loginKey"), HashAlgorithm.getByName((String)props.getProperty("extenderHmacAlgorithm", DEFAULT_HASH_ALGORITHM)));
        return AbstractCommonIntegrationTest.loadSettings(AbstractCommonIntegrationTest.getProperty(props, "extenderUrl"), (ServiceCredentials)credentials, pduVersion);
    }

    public static CredentialsAwareHttpSettings loadSettings(String url, ServiceCredentials credentials, PduVersion pduVersion) {
        HTTPConnectionParameters params = new HTTPConnectionParameters(5000, 5000);
        CredentialsAwareHttpSettings settings = new CredentialsAwareHttpSettings(url, credentials, params);
        settings.setPduVersion(pduVersion);
        return settings;
    }

    @DataProvider(name="ksiDataProvider", parallel=true)
    public static Object[][] transportProtocols() throws Exception {
        if (signingSettings == null) {
            signingSettings = AbstractCommonIntegrationTest.loadSignerSettings();
        }
        if (extenderSettings == null) {
            extenderSettings = AbstractCommonIntegrationTest.loadExtenderSettings();
        }
        if (publicationsFileSettings == null) {
            publicationsFileSettings = AbstractCommonIntegrationTest.loadPublicationsFileSettings();
        }
        SimpleHttpSigningClient simpleHttpSigningClient = new SimpleHttpSigningClient(signingSettings);
        ApacheHttpSigningClient apacheHttpSigningClient = new ApacheHttpSigningClient(signingSettings);
        SimpleHttpExtenderClient simpleHttpExtenderClient = new SimpleHttpExtenderClient(extenderSettings);
        ApacheHttpExtenderClient apacheHttpExtenderClient = new ApacheHttpExtenderClient(extenderSettings);
        SimpleHttpPublicationsFileClient simpleHttpPublicationsFileClient1 = new SimpleHttpPublicationsFileClient(publicationsFileSettings);
        ApacheHttpPublicationsFileClient apacheHttpPublicationsFileClient1 = new ApacheHttpPublicationsFileClient(publicationsFileSettings);
        SimpleHttpPublicationsFileClient simpleHttpPublicationsFileClient2 = new SimpleHttpPublicationsFileClient(publicationsFileSettings);
        ApacheHttpPublicationsFileClient apacheHttpPublicationsFileClient2 = new ApacheHttpPublicationsFileClient(publicationsFileSettings);
        TCPClient tcpClient = new TCPClient(AbstractCommonIntegrationTest.loadTCPSigningSettings(), AbstractCommonIntegrationTest.loadTCPExtendingSettings());
        PendingKSIService pendingKSIService = new PendingKSIService();
        ArrayList<Object> signingClientsForHa = new ArrayList<Object>();
        signingClientsForHa.add(simpleHttpSigningClient);
        signingClientsForHa.add(apacheHttpSigningClient);
        ArrayList<PendingKSIService> signingServicesForHa = new ArrayList<PendingKSIService>();
        signingServicesForHa.add(pendingKSIService);
        ArrayList<Object> extenderClientsForHa = new ArrayList<Object>();
        extenderClientsForHa.add(simpleHttpExtenderClient);
        extenderClientsForHa.add(apacheHttpExtenderClient);
        ArrayList<PendingKSIService> extendingServicesForHa = new ArrayList<PendingKSIService>();
        extendingServicesForHa.add(pendingKSIService);
        HAService haService = new HAService.Builder().addSigningClients(signingClientsForHa).addSigningServices(signingServicesForHa).addExtenderClients(extenderClientsForHa).addExtenderServices(extendingServicesForHa).build();
        return new Object[][]{{AbstractCommonIntegrationTest.addToList((Closeable)AbstractCommonIntegrationTest.createKsi((KSIExtenderClient)simpleHttpExtenderClient, (KSISigningClient)simpleHttpSigningClient, (KSIPublicationsFileClient)simpleHttpPublicationsFileClient1), listOfCloseables)}, {AbstractCommonIntegrationTest.addToList((Closeable)AbstractCommonIntegrationTest.createKsi((KSIExtenderClient)apacheHttpExtenderClient, (KSISigningClient)apacheHttpSigningClient, (KSIPublicationsFileClient)apacheHttpPublicationsFileClient1), listOfCloseables)}, {AbstractCommonIntegrationTest.addToList((Closeable)AbstractCommonIntegrationTest.createKsi((KSIExtenderClient)tcpClient, (KSISigningClient)tcpClient, (KSIPublicationsFileClient)simpleHttpPublicationsFileClient2), listOfCloseables)}, {AbstractCommonIntegrationTest.addToList((Closeable)AbstractCommonIntegrationTest.createKsi((KSIExtendingService)haService, (KSISigningService)haService, (KSIPublicationsFileClient)apacheHttpPublicationsFileClient2), listOfCloseables)}};
    }

    protected static Closeable addToList(Closeable object, List<Closeable> list) {
        list.add(object);
        return object;
    }

    private String loadJavaKeyStorePath() {
        Properties props = AbstractCommonIntegrationTest.loadProperties();
        if (javaKeyStorePath == null && props.containsKey("javaKeyStorePath")) {
            javaKeyStorePath = AbstractCommonIntegrationTest.getProperty(props, "javaKeyStorePath");
        }
        return javaKeyStorePath;
    }

    private static Properties loadProperties() {
        if (properties == null) {
            properties = new Properties();
            try {
                properties.load(CommonTestUtil.load((String)"integrationtest.properties"));
            }
            catch (IOException e) {
                throw new RuntimeException("integrationtest.properties file must be added to folder 'ksi-api/src/test/resources' for running the integration tests");
            }
        }
        return properties;
    }

    private static String getProperty(Properties props, String preferredKey, String alternativeKey) {
        String value;
        if (props.containsKey(preferredKey)) {
            value = AbstractCommonIntegrationTest.getProperty(props, preferredKey);
        } else if (props.containsKey(alternativeKey)) {
            value = AbstractCommonIntegrationTest.getProperty(props, alternativeKey);
        } else {
            throw new NullPointerException(preferredKey + " is missing in " + "integrationtest.properties");
        }
        return value;
    }

    private static String getProperty(Properties prop, String key) {
        return Objects.requireNonNull(prop.getProperty(key), key + " is missing in " + "integrationtest.properties");
    }

    protected static Object[] createKsiObject(KSIExtenderClient extenderClient, KSISigningClient signingClient, KSIPublicationsFileClient publicationsFileClient) throws Exception {
        return new Object[]{AbstractCommonIntegrationTest.createKsi(extenderClient, signingClient, publicationsFileClient)};
    }

    protected static KSI createKsi(KSIExtenderClient extenderClient, KSISigningClient signingClient, KSIPublicationsFileClient publicationsFileClient) throws Exception {
        return AbstractCommonIntegrationTest.initKsiBuilder(extenderClient, signingClient, publicationsFileClient).build();
    }

    protected static KSIBuilder initKsiBuilder(KSIExtenderClient extenderClient, KSISigningClient signingClient, KSIPublicationsFileClient publicationsFileClient) throws Exception {
        return new KSIBuilder().setKsiProtocolExtenderClient(extenderClient).setKsiProtocolPublicationsFileClient(publicationsFileClient).setKsiProtocolSignerClient(signingClient).setPublicationsFilePkiTrustStore(AbstractCommonIntegrationTest.createKeyStore()).setPublicationsFileTrustedCertSelector((CertSelector)AbstractCommonIntegrationTest.createCertSelector()).setDefaultVerificationPolicy((Policy)new InternalVerificationPolicy());
    }

    protected PublicationsHandler getPublicationsHandler(KSIPublicationsFileClient publicationsFileClient) throws Exception {
        return new PublicationsHandlerBuilder().setKsiProtocolPublicationsFileClient(publicationsFileClient).setPublicationsFileCacheExpirationTime(10000L).setPublicationsFilePkiTrustStore(AbstractCommonIntegrationTest.createKeyStore()).setPublicationsFileCertificateConstraints((CertSelector)AbstractCommonIntegrationTest.createCertSelector()).build();
    }

    protected Extender getExtender(KSIExtendingService extendingService, KSIPublicationsFileClient publicationsFileClient) throws Exception {
        return new ExtenderBuilder().setExtendingService(extendingService).setPublicationsHandler(this.getPublicationsHandler(publicationsFileClient)).build();
    }

    protected static KSI createKsi(KSIExtendingService extendingService, KSISigningService signingService, KSIPublicationsFileClient publicationsFileClient) throws Exception {
        return AbstractCommonIntegrationTest.initKsiBuilder(extendingService, signingService, publicationsFileClient).build();
    }

    protected static KSIBuilder initKsiBuilder(KSIExtendingService extendingService, KSISigningService signingService, KSIPublicationsFileClient publicationsFileClient) throws Exception {
        return new KSIBuilder().setKsiProtocolExtendingService(extendingService).setKsiProtocolPublicationsFileClient(publicationsFileClient).setKsiProtocolSigningService(signingService).setPublicationsFilePkiTrustStore(AbstractCommonIntegrationTest.createKeyStore()).setPublicationsFileTrustedCertSelector((CertSelector)AbstractCommonIntegrationTest.createCertSelector());
    }

    protected static KeyStore createKeyStore() throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("ksi-truststore.jks"), "changeit".toCharArray());
        return trustStore;
    }

    protected static X509CertificateSubjectRdnSelector createCertSelector() throws KSIException {
        return new X509CertificateSubjectRdnSelector("E=publications@guardtime.com");
    }

    public VerificationResult verify(KSI ksi, KSIExtendingService extendingService, KSISignature signature, Policy policy) throws KSIException {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setExtendingService(extendingService).setPublicationsFile(ksi.getPublicationsFile());
        return ksi.verify(builder.build(), policy);
    }

    public VerificationResult verify(KSI ksi, KSIExtendingService extendingService, KSISignature signature, Policy policy, boolean extendingAllowed) throws KSIException {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setExtendingService(extendingService).setPublicationsFile(ksi.getPublicationsFile());
        builder.setExtendingAllowed(extendingAllowed);
        return ksi.verify(builder.build(), policy);
    }

    public VerificationResult verify(KSI ksi, KSIExtenderClient extenderClient, KSISignature signature, Policy policy, boolean extendingAllowed) throws KSIException {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setExtenderClient(extenderClient).setPublicationsFile(ksi.getPublicationsFile());
        builder.setExtendingAllowed(extendingAllowed);
        return ksi.verify(builder.build(), policy);
    }

    public VerificationResult verify(KSI ksi, KSIExtenderClient extenderClient, KSISignature signature, Policy policy, PublicationData userPublication, boolean extendingAllowed) throws KSIException {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setExtenderClient(extenderClient).setPublicationsFile(ksi.getPublicationsFile());
        builder.setUserPublication(userPublication);
        builder.setExtendingAllowed(extendingAllowed);
        return ksi.verify(builder.build(), policy);
    }

    protected static KSISigningService mockSigningService(String responseFile, final ServiceCredentials credentials) throws Exception {
        KSISigningService mockedSigningService = (KSISigningService)Mockito.mock(KSISigningService.class);
        final Future mockedFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)mockedFuture.isFinished()).thenReturn((Object)Boolean.TRUE);
        final TLVElement responseTLV = TLVElement.create((byte[])IOUtils.toByteArray((InputStream)CommonTestUtil.load((String)responseFile)));
        Mockito.when((Object)mockedFuture.getResult()).thenReturn((Object)responseTLV);
        Mockito.when((Object)mockedSigningService.sign((DataHash)Mockito.any(DataHash.class), (Long)Mockito.any(Long.TYPE))).then((Answer)new Answer<Future>(){

            public Future<AggregationResponse> answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataHash dataHash = (DataHash)invocationOnMock.getArguments()[0];
                long level = (Long)invocationOnMock.getArguments()[1];
                PduV2Factory factory = new PduV2Factory();
                KSIRequestContext context = RequestContextFactory.DEFAULT_FACTORY.createContext();
                AggregationRequest request = factory.createAggregationRequest(context, credentials, dataHash, Long.valueOf(level));
                ByteArrayInputStream bais = new ByteArrayInputStream(request.toByteArray());
                TLVElement requestElement = TLVElement.create((byte[])Util.toByteArray((InputStream)bais));
                responseTLV.getFirstChildElement(1).setContent(requestElement.getFirstChildElement(1).getEncoded());
                responseTLV.getFirstChildElement(2).getFirstChildElement(1).setLongContent(requestElement.getFirstChildElement(2).getFirstChildElement(1).getDecodedLong().longValue());
                responseTLV.getFirstChildElement(2).getFirstChildElement(2049).getFirstChildElement(5).setDataHashContent(dataHash);
                responseTLV.getFirstChildElement(31).setDataHashContent(TestUtil.calculateHash(responseTLV, responseTLV.getFirstChildElement(31).getDecodedDataHash().getAlgorithm(), credentials.getLoginKey()));
                return new AggregationResponseFuture(mockedFuture, context, credentials, (PduFactory)factory);
            }
        });
        return mockedSigningService;
    }

    protected KSIExtendingService mockExtenderResponseCalendarHashCain(String responseCalendarChainFile) throws Exception {
        KSIExtendingService mockedExtenderService = (KSIExtendingService)Mockito.mock(KSIExtendingService.class);
        final Future mockedFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)mockedFuture.isFinished()).thenReturn((Object)Boolean.TRUE);
        final TLVElement responseTLV = AbstractCommonIntegrationTest.putCHCIntoExtenderResponsePdu(responseCalendarChainFile);
        Mockito.when((Object)mockedFuture.getResult()).thenReturn((Object)responseTLV);
        Mockito.when((Object)mockedExtenderService.extend((Date)Mockito.any(Date.class), (Date)Mockito.any(Date.class))).then((Answer)new Answer<Future>(){

            public Future answer(InvocationOnMock invocationOnMock) throws Throwable {
                ServiceCredentials credentials = AbstractCommonIntegrationTest.loadExtenderSettings().getCredentials();
                KSIRequestContext requestContext = RequestContextFactory.DEFAULT_FACTORY.createContext();
                Date aggregationTime = (Date)invocationOnMock.getArguments()[0];
                Date publicationTime = (Date)invocationOnMock.getArguments()[1];
                PduV2Factory pduFactory = new PduV2Factory();
                ExtensionRequest requestMessage = pduFactory.createExtensionRequest(requestContext, credentials, aggregationTime, publicationTime);
                ByteArrayInputStream requestStream = new ByteArrayInputStream(requestMessage.toByteArray());
                TLVElement requestElement = TLVElement.create((byte[])Util.toByteArray((InputStream)requestStream));
                TLVElement responsePayload = responseTLV.getFirstChildElement(2);
                responseTLV.getFirstChildElement(1).setContent(requestElement.getFirstChildElement(1).getEncoded());
                responsePayload.getFirstChildElement(1).setLongContent(requestElement.getFirstChildElement(2).getFirstChildElement(1).getDecodedLong().longValue());
                responseTLV.getFirstChildElement(31).setDataHashContent(TestUtil.calculateHash(responseTLV, responseTLV.getFirstChildElement(31).getDecodedDataHash().getAlgorithm(), credentials.getLoginKey()));
                return new ExtensionResponseFuture(mockedFuture, requestContext, credentials, (PduFactory)pduFactory);
            }
        });
        return mockedExtenderService;
    }

    private static TLVElement putCHCIntoExtenderResponsePdu(String extenderResponse) throws IllegalArgumentException, IOException, TLVParserException {
        TLVElement rsp = TLVElement.create((byte[])IOUtils.toByteArray((InputStream)CommonTestUtil.load((String)extenderResponse)));
        if (rsp.getType() == 801) {
            return rsp;
        }
        if (rsp.getType() == 2) {
            TLVElement responseTLV = TLVElement.create((byte[])IOUtils.toByteArray((InputStream)CommonTestUtil.load((String)"extender-responses/extender-response-no-calendar.tlv")));
            responseTLV.replace(responseTLV.getFirstChildElement(2), rsp);
            return responseTLV;
        }
        if (rsp.getType() == 2050) {
            TLVElement responseTLV = TLVElement.create((byte[])IOUtils.toByteArray((InputStream)CommonTestUtil.load((String)"extender-responses/extender-response-no-calendar.tlv")));
            responseTLV.getFirstChildElement(2).replace(responseTLV.getFirstChildElement(2).getFirstChildElement(2050), rsp);
            return responseTLV;
        }
        throw new IllegalArgumentException("Provided extender response is not supported.");
    }
}

