/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.AsyncContext;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.pdu.AggregatorConfiguration;
import com.guardtime.ksi.pdu.PduVersion;
import com.guardtime.ksi.service.ConfigurationListener;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.service.ha.HAService;
import com.guardtime.ksi.service.http.simple.SimpleHttpExtenderClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpPublicationsFileClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpSigningClient;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AggregatorConfigurationIntegrationTest
extends AbstractCommonIntegrationTest {
    private HAService haServiceV2;
    private KSI ksiV2;

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
        SimpleHttpSigningClient signingClientV2 = new SimpleHttpSigningClient(AggregatorConfigurationIntegrationTest.loadSignerSettings(PduVersion.V2));
        SimpleHttpExtenderClient extenderClientV2 = new SimpleHttpExtenderClient(AggregatorConfigurationIntegrationTest.loadExtenderSettings(PduVersion.V2));
        SimpleHttpPublicationsFileClient publicationsFileClient = new SimpleHttpPublicationsFileClient(AggregatorConfigurationIntegrationTest.loadPublicationsFileSettings());
        this.haServiceV2 = new HAService.Builder().addSigningClients(Collections.singletonList(signingClientV2)).addExtenderClients(Collections.singletonList(extenderClientV2)).build();
        this.ksiV2 = AggregatorConfigurationIntegrationTest.createKsi((KSIExtenderClient)extenderClientV2, (KSISigningClient)signingClientV2, (KSIPublicationsFileClient)publicationsFileClient);
    }

    @Override
    @AfterClass
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.haServiceV2 != null) {
            this.haServiceV2.close();
        }
        if (this.ksiV2 != null) {
            this.ksiV2.close();
        }
    }

    @Test
    public void testAggregationConfigurationRequestV2() throws Exception {
        final AsyncContext ac = new AsyncContext();
        this.haServiceV2.registerAggregatorConfigurationListener((ConfigurationListener)new ConfigurationListener<AggregatorConfiguration>(){

            public void updated(AggregatorConfiguration aggregatorConfiguration) {
                try {
                    Assert.assertNotNull((Object)aggregatorConfiguration);
                    ac.succeed();
                }
                catch (AssertionError e) {
                    ac.fail(e);
                }
            }

            public void updateFailed(Throwable t) {
                try {
                    Assert.fail((String)"Configuration update failed", (Throwable)t);
                }
                catch (AssertionError e) {
                    ac.fail(e);
                }
            }
        });
        this.haServiceV2.getAggregationConfiguration();
        ac.await();
    }

    @Test
    public void testSynchronousAggregationConfigurationRequestV2() throws Exception {
        AggregatorConfiguration response = (AggregatorConfiguration)this.ksiV2.getSigningService().getAggregationConfiguration().getResult();
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testSynchronousAggregationConfigurationRequestHA() throws Exception {
        Assert.assertNotNull((Object)this.haServiceV2.getAggregationConfiguration().getResult());
    }
}

