/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.KSIBuilder;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.integration.IntegrationTestAction;
import com.guardtime.ksi.integration.PublicationsFileClientFromFile;
import com.guardtime.ksi.pdu.ExtensionRequest;
import com.guardtime.ksi.pdu.ExtensionResponse;
import com.guardtime.ksi.pdu.ExtensionResponseFuture;
import com.guardtime.ksi.pdu.KSIRequestContext;
import com.guardtime.ksi.pdu.PduFactory;
import com.guardtime.ksi.pdu.RequestContextFactory;
import com.guardtime.ksi.pdu.v2.PduV2Factory;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationsFile;
import com.guardtime.ksi.publication.inmemory.InMemoryPublicationsFileFactory;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSIExtendingClientServiceAdapter;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSIServiceCredentials;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.service.client.ServiceCredentials;
import com.guardtime.ksi.service.client.http.CredentialsAwareHttpSettings;
import com.guardtime.ksi.service.client.http.HttpSettings;
import com.guardtime.ksi.service.http.simple.SimpleHttpPublicationsFileClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpSigningClient;
import com.guardtime.ksi.tlv.TLVElement;
import com.guardtime.ksi.trust.JKSTrustStore;
import com.guardtime.ksi.trust.PKITrustStore;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.KSISignatureComponentFactory;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureComponentFactory;
import com.guardtime.ksi.unisignature.verifier.AlwaysSuccessfulPolicy;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationContextBuilder;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.util.Base16;
import com.guardtime.ksi.util.Util;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class IntegrationTestDataHolder
implements Closeable {
    private String testFile;
    private final IntegrationTestAction action;
    private final VerificationErrorCode errorCode;
    private final String errorMessage;
    private final long inputHashLevel;
    private final DataHash inputHash;
    private final DataHash chcInputHash;
    private final DataHash chchOutputHash;
    private final Date aggregationTime;
    private final Date publicationTime;
    private final PublicationData userPublication;
    private final boolean extendingPermitted;
    private final String responseFile;
    private final String publicationsFile;
    private final String certFile;
    private KSIExtenderClient extenderClient;
    private KSI ksi;
    private final CredentialsAwareHttpSettings extenderSettings;

    public IntegrationTestDataHolder(String testFilePath, String[] inputData, KSIExtenderClient httpClient) throws Exception {
        this.notNull(inputData, "Input data");
        for (int i = 0; i < inputData.length; ++i) {
            inputData[i] = inputData[i].trim();
        }
        this.notNull(httpClient, "Extender http client");
        this.extenderClient = httpClient;
        this.notEmpty(inputData[0], "Test file");
        if (testFilePath != null && testFilePath.trim().length() != 0) {
            this.testFile = testFilePath + inputData[0];
            this.responseFile = inputData[12].length() == 0 ? null : testFilePath + inputData[12];
            this.publicationsFile = inputData[13].length() == 0 ? null : testFilePath + inputData[13];
            this.certFile = inputData[14].length() == 0 ? null : testFilePath + inputData[14];
        } else {
            this.testFile = inputData[0];
            this.responseFile = inputData[12].length() == 0 ? null : inputData[12];
            this.publicationsFile = inputData[13].length() == 0 ? null : inputData[13];
            this.certFile = inputData[14].length() == 0 ? null : inputData[14];
        }
        this.notEmpty(inputData[1], "Action");
        this.action = IntegrationTestAction.getByName(inputData[1]);
        this.errorCode = this.getErrorCodeByName(inputData[2]);
        this.errorMessage = inputData[3].length() == 0 ? null : inputData[3];
        this.inputHashLevel = inputData[4].length() == 0 ? 0L : Long.decode(inputData[4]);
        this.inputHash = inputData[5].length() == 0 ? null : new DataHash(Base16.decode((String)inputData[5]));
        this.chcInputHash = inputData[6].length() == 0 ? null : new DataHash(Base16.decode((String)inputData[6]));
        this.chchOutputHash = inputData[7].length() == 0 ? null : new DataHash(Base16.decode((String)inputData[7]));
        this.aggregationTime = inputData[8].length() == 0 ? null : new Date(Long.decode(inputData[8]) * 1000L);
        this.publicationTime = inputData[9].length() == 0 ? null : new Date(Long.decode(inputData[9]) * 1000L);
        this.userPublication = inputData[10].length() == 0 ? null : new PublicationData(inputData[10]);
        this.extendingPermitted = inputData[11].length() == 0 ? false : Boolean.valueOf(inputData[11]);
        this.extenderSettings = AbstractCommonIntegrationTest.loadExtenderSettings();
        this.buildKsi();
    }

    private void buildKsi() throws IOException, KSIException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        CredentialsAwareHttpSettings signerSettings = AbstractCommonIntegrationTest.loadSignerSettings();
        HttpSettings publicationSettings = AbstractCommonIntegrationTest.loadPublicationsFileSettings();
        KSIBuilder builder = new KSIBuilder();
        builder.setPublicationsFilePkiTrustStore(this.getKeyStore()).setKsiProtocolExtendingService(this.getExtendingService()).setKsiProtocolSignerClient((KSISigningClient)new SimpleHttpSigningClient(signerSettings)).setPublicationsFileTrustedCertSelector((CertSelector)AbstractCommonIntegrationTest.createCertSelector()).setDefaultVerificationPolicy((Policy)new AlwaysSuccessfulPolicy()).setDefaultSigningHashAlgorithm(HashAlgorithm.SHA2_256);
        if (this.publicationsFile == null) {
            builder.setKsiProtocolPublicationsFileClient((KSIPublicationsFileClient)new SimpleHttpPublicationsFileClient(publicationSettings));
        } else {
            builder.setKsiProtocolPublicationsFileClient((KSIPublicationsFileClient)new PublicationsFileClientFromFile(this.publicationsFile));
        }
        this.ksi = builder.build();
    }

    public VerificationContext getVerificationContext(KSISignature signature) throws KSIException, IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException {
        VerificationContextBuilder builder = new VerificationContextBuilder();
        builder.setSignature(signature).setExtendingService(this.getExtendingService()).setPublicationsFile(this.publicationsFile == null ? this.ksi.getPublicationsFile() : this.getPublicationsFile()).setUserPublication(this.userPublication).setExtendingAllowed(this.extendingPermitted).setDocumentHash(this.inputHash, Long.valueOf(this.inputHashLevel));
        VerificationContext context = builder.build();
        context.setKsiSignatureComponentFactory((KSISignatureComponentFactory)new InMemoryKsiSignatureComponentFactory());
        return context;
    }

    private KSIExtendingService mockExtenderService() throws KSIException, IOException {
        KSIExtendingService mockClient = (KSIExtendingService)Mockito.mock(KSIExtendingService.class);
        final Future mockedFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)mockedFuture.isFinished()).thenReturn((Object)Boolean.TRUE);
        final TLVElement responseTLV = TLVElement.create((byte[])IOUtils.toByteArray((InputStream)CommonTestUtil.load((String)this.responseFile)));
        Mockito.when((Object)mockedFuture.getResult()).thenReturn((Object)responseTLV);
        Mockito.when((Object)mockClient.extend((Date)Mockito.any(Date.class), (Date)Mockito.any(Date.class))).then((Answer)new Answer<Future>(){

            public Future<ExtensionResponse> answer(InvocationOnMock invocationOnMock) throws Throwable {
                KSIServiceCredentials credentials = new KSIServiceCredentials("anon", "anon");
                Date aggregationTime = (Date)invocationOnMock.getArguments()[0];
                Date publicationTime = (Date)invocationOnMock.getArguments()[1];
                PduV2Factory factory = new PduV2Factory();
                KSIRequestContext context = RequestContextFactory.DEFAULT_FACTORY.createContext();
                ExtensionRequest request = factory.createExtensionRequest(context, (ServiceCredentials)credentials, aggregationTime, publicationTime);
                ByteArrayInputStream bais = new ByteArrayInputStream(request.toByteArray());
                TLVElement requestElement = TLVElement.create((byte[])Util.toByteArray((InputStream)bais));
                responseTLV.getFirstChildElement(2).getFirstChildElement(1).setLongContent(requestElement.getFirstChildElement(2).getFirstChildElement(1).getDecodedLong().longValue());
                responseTLV.getFirstChildElement(31).setDataHashContent(TestUtil.calculateHash(responseTLV, responseTLV.getFirstChildElement(31).getDecodedDataHash().getAlgorithm(), IntegrationTestDataHolder.this.extenderSettings.getCredentials().getLoginKey()));
                return new ExtensionResponseFuture(mockedFuture, context, (ServiceCredentials)credentials, (PduFactory)factory);
            }
        });
        return mockClient;
    }

    private PublicationsFile getPublicationsFile() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException, KSIException {
        InMemoryPublicationsFileFactory factory = new InMemoryPublicationsFileFactory((PKITrustStore)new JKSTrustStore(this.getKeyStore(), (CertSelector)AbstractCommonIntegrationTest.createCertSelector()));
        return factory.create(CommonTestUtil.load((String)this.publicationsFile));
    }

    private KeyStore getKeyStore() throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException {
        KeyStore keyStore = AbstractCommonIntegrationTest.createKeyStore();
        if (this.certFile != null) {
            keyStore.load(null);
            InputStream fis = CommonTestUtil.load((String)this.certFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bis.available() > 0) {
                Certificate cert = cf.generateCertificate(bis);
                keyStore.setCertificateEntry("custom" + bis.available(), cert);
            }
        }
        return keyStore;
    }

    private KSIExtendingService getExtendingService() throws IOException, KSIException {
        if (this.responseFile == null) {
            return new KSIExtendingClientServiceAdapter(this.extenderClient);
        }
        return this.mockExtenderService();
    }

    private void notEmpty(String object, String name) {
        if (object.trim().length() == 0) {
            throw new IllegalArgumentException(name + " is empty.");
        }
    }

    private void notNull(Object object, String name) {
        if (object == null) {
            throw new IllegalArgumentException(name + " is null.");
        }
    }

    private VerificationErrorCode getErrorCodeByName(String code) {
        if (code.length() == 0) {
            return null;
        }
        for (VerificationErrorCode errorCode : VerificationErrorCode.values()) {
            if (!errorCode.getCode().equals(code)) continue;
            return errorCode;
        }
        throw new IllegalArgumentException("Unknown verification error code: " + code);
    }

    public String toString() {
        return "TestData{ testFile=" + this.testFile + ", action=" + this.action.getName() + ", errorCode=" + (this.errorCode == null ? "" : this.errorCode.getCode()) + ", errorMessage=" + this.errorMessage + ", inputHash=" + this.inputHash + ", chcInputHash=" + this.chcInputHash + ", chchOutputHash=" + this.chchOutputHash + ", aggregationTime=" + (this.aggregationTime == null ? "" : Long.valueOf(this.aggregationTime.getTime())) + ", publicationTime=" + (this.publicationTime == null ? "" : Long.valueOf(this.publicationTime.getTime())) + ", userPublication=" + (this.userPublication == null ? "" : this.userPublication.getPublicationString()) + ", extendingPermitted=" + this.extendingPermitted + ", responseFile=" + this.responseFile + ", publicationsFile=" + this.publicationsFile + ", certFile=" + this.certFile + " }";
    }

    public String getTestFile() {
        return this.testFile;
    }

    public IntegrationTestAction getAction() {
        return this.action;
    }

    public VerificationErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public DataHash getInputHash() {
        return this.inputHash;
    }

    public DataHash getChcInputHash() {
        return this.chcInputHash;
    }

    public DataHash getChchOutputHash() {
        return this.chchOutputHash;
    }

    public Date getAggregationTime() {
        return this.aggregationTime;
    }

    public Date getPublicationTime() {
        return this.publicationTime;
    }

    public PublicationData getUserPublication() {
        return this.userPublication;
    }

    public boolean isExtendingPermitted() {
        return this.extendingPermitted;
    }

    public String getResponseFile() {
        return this.responseFile;
    }

    public KSI getKsi() {
        return this.ksi;
    }

    @Override
    public void close() throws IOException {
        if (this.ksi != null) {
            this.ksi.close();
        }
        if (this.extenderClient != null) {
            this.extenderClient.close();
        }
    }
}

