/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.inmemory.InMemoryPublicationsFileFactory;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.trust.CryptoException;
import com.guardtime.ksi.trust.PKITrustStore;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationContextBuilder;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.Store;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PublicationsFileIntegrationTest
extends AbstractCommonIntegrationTest {
    private final PublicationsFileBasedVerificationPolicy policy = new PublicationsFileBasedVerificationPolicy();

    @Test(groups={"integration"})
    public void testVerifySignatureWithPublicationWithNewNonCriticalElementInPublicationRecordLvl1() throws Exception {
        VerificationResult results = this.publicationFileBasedVerification("signatures/ok-sig-2014-06-2.ksig", "publications-files/publicartions-new-non-critical-element-in-publication-record-lvl1.tlv", true, (KSIExtenderClient)this.extenderClient);
        Assert.assertTrue((boolean)results.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithPublicationWithNewNonCriticalElementInPublicationRecordLvl2() throws Exception {
        VerificationResult results = this.publicationFileBasedVerification("signatures/ok-sig-2014-06-2.ksig", "publications-files/publicartions-new-non-critical-element-in-publication-record-lvl2.tlv", true, (KSIExtenderClient)this.extenderClient);
        Assert.assertTrue((boolean)results.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithPublicationWithNewNonCriticalElementInCertificateRecord() throws Exception {
        VerificationResult results = this.publicationFileBasedVerification("signatures/ok-sig-2014-06-2.ksig", "publications-files/publicartions-new-non-critical-element-in-certificate-record-lvl1.tlv", true, (KSIExtenderClient)this.extenderClient);
        Assert.assertTrue((boolean)results.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithPublicationWithNewNonCriticalElementInPublicationHeader() throws Exception {
        VerificationResult results = this.publicationFileBasedVerification("signatures/ok-sig-2014-06-2.ksig", "publications-files/publicartions-new-non-critical-element-in-publication-header-lvl1.tlv", true, (KSIExtenderClient)this.extenderClient);
        Assert.assertTrue((boolean)results.isOk());
    }

    private VerificationResult publicationFileBasedVerification(String signatureFile, String publicationFile, boolean extendingAllowed, KSIExtenderClient extenderClient) throws Exception {
        VerificationContextBuilder build = new VerificationContextBuilder();
        build.setPublicationsFile(new InMemoryPublicationsFileFactory(new PKITrustStore(){

            public boolean isTrusted(X509Certificate certificate, Store certStore) throws CryptoException {
                return true;
            }
        }).create(CommonTestUtil.load((String)publicationFile)));
        KSISignature signature = TestUtil.loadSignature(signatureFile);
        build.setSignature(signature).setExtenderClient(extenderClient);
        build.setExtendingAllowed(extendingAllowed);
        return this.ksi.verify(build.build(), (Policy)this.policy);
    }
}

