/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.integration.IntegrationTestAction;
import com.guardtime.ksi.integration.IntegrationTestDataHolder;
import com.guardtime.ksi.integration.IntegrationTestFailureException;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpExtenderClient;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SharedVerificationIntegrationTest
extends AbstractCommonIntegrationTest {
    protected static final String INTERNAL_POLICY_SIGNATURES = "INTERNAL_POLICY_SIGNATURES";
    protected static final String INVALID_SIGNATURES = "INVALID_SIGNATURES";
    protected static final String POLICY_VERIFICATION_SIGNATURES = "POLICY_VERIFICATION_SIGNATURES";
    protected static final String VALID_SIGNATURES = "VALID_SIGNATURES";
    private static final Logger logger = LoggerFactory.getLogger(SharedVerificationIntegrationTest.class);
    private static List<Closeable> testData = new LinkedList<Closeable>();

    @AfterClass
    public void testTearDown() throws IOException {
        for (Closeable object : testData) {
            object.close();
        }
    }

    @Test(groups={"integration"}, dataProvider="VALID_SIGNATURES")
    public void testValidSignatures(IntegrationTestDataHolder testData) throws Exception {
        this.testExecution(testData);
    }

    @Test(groups={"integration"}, dataProvider="INVALID_SIGNATURES")
    public void testInvalidSignatures(IntegrationTestDataHolder testData) throws Exception {
        this.testExecution(testData);
    }

    @Test(groups={"integration"}, dataProvider="INTERNAL_POLICY_SIGNATURES")
    public void testInternalPolicySignatures(IntegrationTestDataHolder testData) throws Exception {
        this.testExecution(testData);
    }

    @Test(groups={"integration"}, dataProvider="POLICY_VERIFICATION_SIGNATURES")
    public void testPolicyVerificationSignatures(IntegrationTestDataHolder testData) throws Exception {
        this.testExecution(testData);
    }

    @DataProvider(name="VALID_SIGNATURES", parallel=true)
    public static Object[][] getTestDataAndResultsForValidSignatures() throws Exception {
        try {
            return SharedVerificationIntegrationTest.getTestFilesAndResults("valid-signatures/", "signature-results.csv");
        }
        catch (Throwable e) {
            return new Object[][]{new Object[0]};
        }
    }

    @DataProvider(name="INTERNAL_POLICY_SIGNATURES", parallel=true)
    public static Object[][] getTestDataAndResultsForInternalPolicySignatures() throws Exception {
        try {
            return SharedVerificationIntegrationTest.getTestFilesAndResults("internal-policy-signatures/", "internal-policy-results.csv");
        }
        catch (Throwable e) {
            return new Object[][]{new Object[0]};
        }
    }

    @DataProvider(name="INVALID_SIGNATURES", parallel=true)
    public static Object[][] getTestDataAndResultsForInvalidSignatures() throws Exception {
        try {
            return SharedVerificationIntegrationTest.getTestFilesAndResults("invalid-signatures/", "invalid-signature-results.csv");
        }
        catch (Throwable e) {
            return new Object[][]{new Object[0]};
        }
    }

    @DataProvider(name="POLICY_VERIFICATION_SIGNATURES", parallel=true)
    public static Object[][] getTestDataAndResultsForPolicyVerificationSignatures() throws Exception {
        try {
            return SharedVerificationIntegrationTest.getTestFilesAndResults("policy-verification-signatures/", "policy-verification-results.csv");
        }
        catch (Throwable e) {
            return new Object[][]{new Object[0]};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[][] getTestFilesAndResults(String path, String fileName) throws Exception {
        try (BufferedReader fileReader = null;){
            String line;
            fileReader = new BufferedReader(new InputStreamReader(new FileInputStream(CommonTestUtil.loadFile((String)(path + fileName)))));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = fileReader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() <= 17 || line.contains(IntegrationTestAction.NOT_IMPLEMENTED.getName())) continue;
                line = line.replace(";", "; ");
                lines.add(line);
            }
            int linesCount = lines.size();
            Object[][] data = new Object[linesCount][1];
            SimpleHttpExtenderClient extenderClient = new SimpleHttpExtenderClient(SharedVerificationIntegrationTest.loadExtenderSettings());
            for (int i = 0; i < linesCount; ++i) {
                try {
                    data[i] = new Object[]{SharedVerificationIntegrationTest.addToList(new IntegrationTestDataHolder(path, ((String)lines.get(i)).split(";"), (KSIExtenderClient)extenderClient), testData)};
                    continue;
                }
                catch (Exception e) {
                    logger.warn("Error while parsing the following line: '" + (String)lines.get(i) + "' from file: " + fileName);
                    throw e;
                }
            }
            Object[][] objectArray = data;
            return objectArray;
        }
    }

    private void testExecution(IntegrationTestDataHolder testData) throws Exception {
        KSISignature signature;
        KSI ksi = testData.getKsi();
        if (testData.getAction().equals((Object)IntegrationTestAction.NOT_IMPLEMENTED)) {
            return;
        }
        if (testData.getAction().equals((Object)IntegrationTestAction.FAIL_AT_PARSING)) {
            try {
                ksi.read(CommonTestUtil.load((String)testData.getTestFile()));
                throw new IntegrationTestFailureException("Did not fail at parsing while expected to. " + testData.toString());
            }
            catch (KSIException e) {
                if (e.getCause() != null) {
                    throw e;
                }
                return;
            }
        }
        try {
            signature = ksi.read(CommonTestUtil.load((String)testData.getTestFile()));
        }
        catch (Exception e) {
            throw new IntegrationTestFailureException("Failure at signature parsing was not expected. " + testData.toString(), e);
        }
        VerificationContext context = testData.getVerificationContext(signature);
        VerificationResult result = ksi.verify(context, testData.getAction().getPolicy());
        if (testData.getErrorCode() == null) {
            Assert.assertTrue((boolean)result.isOk(), (String)("Verification result is not OK. " + testData.toString()));
        } else {
            if (!testData.getErrorCode().getCode().equals(result.getErrorCode().getCode())) {
                throw new IntegrationTestFailureException("Expected verification result error code '" + testData.getErrorCode().getCode() + "' but received '" + result.getErrorCode().getCode() + "'. " + testData.toString());
            }
            if (!result.getErrorCode().getMessage().equals(testData.getErrorMessage())) {
                throw new IntegrationTestFailureException("Expected error message '" + testData.getErrorMessage() + "' but received '" + result.getErrorCode().getMessage() + "'. " + testData.toString());
            }
        }
    }
}

