/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.KSIBuilder;
import com.guardtime.ksi.Signer;
import com.guardtime.ksi.SignerBuilder;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.pdu.AggregationRequest;
import com.guardtime.ksi.pdu.AggregationResponse;
import com.guardtime.ksi.pdu.AggregationResponseFuture;
import com.guardtime.ksi.pdu.KSIRequestContext;
import com.guardtime.ksi.pdu.PduFactory;
import com.guardtime.ksi.pdu.RequestContextFactory;
import com.guardtime.ksi.pdu.v2.PduV2Factory;
import com.guardtime.ksi.service.Future;
import com.guardtime.ksi.service.KSISigningService;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.ServiceCredentials;
import com.guardtime.ksi.service.http.simple.SimpleHttpExtenderClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpPublicationsFileClient;
import com.guardtime.ksi.tlv.TLVElement;
import com.guardtime.ksi.tlv.TLVStructure;
import com.guardtime.ksi.unisignature.AggregationChainLink;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.util.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertSelector;
import org.apache.commons.io.IOUtils;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SignIntegrationTest
extends AbstractCommonIntegrationTest {
    @Test
    public void testSigningWithSignerClient_Ok() throws Exception {
        try (Signer signer = new SignerBuilder().setSigningService(this.ksi.getSigningService()).build();){
            KSISignature sig = signer.sign(CommonTestUtil.loadFile((String)"input-file/infile"));
            VerificationResult result = this.ksi.verify(TestUtil.buildContext(sig, this.ksi, (KSIExtenderClient)this.extenderClient, SignIntegrationTest.getFileHash("input-file/infile")), (Policy)new KeyBasedVerificationPolicy());
            Assert.assertTrue((boolean)result.isOk());
        }
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testSignFile_Ok(KSI ksi) throws Exception {
        KSISignature sig = ksi.sign(CommonTestUtil.loadFile((String)"input-file/infile"));
        VerificationResult result = ksi.verify(TestUtil.buildContext(sig, ksi, ksi.getExtendingService(), SignIntegrationTest.getFileHash("input-file/infile")), (Policy)new KeyBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testSignHash_Ok(KSI ksi) throws Exception {
        KSISignature sig = ksi.sign(SignIntegrationTest.getFileHash("input-file/infile"));
        VerificationResult result = ksi.verify(TestUtil.buildContext(sig, ksi, ksi.getExtendingService(), SignIntegrationTest.getFileHash("input-file/infile")), (Policy)new KeyBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testSignHashWithLevel_Ok(KSI ksi) throws Exception {
        KSISignature sig = ksi.sign(SignIntegrationTest.getFileHash("input-file/infile"), 3L);
        VerificationResult result = ksi.verify(TestUtil.buildContext(sig, ksi, ksi.getExtendingService(), SignIntegrationTest.getFileHash("input-file/infile"), 3L), (Policy)new KeyBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testSignFileAndUseInvalidHashForVerification_VerificationFailsWithErrorGen1(KSI ksi) throws Exception {
        KSISignature sig = ksi.sign(CommonTestUtil.loadFile((String)"input-file/infile"));
        VerificationResult result = ksi.verify(TestUtil.buildContext(sig, ksi, ksi.getExtendingService(), SignIntegrationTest.getFileHash("input-file/infile_rev")), (Policy)new KeyBasedVerificationPolicy());
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_01);
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testSignWithLevel_Ok(KSI ksi) throws Exception {
        DataHash dataHash = new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]);
        KSISignature sig = ksi.sign(dataHash, 2L);
        Assert.assertTrue((((AggregationChainLink)sig.getAggregationHashChains()[0].getChainLinks().get(0)).getLevelCorrection() >= 2L ? 1 : 0) != 0, (String)"Signature's first link's level correction is smaller than used for signing.");
        VerificationResult result = ksi.verify(TestUtil.buildContext(sig, ksi, ksi.getExtendingService(), dataHash), (Policy)new KeyBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Level must be between 0 and 255")
    public void testSignWithTooLargeLevel_Ok(KSI ksi) throws Exception {
        ksi.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 257L);
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Level must be between 0 and 255")
    public void testSignWithLessThanZeroLevel_Ok(KSI ksi) throws Exception {
        ksi.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), -1L);
    }

    @Test
    public void testSigningWithLevelRightLinkSiblingData() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-right-link-with-sibling-hash.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 5L);
            this.checkSignatureFirstLink(signature, 5L, false, 2);
        }
    }

    @Test
    public void testSigningWithLevelRightLinkLegacyId() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-right-link-with-legacy-id.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 5L);
            this.checkSignatureFirstLink(signature, 5L, false, 3);
        }
    }

    @Test
    public void testSigningWithLevelRightLinkMetadata() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-right-link-with-metadata.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 5L);
            this.checkSignatureFirstLink(signature, 5L, false, 4);
        }
    }

    @Test
    public void testSigningWithLevelRightLinkSiblingDataAndLevel() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-right-link-with-sibling-hash-and-level-correction.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 2L);
            this.checkSignatureFirstLink(signature, 7L, false, 2);
        }
    }

    @Test
    public void testSigningWithLevelRightLinkLegacyIdAndLevel() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-right-link-with-legacy-id-and-level-correction.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 2L);
            this.checkSignatureFirstLink(signature, 7L, false, 3);
        }
    }

    @Test
    public void testSigningWithLevelRightLinkMetadataAndLevel() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-right-link-with-metadata-and-level-correction.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 2L);
            this.checkSignatureFirstLink(signature, 7L, false, 4);
        }
    }

    @Test
    public void testSigningWithLevelLeftLinkSiblingData() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-left-link-with-sibling-hash.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 5L);
            this.checkSignatureFirstLink(signature, 5L, true, 2);
        }
    }

    @Test
    public void testSigningWithLevelLeftLinkLegacyId() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-left-link-with-legacy-id.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 5L);
            this.checkSignatureFirstLink(signature, 5L, true, 3);
        }
    }

    @Test
    public void testSigningWithLevelLeftLinkMetadata() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-left-link-with-metadata.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 5L);
            this.checkSignatureFirstLink(signature, 5L, true, 4);
        }
    }

    @Test
    public void testSigningWithLevelLeftLinkSiblingDataAndLevel() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-left-link-with-sibling-hash-and-level-correction.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 2L);
            this.checkSignatureFirstLink(signature, 7L, true, 2);
        }
    }

    @Test
    public void testSigningWithLevelLeftLinkLegacyIdAndLevel() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-left-link-with-legacy-id-and-level-correction.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 2L);
            this.checkSignatureFirstLink(signature, 7L, true, 3);
        }
    }

    @Test
    public void testSigningWithLevelLeftLinkMetadataAndLevel() throws Exception {
        try (KSI ksi_ = this.mockSigning("aggregation-responses/aggr-resp-left-link-with-metadata-and-level-correction.tlv");){
            KSISignature signature = ksi_.sign(new DataHash(HashAlgorithm.SHA2_256, new byte[HashAlgorithm.SHA2_256.getLength()]), 2L);
            this.checkSignatureFirstLink(signature, 7L, true, 4);
        }
    }

    private KSI mockSigning(String responseFile) throws Exception {
        final ServiceCredentials signerCredentials = SignIntegrationTest.loadSignerSettings().getCredentials();
        KSISigningService mockedSigningService = (KSISigningService)Mockito.mock(KSISigningService.class);
        final Future mockedFuture = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)mockedFuture.isFinished()).thenReturn((Object)Boolean.TRUE);
        final TLVElement responseTLV = TLVElement.create((byte[])IOUtils.toByteArray((InputStream)CommonTestUtil.load((String)responseFile)));
        Mockito.when((Object)mockedFuture.getResult()).thenReturn((Object)responseTLV);
        Mockito.when((Object)mockedSigningService.sign((DataHash)Mockito.any(DataHash.class), (Long)Mockito.any(Long.TYPE))).then((Answer)new Answer<Future>(){

            public Future<AggregationResponse> answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataHash dataHash = (DataHash)invocationOnMock.getArguments()[0];
                long level = (Long)invocationOnMock.getArguments()[1];
                PduV2Factory factory = new PduV2Factory();
                KSIRequestContext context = RequestContextFactory.DEFAULT_FACTORY.createContext();
                AggregationRequest request = factory.createAggregationRequest(context, signerCredentials, dataHash, Long.valueOf(level));
                ByteArrayInputStream bais = new ByteArrayInputStream(request.toByteArray());
                TLVElement requestElement = TLVElement.create((byte[])Util.toByteArray((InputStream)bais));
                responseTLV.getFirstChildElement(1).setContent(requestElement.getFirstChildElement(1).getEncoded());
                responseTLV.getFirstChildElement(2).getFirstChildElement(1).setLongContent(requestElement.getFirstChildElement(2).getFirstChildElement(1).getDecodedLong().longValue());
                responseTLV.getFirstChildElement(2).getFirstChildElement(2049).getFirstChildElement(5).setDataHashContent(dataHash);
                responseTLV.getFirstChildElement(31).setDataHashContent(TestUtil.calculateHash(responseTLV, responseTLV.getFirstChildElement(31).getDecodedDataHash().getAlgorithm(), signerCredentials.getLoginKey()));
                return new AggregationResponseFuture(mockedFuture, context, signerCredentials, (PduFactory)factory);
            }
        });
        return new KSIBuilder().setKsiProtocolExtenderClient((KSIExtenderClient)new SimpleHttpExtenderClient(SignIntegrationTest.loadExtenderSettings())).setKsiProtocolPublicationsFileClient((KSIPublicationsFileClient)new SimpleHttpPublicationsFileClient(SignIntegrationTest.loadPublicationsFileSettings())).setKsiProtocolSigningService(mockedSigningService).setPublicationsFilePkiTrustStore(SignIntegrationTest.createKeyStore()).setPublicationsFileTrustedCertSelector((CertSelector)SignIntegrationTest.createCertSelector()).build();
    }

    private void checkSignatureFirstLink(KSISignature signature, Long expectedLevel, boolean isLeft, int expectedSiblingType) {
        long level = ((AggregationChainLink)signature.getAggregationHashChains()[0].getChainLinks().get(0)).getLevelCorrection();
        Assert.assertTrue((level == expectedLevel ? 1 : 0) != 0, (String)("Expected link level " + expectedLevel + " but found " + level));
        Assert.assertEquals((boolean)((AggregationChainLink)signature.getAggregationHashChains()[0].getChainLinks().get(0)).isLeft(), (boolean)isLeft, (String)"Expected link direction was not found.");
        Assert.assertNotNull((Object)((TLVStructure)signature.getAggregationHashChains()[0].getChainLinks().get(0)).getRootElement().getFirstChildElement(expectedSiblingType), (String)("Expected sibling data type of " + expectedSiblingType + " was not found."));
    }
}

