/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.KSI;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSIServiceCredentials;
import com.guardtime.ksi.service.client.KSISigningClient;
import com.guardtime.ksi.service.client.ServiceCredentials;
import com.guardtime.ksi.service.client.http.apache.ApacheHttpPublicationsFileClient;
import com.guardtime.ksi.service.http.simple.SimpleHttpPublicationsFileClient;
import com.guardtime.ksi.service.tcp.ExtenderTCPClient;
import com.guardtime.ksi.service.tcp.KSITCPTransactionException;
import com.guardtime.ksi.service.tcp.SigningTCPClient;
import com.guardtime.ksi.service.tcp.TCPClientSettings;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TcpIntegrationTest
extends AbstractCommonIntegrationTest {
    private static final String KSI_INVALID_CREDENTIALS_TCP_DATA_PROVIDER = "ksiInvalidCredentialsTCPDataProvider";
    private static final String VALID_HASH_ALGORITHMS_DATA_PROVIDER = "VALID_HASH_ALGORITHMS";
    private static final String EMPTY_LOGIN_ID = "";
    private static final String SHORT_LOGIN_ID = "a";
    private static final String LONG_LOGIN_ID = "HcGE1poIT09hI9S80WzDE65qzbRIitlSGXfrABGp3yBhYvsaE13at0kLJZtj0jc2SrsUCH1iIF3XlUiB2mEiETh82NC4p5WGzAcM1YsTZEaWSs27aHfIq49jzQRs3LejGVfqNijVsb86RBZWKlZpYIc4alyPaM4eymvMn6Di8VIhEvUpJqfay5REg016NWopK0WfpU6ZcAEX9g4vu0futr1JlGz5UoUAhS0AHRIz62ucr0k88aZI9YHlvJ6Y";
    private static ApacheHttpPublicationsFileClient pubFileClient;
    private static KSISigningClient tcpSigningClient;
    private static KSIExtenderClient tcpExtenderClient;
    private static KSI tcpKsi;
    private static List<Closeable> closeableList;

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @AfterClass
    public void tearDown() throws Exception {
        super.tearDown();
        for (Closeable object : closeableList) {
            object.close();
        }
    }

    @BeforeMethod
    public void testSetUp() throws Exception {
        tcpSigningClient = new SigningTCPClient(TcpIntegrationTest.loadTCPSigningSettings());
        tcpExtenderClient = new ExtenderTCPClient(TcpIntegrationTest.loadTCPExtendingSettings());
        pubFileClient = new ApacheHttpPublicationsFileClient(TcpIntegrationTest.loadPublicationsFileSettings());
        tcpKsi = TcpIntegrationTest.createKsi(tcpExtenderClient, tcpSigningClient, (KSIPublicationsFileClient)pubFileClient);
    }

    @AfterMethod
    public void testTearDown() throws Exception {
        if (pubFileClient != null) {
            pubFileClient.close();
        }
        if (tcpSigningClient != null) {
            tcpSigningClient.close();
        }
        if (tcpExtenderClient != null) {
            tcpExtenderClient.close();
        }
        if (tcpKsi != null) {
            tcpKsi.close();
        }
    }

    @Test(dataProvider="VALID_HASH_ALGORITHMS", groups={"integration"})
    public void testTCPStressingUsingDifferentHashAlgorithms(HashAlgorithm algorithm) throws Exception {
        VerificationResult result = this.signAndVerify(algorithm);
        Thread.sleep(400L);
        VerificationResult result2 = this.signAndVerify(algorithm);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertTrue((boolean)result2.isOk());
    }

    @Test(dataProvider="ksiInvalidCredentialsTCPDataProvider", groups={"integration"}, expectedExceptions={KSITCPTransactionException.class, IllegalArgumentException.class})
    public void testTCPIncorrectLoginCredentialsWithSHA2_256(KSI ksi_) throws Exception {
        ksi_.sign(TcpIntegrationTest.getFileHash("input-file/infile", HashAlgorithm.SHA2_256));
    }

    @Test(dataProvider="ksiInvalidCredentialsTCPDataProvider", groups={"integration"}, expectedExceptions={KSITCPTransactionException.class, IllegalArgumentException.class})
    public void testTCPIncorrectLoginCredentialsWithSHA2_384(KSI ksi_) throws Exception {
        ksi_.sign(TcpIntegrationTest.getFileHash("input-file/infile", HashAlgorithm.SHA2_384));
    }

    @Test(dataProvider="ksiInvalidCredentialsTCPDataProvider", groups={"integration"}, expectedExceptions={KSITCPTransactionException.class, IllegalArgumentException.class})
    public void testTCPIncorrectLoginCredentialsWithSHA2_512(KSI ksi_) throws Exception {
        ksi_.sign(TcpIntegrationTest.getFileHash("input-file/infile", HashAlgorithm.SHA2_512));
    }

    @Test(dataProvider="ksiInvalidCredentialsTCPDataProvider", groups={"integration"}, expectedExceptions={KSITCPTransactionException.class, IllegalArgumentException.class})
    public void testTCPIncorrectLoginCredentialsWithRIPEMD_160(KSI ksi_) throws Exception {
        ksi_.sign(TcpIntegrationTest.getFileHash("input-file/infile", HashAlgorithm.RIPEMD_160));
    }

    @Test(dataProvider="VALID_HASH_ALGORITHMS", groups={"integration"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Hash size.* does not match .* size.*")
    public void testTcpWithShortHash(HashAlgorithm hashAlgorithm) throws Exception {
        int hashLength = hashAlgorithm.getLength();
        tcpKsi.sign(new DataHash(hashAlgorithm, new byte[hashLength - 1]));
    }

    @Test(dataProvider="VALID_HASH_ALGORITHMS", groups={"integration"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="Hash size.* does not match .* size.*")
    public void testTcpWithLongHash(HashAlgorithm hashAlgorithm) throws Exception {
        int hashLength = hashAlgorithm.getLength();
        tcpKsi.sign(new DataHash(hashAlgorithm, new byte[hashLength + 1]));
    }

    @Test(groups={"integration"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The connector is being disposed.")
    public void tcpSigningClientSettingsConnector() throws Exception {
        try (KSI ksi_ = TcpIntegrationTest.createKsi(tcpExtenderClient, tcpSigningClient, (KSIPublicationsFileClient)pubFileClient);){
            tcpSigningClient.close();
            ksi_.sign(new byte[0]);
        }
    }

    @Test(groups={"integration"})
    public void testTcpExtenderClient_OK() throws Exception {
        try (KSI ksi_ = TcpIntegrationTest.createKsi(tcpExtenderClient, tcpSigningClient, (KSIPublicationsFileClient)pubFileClient);){
            ksi_.extend(TestUtil.loadSignature("signatures/ok-sig-2014-06-2.ksig"));
        }
    }

    @Test(groups={"integration"}, expectedExceptions={IllegalStateException.class}, expectedExceptionsMessageRegExp="The connector is being disposed.")
    public void testTcpExtenderClientSettingsConnector() throws Exception {
        try (KSI ksi_ = TcpIntegrationTest.createKsi(tcpExtenderClient, tcpSigningClient, (KSIPublicationsFileClient)pubFileClient);){
            tcpExtenderClient.close();
            ksi_.extend(TestUtil.loadSignature("signatures/ok-sig-2014-06-2.ksig"));
        }
    }

    @Test(groups={"integration"})
    public void testClosingOneTcpClientDoesNotCloseTheOther() throws Exception {
        try (KSI ksi_ = TcpIntegrationTest.createKsi(tcpExtenderClient, tcpSigningClient, (KSIPublicationsFileClient)pubFileClient);){
            tcpSigningClient.close();
            ksi_.extend(TestUtil.loadSignature("signatures/ok-sig-2014-06-2.ksig"));
        }
    }

    private VerificationResult signAndVerify(HashAlgorithm algorithm) throws Exception {
        DataHash fileHash = TcpIntegrationTest.getFileHash("input-file/infile", algorithm);
        KSISignature sig = this.ksi.sign(fileHash);
        return this.ksi.verify(TestUtil.buildContext(sig, tcpKsi, tcpExtenderClient, fileHash), (Policy)new KeyBasedVerificationPolicy());
    }

    @DataProvider(name="VALID_HASH_ALGORITHMS")
    private static Object[][] hashAlgorithmProvider() {
        ArrayList<HashAlgorithm> hashAlgorithms = new ArrayList<HashAlgorithm>();
        HashAlgorithm[] allAlgorithms = HashAlgorithm.values();
        Date currentDate = new Date();
        for (HashAlgorithm algorithm : allAlgorithms) {
            if (!HashAlgorithm.Status.NORMAL.equals((Object)algorithm.getStatus()) || algorithm.isDeprecated(currentDate)) continue;
            hashAlgorithms.add(algorithm);
        }
        Object[][] data = new Object[hashAlgorithms.size()][1];
        for (int i = 0; i < hashAlgorithms.size(); ++i) {
            data[i] = new Object[]{hashAlgorithms.get(i)};
        }
        return data;
    }

    @DataProvider(name="ksiInvalidCredentialsTCPDataProvider")
    private static Object[][] credentialsTransportProtocols() throws Exception {
        TCPClientSettings emptyTcpSettings = TcpIntegrationTest.loadTCPSettings(EMPTY_LOGIN_ID, EMPTY_LOGIN_ID);
        TCPClientSettings shortTcpSettings = TcpIntegrationTest.loadTCPSettings(SHORT_LOGIN_ID, SHORT_LOGIN_ID);
        TCPClientSettings longTcpSettings = TcpIntegrationTest.loadTCPSettings(LONG_LOGIN_ID, LONG_LOGIN_ID);
        SigningTCPClient emptyTcpClient = new SigningTCPClient(emptyTcpSettings);
        SigningTCPClient shortTcpClient = new SigningTCPClient(shortTcpSettings);
        SigningTCPClient longTcpClient = new SigningTCPClient(longTcpSettings);
        return new Object[][]{{TcpIntegrationTest.addToList((Closeable)TcpIntegrationTest.createKsi((KSIExtenderClient)new ExtenderTCPClient(TcpIntegrationTest.loadTCPExtendingSettings()), (KSISigningClient)emptyTcpClient, (KSIPublicationsFileClient)new SimpleHttpPublicationsFileClient(TcpIntegrationTest.loadPublicationsFileSettings())), closeableList)}, {TcpIntegrationTest.addToList((Closeable)TcpIntegrationTest.createKsi((KSIExtenderClient)new ExtenderTCPClient(TcpIntegrationTest.loadTCPExtendingSettings()), (KSISigningClient)shortTcpClient, (KSIPublicationsFileClient)new SimpleHttpPublicationsFileClient(TcpIntegrationTest.loadPublicationsFileSettings())), closeableList)}, {TcpIntegrationTest.addToList((Closeable)TcpIntegrationTest.createKsi((KSIExtenderClient)new ExtenderTCPClient(TcpIntegrationTest.loadTCPExtendingSettings()), (KSISigningClient)longTcpClient, (KSIPublicationsFileClient)new SimpleHttpPublicationsFileClient(TcpIntegrationTest.loadPublicationsFileSettings())), closeableList)}};
    }

    private static TCPClientSettings loadTCPSettings(String loginId, String loginKey) throws IOException {
        TCPClientSettings settings = TcpIntegrationTest.loadTCPSigningSettings();
        int tcpTransactionTimeoutSec = 1;
        KSIServiceCredentials serviceCredentials = new KSIServiceCredentials(loginId, loginKey);
        return new TCPClientSettings(settings.getEndpoint(), tcpTransactionTimeoutSec, (ServiceCredentials)serviceCredentials);
    }

    static {
        closeableList = new LinkedList<Closeable>();
    }
}

