/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.Extender;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicyAdapter;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.UserProvidedPublicationBasedVerificationPolicy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UserProvidedPublicationPolicyIntegrationTest
extends AbstractCommonIntegrationTest {
    private final UserProvidedPublicationBasedVerificationPolicy policy = new UserProvidedPublicationBasedVerificationPolicy();
    private static final String PUBLICATION_STRING_2017_03_15 = "AAAAAA-CYZBC2-QANONS-4PPSPX-M3UFZ2-ZD3MEV-YUG4LI-KNWRAU-TZHEB6-V7SCG6-J4QK56-OKW6FT";
    private static final String PUBLICATION_STRING_2017_03_18 = "AAAAAA-CYZTMY-QAPFTQ-SBXAY7-FNALRQ-HJ6QP4-U2CDTJ-OYLEND-DOHU47-QE7N27-OQHZPG-NVTZRV";

    @Test(groups={"integration"})
    public void testVerifySignatureWithNoPublicationRecordinExtendingAllowed_VerificationReturnsOk() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        PublicationData publicationData = new PublicationData(PUBLICATION_STRING_2017_03_15);
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, (Policy)this.policy, publicationData, true);
        Assert.assertTrue((boolean)result.isOk());
        result = this.verifyWithContext(signature, publicationData, true);
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithCorrectData_VerificationReturnsOk() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, (Policy)this.policy, signature.getPublicationRecord().getPublicationData(), false);
        Assert.assertTrue((boolean)result.isOk());
        result = this.verifyWithContext(signature, signature.getPublicationRecord().getPublicationData(), false);
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifySignatureUsingDifferentPublication_VerificationReturnsOk() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        PublicationData publicationData = new PublicationData(PUBLICATION_STRING_2017_03_18);
        VerificationResult result = this.verify(this.ksi, (KSIExtenderClient)this.extenderClient, signature, (Policy)this.policy, publicationData, true);
        Assert.assertTrue((boolean)result.isOk());
        result = this.verifyWithContext(signature, publicationData, true);
        Assert.assertTrue((boolean)result.isOk());
    }

    public VerificationResult verifyWithContext(KSISignature signature, PublicationData userPublication, boolean extendingAllowed) throws Exception {
        Extender extender = this.getExtender(this.ksi.getExtendingService(), (KSIPublicationsFileClient)this.publicationsFileClient);
        return this.ksi.verify(signature, ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)userPublication, (Extender)(extendingAllowed ? extender : null)));
    }
}

