/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.integration;

import com.guardtime.ksi.Extender;
import com.guardtime.ksi.ExtenderBuilder;
import com.guardtime.ksi.KSI;
import com.guardtime.ksi.PublicationsHandler;
import com.guardtime.ksi.SignatureVerifier;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.integration.AbstractCommonIntegrationTest;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationRecord;
import com.guardtime.ksi.service.KSIExtendingClientServiceAdapter;
import com.guardtime.ksi.service.KSIExtendingService;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.service.client.KSIPublicationsFileClient;
import com.guardtime.ksi.service.client.KSIServiceCredentials;
import com.guardtime.ksi.service.client.ServiceCredentials;
import com.guardtime.ksi.service.client.http.CredentialsAwareHttpSettings;
import com.guardtime.ksi.service.http.simple.SimpleHttpExtenderClient;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.verifier.PolicyVerificationResult;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.policies.CalendarBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicy;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicyAdapter;
import com.guardtime.ksi.unisignature.verifier.policies.KeyBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.policies.PublicationsFileBasedVerificationPolicy;
import com.guardtime.ksi.unisignature.verifier.policies.UserProvidedPublicationBasedVerificationPolicy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VerifyIntegrationTest
extends AbstractCommonIntegrationTest {
    @Test(groups={"integration"})
    public void testVerifySignatureUsingKeyBasedPolicy_Ok() throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = this.verify(this.ksi, (KSIExtendingService)new KSIExtendingClientServiceAdapter((KSIExtenderClient)this.extenderClient), sig, (Policy)new KeyBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifySignatureUsingCalendarBasedPolicy_Ok(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = this.verify(ksi, (KSIExtendingService)new KSIExtendingClientServiceAdapter((KSIExtenderClient)this.extenderClient), sig, (Policy)new CalendarBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifySignatureWithUsingPublicationsFileBasedVerificationPolicy_Ok(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = this.verify(ksi, (KSIExtenderClient)this.extenderClient, sig, (Policy)new PublicationsFileBasedVerificationPolicy(), true);
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyExtendedSignatureWithUserProvidedPublicationString_OK() throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        VerificationResult result = this.ksi.verify(TestUtil.buildContext(sig, this.ksi, (KSIExtenderClient)this.extenderClient, sig.getPublicationRecord().getPublicationData()), (Policy)new UserProvidedPublicationBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyExtendedSignatureUsingKeyBasedPolicy_FailInconclusive() throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        VerificationResult result = this.verify(this.ksi, (KSIExtendingService)new KSIExtendingClientServiceAdapter((KSIExtenderClient)this.extenderClient), sig, (Policy)new KeyBasedVerificationPolicy());
        Assert.assertFalse((boolean)result.isOk());
        PolicyVerificationResult policyVerificationResult = (PolicyVerificationResult)result.getPolicyVerificationResults().get(0);
        Assert.assertEquals((Object)policyVerificationResult.getPolicyStatus(), (Object)VerificationResultCode.NA);
        Assert.assertEquals((Object)policyVerificationResult.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifyExtendedSignatureUsingCalendarBasedPolicy_Ok(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        VerificationResult result = this.verify(ksi, (KSIExtendingService)new KSIExtendingClientServiceAdapter((KSIExtenderClient)this.extenderClient), sig, (Policy)new CalendarBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifyExtendedSignatureUsingPublicationsFileBasedPolicy_Ok(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        VerificationResult result = this.verify(ksi, (KSIExtenderClient)this.extenderClient, sig, (Policy)new PublicationsFileBasedVerificationPolicy(), true);
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifyExtendedSignatureUsingUserProvidedPublicationsBasedPolicyAllowExtending_Ok(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        PublicationRecord publication = ksi.getPublicationsFile().getPublicationRecord(sig.getAggregationTime());
        VerificationResult result = ksi.verify(TestUtil.buildContext(sig, ksi, (KSIExtenderClient)this.extenderClient, publication.getPublicationData(), true), (Policy)new UserProvidedPublicationBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyOfflineKSIRfc3161SignatureUsingKeyBasedPolicy() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig");
        VerificationResult result = this.ksi.verify(TestUtil.buildContext(signature, this.ksi, (KSIExtenderClient)this.extenderClient, VerifyIntegrationTest.getFileHash("input-file/infile", "SHA2-256")), (Policy)new KeyBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifyOnlineKSIRfc3161SignatureUsingCalendarBasedVerificationPolicy(KSI ksi) throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig");
        VerificationResult result = ksi.verify(TestUtil.buildContext(signature, ksi, (KSIExtenderClient)this.extenderClient, VerifyIntegrationTest.getFileHash("input-file/infile", "SHA2-256")), (Policy)new CalendarBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyOnlineExtendedKSIRfc3161SignatureWithPublicationString() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/rfc3161-signature-extended-for-publication-file-based-verification.ksig");
        VerificationResult result = this.ksi.verify(TestUtil.buildContext(signature, this.ksi, (KSIExtenderClient)this.extenderClient, signature.getPublicationRecord().getPublicationData()), (Policy)new UserProvidedPublicationBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifyOfflineExtendedKSIRfc3161Signature() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/rfc3161-signature-extended-for-publication-file-based-verification.ksig");
        VerificationResult result = this.ksi.verify(TestUtil.buildContext(signature, this.ksi, (KSIExtenderClient)this.extenderClient, signature.getInputHash()), (Policy)new PublicationsFileBasedVerificationPolicy());
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testVerifySignatureUsingContextKeyBasedPolicy_Ok() throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = this.ksi.verify(sig, ContextAwarePolicyAdapter.createKeyPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient)));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifySignatureUsingContextCalendarBasedPolicy_Ok(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = ksi.verify(sig, ContextAwarePolicyAdapter.createCalendarPolicy((Extender)this.getExtender(ksi.getExtendingService(), (KSIPublicationsFileClient)this.publicationsFileClient)));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifySignatureUsingContextPublicationsFilePolicy_Ok(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = ksi.verify(sig, ContextAwarePolicyAdapter.createPublicationsFilePolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), (Extender)this.getExtender(ksi.getExtendingService(), (KSIPublicationsFileClient)this.publicationsFileClient)));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifySignatureUsingContextPublicationsFilePolicyExtendingNotAllowed_NA(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = ksi.verify(sig, ContextAwarePolicyAdapter.createPublicationsFilePolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient)));
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }

    @Test(groups={"integration"})
    public void testVerifyOfflineExtendedKSIRfc3161SignatureUsingContextPublicationsFilePolicy_Ok() throws Exception {
        KSISignature sig = TestUtil.loadSignature("valid-signatures/rfc3161-signature-extended-for-publication-file-based-verification.ksig");
        VerificationResult result = this.ksi.verify(sig, ContextAwarePolicyAdapter.createPublicationsFilePolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient)));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(dataProvider="ksiDataProvider", groups={"integration"})
    public void testVerifyExtendedSignatureWithContextUserProvidedPublicationString_OK(KSI ksi) throws Exception {
        KSISignature sig = TestUtil.loadSignature("signatures/ok-sig-2017-03-14-extended.ksig");
        VerificationResult result = ksi.verify(sig, ContextAwarePolicyAdapter.createUserProvidedPublicationPolicy((PublicationData)sig.getPublicationRecord().getPublicationData(), (Extender)this.getExtender(ksi.getExtendingService(), (KSIPublicationsFileClient)this.publicationsFileClient)));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithExtendedSignature_OK() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2014-06-2-extended.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), null));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithNotExtendedSignatureAndExtending_OK() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), (Extender)this.createExtender(VerifyIntegrationTest.loadExtenderSettings())));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithNotExtendedSignatureAndNoExtender_OK() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), null));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithExtendedSignatureAndInvalidExtender_OK() throws Exception {
        CredentialsAwareHttpSettings settings = new CredentialsAwareHttpSettings("http://random.url.com:1234", (ServiceCredentials)new KSIServiceCredentials("user", "pass"));
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2014-06-2-extended.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), (Extender)this.createExtender(settings)));
        Assert.assertTrue((boolean)result.isOk());
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithExtendedSignatureAndNoExtender_NA() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/signature-one-aggregation-chain-and-chc.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), null));
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithExtendedSignatureAndErrorAtPublicationRecord_Fail() throws Exception {
        KSISignature signature = TestUtil.loadSignature("policy-verification-signatures/policy-verification-signature-other-core-extended-signature-to-publication-file-PUB-05.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), null));
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.PUB_05);
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithNotExtendedSignatureAndErrorAtExtending_Fail() throws Exception {
        KSISignature signature = TestUtil.loadSignature("policy-verification-signatures/policy-verification-signature-other-core-signature.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), (Extender)this.createExtender(VerifyIntegrationTest.loadExtenderSettings())));
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.PUB_03);
    }

    @Test(groups={"integration"})
    public void testDefaultPolicyWithNotExtendedSignatureAndFailAtkeybasedVerification_Fail() throws Exception {
        KSISignature signature = TestUtil.loadSignature("policy-verification-signatures/policy-verification-signature-changed-certificate-id-GEN-02.ksig");
        VerificationResult result = new SignatureVerifier().verify(signature, ContextAwarePolicyAdapter.createDefaultPolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), null));
        Assert.assertFalse((boolean)result.isOk());
        Assert.assertEquals((Object)result.getErrorCode(), (Object)VerificationErrorCode.GEN_02);
    }

    @Test(groups={"integration"})
    public void testVerifySignatureWithOnlyAggregationChainsUsingPublicationFilePolicy_Ok() throws Exception {
        KSISignature sig = TestUtil.loadSignature("valid-signatures/signature-only-aggregation-chains.ksig");
        ContextAwarePolicy policy = ContextAwarePolicyAdapter.createPublicationsFilePolicy((PublicationsHandler)this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient), (Extender)this.getExtender(this.ksi.getExtendingService(), (KSIPublicationsFileClient)this.publicationsFileClient));
        VerificationResult result = this.ksi.verify(sig, (Policy)policy);
        Assert.assertTrue((boolean)result.isOk());
    }

    private Extender createExtender(CredentialsAwareHttpSettings settings) throws Exception {
        SimpleHttpExtenderClient client = new SimpleHttpExtenderClient(settings);
        KSIExtendingClientServiceAdapter adapter = new KSIExtendingClientServiceAdapter((KSIExtenderClient)client);
        return new ExtenderBuilder().setExtendingService((KSIExtendingService)adapter).setPublicationsHandler(this.getPublicationsHandler((KSIPublicationsFileClient)this.publicationsFileClient)).build();
    }
}

