/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.publication;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.InvalidPublicationDataException;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.tlv.TLVParserException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PublicationDataTest {
    public static final String PUBLICATION_STRING = "AAAAAA-CTJR3I-AANBWU-RY76YF-7TH2M5-KGEZVA-WLLRGD-3GKYBG-AM5WWV-4MCLSP-XPRDDI-UFMHBA";

    @Test
    public void testDecodePublicationData_Ok() throws Exception {
        PublicationData publication = this.load(TestUtil.load((String)"components/publication-data/publication-data-ok.tlv"));
        Assert.assertNotNull((Object)publication);
        Assert.assertNotNull((Object)publication.getPublicationTime());
        Assert.assertNotNull((Object)publication.getPublicationDataHash());
    }

    @Test(expectedExceptions={TLVParserException.class}, expectedExceptionsMessageRegExp="Invalid TLV element. Expected.*")
    public void testDecodeInvalidPublicationData_ThrowsTLVParserException() throws Exception {
        this.load(new ByteArrayInputStream(new byte[]{9, 0}));
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class})
    public void testDecodePublicationDataWithoutAnyChildrenElements_ThrowsInvalidPublicationDataEception() throws Exception {
        this.load(new ByteArrayInputStream(new byte[]{16, 0}));
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class}, expectedExceptionsMessageRegExp="Publication data publication hash can not be null")
    public void testDecodePublicationDataWithoutPublicationHash_ThrowsInvalidPublicationDataEception() throws Exception {
        this.load(new ByteArrayInputStream(new byte[]{16, 2, 2, 0}));
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class}, expectedExceptionsMessageRegExp="Publication data publication time can not be null")
    public void testDecodePublicationDataWithoutPublicationTime_ThrowsInvalidPublicationDataEception() throws Exception {
        this.load(new ByteArrayInputStream(new byte[]{16, 2, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
    }

    @Test
    public void testCreatePublicationData_Ok() throws Exception {
        PublicationData publicationData = new PublicationData(new Date(1000L), new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        publicationData.writeTo((OutputStream)out);
        Assert.assertEquals((byte[])out.toByteArray(), (byte[])new byte[]{48, 38, 2, 1, 1, 4, 33, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
        Assert.assertEquals((Object)publicationData.getPublicationDataHash(), (Object)new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        Assert.assertEquals((long)publicationData.getPublicationTime().getTime(), (long)1000L);
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class}, expectedExceptionsMessageRegExp="Publication data publication time can not be null")
    public void testCreatePublicationDataWithoutPublicationTime_ThrowsInvalidPublicationDataEception() throws Exception {
        new PublicationData(null, new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class}, expectedExceptionsMessageRegExp="Publication data publication hash can not be null")
    public void testCreatePublicationDataWithoutPublicationHash_ThrowsInvalidPublicationDataEception() throws Exception {
        new PublicationData(new Date(1000L), null);
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class}, expectedExceptionsMessageRegExp="Publication data publication string can not be null")
    public void testCreatePublicationDataUsingInvalidPublicationString_ThrowsInvalidPublicationDataEception() throws Exception {
        new PublicationData((String)null);
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class}, expectedExceptionsMessageRegExp="Invalid publication string: Base32 decode failed")
    public void testCreatePublicationDataUsingInvalidEncodedPublicationString_ThrowsInvalidPublicationDataEception() throws Exception {
        new PublicationData("NN2WW2LNOVVWS===");
    }

    @Test(expectedExceptions={InvalidPublicationDataException.class}, expectedExceptionsMessageRegExp="Invalid publication string: CRC32 Check failed")
    public void testCreatePublicationDataUsingInvalidPublicationStringCRC32_ThrowsInvalidPublicationDataException() throws Exception {
        new PublicationData("GEZTSOBRGU2DQNRUJ5GEKTSJJRKVGSCBKNEEGUSDGMZA====");
    }

    @Test
    public void testCreatePublicationDataUsingPublicationString_Ok() throws Exception {
        PublicationData publicationData = new PublicationData(PUBLICATION_STRING);
        Assert.assertEquals((String)publicationData.getPublicationString(), (String)PUBLICATION_STRING);
    }

    private PublicationData load(InputStream input) throws Exception {
        return new PublicationData(CommonTestUtil.loadTlv((InputStream)input));
    }
}

