/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.publication.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.inmemory.InvalidPublicationRecordException;
import com.guardtime.ksi.publication.inmemory.PublicationsFilePublicationRecord;
import com.guardtime.ksi.tlv.TLVElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PublicationsFilePublicationRecordTest {
    private static final String PUBLICATION_STRING = "AAAAAA-CTJR3I-AANBWU-RY76YF-7TH2M5-KGEZVA-WLLRGD-3GKYBG-AM5WWV-4MCLSP-XPRDDI-UFMHBA";
    private static final int ELEMENT_TAG_PUBLICATION_REFERENCE = 9;
    private static final int ELEMENT_TAG_PUBLICATION_REPOSITORY_URI = 10;

    @Test
    public void testDecodePublicationFileRecord_Ok() throws Exception {
        PublicationsFilePublicationRecord publicationRecord = this.load(TestUtil.load((String)"components/publication-record/publication-record-pubfile-ok.tlv"));
        Assert.assertNotNull((Object)publicationRecord.getPublicationData());
        Assert.assertNotNull((Object)publicationRecord.getPublicationData().getPublicationTime());
        Assert.assertEquals((Object)publicationRecord.getPublicationData().getPublicationDataHash(), (Object)new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        Assert.assertTrue((boolean)publicationRecord.getPublicationReferences().isEmpty());
        Assert.assertTrue((boolean)publicationRecord.getPublicationRepositoryURIs().isEmpty());
    }

    @Test
    public void testDecodePublicationsFilePublicationRecordWithReferencesAndRepositoryURI_Ok() throws Exception {
        PublicationsFilePublicationRecord publicationRecord = this.load(TestUtil.load((String)"components/publication-record/publication-record-pubfile-with-ref-and-uri-ok.tlv"));
        Assert.assertNotNull((Object)publicationRecord.getPublicationData());
        Assert.assertNotNull((Object)publicationRecord.getPublicationData().getPublicationTime());
        Assert.assertEquals((Object)publicationRecord.getPublicationData().getPublicationDataHash(), (Object)new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        Assert.assertFalse((boolean)publicationRecord.getPublicationReferences().isEmpty());
        Assert.assertEquals((int)publicationRecord.getPublicationReferences().size(), (int)2);
        Assert.assertFalse((boolean)publicationRecord.getPublicationRepositoryURIs().isEmpty());
        Assert.assertEquals((int)publicationRecord.getPublicationRepositoryURIs().size(), (int)2);
    }

    @Test
    public void testCreateNewPublicationFileRecord_Ok() throws Exception {
        PublicationsFilePublicationRecord publicationRecord = new PublicationsFilePublicationRecord(new PublicationData(PUBLICATION_STRING), Arrays.asList("ref1", "ref2"), Collections.singletonList("uri1"));
        Assert.assertNotNull((Object)publicationRecord.getPublicationData());
        Assert.assertNotNull((Object)publicationRecord.getPublicationReferences());
        Assert.assertNotNull((Object)publicationRecord.getRootElement());
        Assert.assertEquals((int)publicationRecord.getPublicationReferences().size(), (int)2);
        Assert.assertEquals((int)publicationRecord.getPublicationRepositoryURIs().size(), (int)1);
        TLVElement rootElement = publicationRecord.getRootElement();
        Assert.assertEquals((int)rootElement.getChildElements(9).size(), (int)2);
        Assert.assertEquals((int)rootElement.getChildElements(10).size(), (int)1);
    }

    @Test(expectedExceptions={InvalidPublicationRecordException.class}, expectedExceptionsMessageRegExp="Required field publicationData\\(TLV\\[0x10\\]\\) missing in # PublicationRecord TLV\\[0x703\\]")
    public void testDecodePublicationsFilePublicationRecordWithoutPublicationData_ThrowsInvalidPublicationRecordException() throws Exception {
        this.load(new ByteArrayInputStream(new byte[]{-121, 3, 0, 0}));
    }

    private PublicationsFilePublicationRecord load(InputStream file) throws Exception {
        return new PublicationsFilePublicationRecord(CommonTestUtil.loadTlv((InputStream)file));
    }
}

