/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.trust;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.trust.CMSSignature;
import com.guardtime.ksi.trust.CMSSignatureVerifier;
import com.guardtime.ksi.trust.InvalidCmsSignatureException;
import com.guardtime.ksi.trust.JKSTrustStore;
import com.guardtime.ksi.trust.PKITrustStore;
import java.util.ArrayList;
import org.bouncycastle.cms.SignerInformationStore;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CMSSignatureVerifierTest {
    private JKSTrustStore trustStore;
    private CMSSignature mockedSignature;
    private SignerInformationStore signatureStore;

    @BeforeMethod
    public void setUp() throws Exception {
        this.trustStore = new JKSTrustStore("truststore.jks", null);
        this.mockedSignature = (CMSSignature)Mockito.mock(CMSSignature.class);
        this.signatureStore = (SignerInformationStore)Mockito.mock(SignerInformationStore.class);
        Mockito.when((Object)this.mockedSignature.getSignerInformationStore()).thenReturn((Object)this.signatureStore);
    }

    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="Invalid CMS signature. Signature does not contain SignerInformation element.")
    public void testVerifySignatureWithoutAnySignerInformationElement_ThrowsInvalidCmsSignatureException() throws Exception {
        Mockito.when((Object)this.signatureStore.getSigners()).thenReturn(new ArrayList());
        CMSSignatureVerifier verifier = new CMSSignatureVerifier((PKITrustStore)this.trustStore);
        verifier.verify(this.mockedSignature);
    }

    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="Invalid CMS signature. Signature contains multiple SignerInformation elements.")
    public void testVerifySignatureWithMultipleSignerInformationElements_ThrowsInvalidCmsSignatureException() throws Exception {
        ArrayList<Object> collection = new ArrayList<Object>();
        collection.add(null);
        collection.add(null);
        Mockito.when((Object)this.signatureStore.getSigners()).thenReturn(collection);
        CMSSignatureVerifier verifier = new CMSSignatureVerifier((PKITrustStore)this.trustStore);
        verifier.verify(this.mockedSignature);
    }

    @Test
    public void testVerifySignature_Ok() throws Exception {
        CMSSignature signature = new CMSSignature(TestUtil.loadBytes("components/cms-signature/signed-data"), TestUtil.loadBytes("components/cms-signature/cms-signature-ok.pkcs7"));
        CMSSignatureVerifier verifier = new CMSSignatureVerifier((PKITrustStore)this.trustStore);
        verifier.verify(signature);
        Assert.assertTrue((boolean)true);
    }

    @Test(expectedExceptions={InvalidCmsSignatureException.class}, expectedExceptionsMessageRegExp="Invalid CMS signature.*")
    public void testVerifySignatureUsingInvalidSignedData_ThrowsInvalidCmsSignatureException() throws Exception {
        CMSSignature signature = new CMSSignature(new byte[128], TestUtil.loadBytes("components/cms-signature/cms-signature-ok.pkcs7"));
        CMSSignatureVerifier verifier = new CMSSignatureVerifier((PKITrustStore)this.trustStore);
        verifier.verify(signature);
    }
}

