/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.trust;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.trust.CryptoException;
import com.guardtime.ksi.trust.InvalidCertificateException;
import com.guardtime.ksi.trust.InvalidKeyStoreException;
import com.guardtime.ksi.trust.JKSTrustStore;
import com.guardtime.ksi.trust.X509CertificateSubjectRdnSelector;
import com.guardtime.ksi.util.Util;
import com.guardtime.ksi.util.X509CertUtil;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertSelector;
import java.security.cert.X509Certificate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JKSTrustStoreTest {
    @Test(expectedExceptions={InvalidKeyStoreException.class}, expectedExceptionsMessageRegExp="Invalid input parameter. Key store must be present")
    public void testCreateJKSTrustStore_ThrowsInvalidKeyStoreException() throws Exception {
        new JKSTrustStore((KeyStore)null, null);
    }

    @Test(expectedExceptions={InvalidKeyStoreException.class}, expectedExceptionsMessageRegExp="Invalid input parameter. Key store path must be present")
    public void testCreateJKSTrustStoreWithoutKeyStorePath_ThrowsInvalidKeyStoreException() throws Exception {
        new JKSTrustStore((String)null, null);
    }

    @Test(expectedExceptions={InvalidKeyStoreException.class}, expectedExceptionsMessageRegExp="Loading java key store with path my_file failed")
    public void testCreateJKSTrustStoreFromFileThatDoesNotExist_ThrowsInvalidKeyStoreException() throws Exception {
        new JKSTrustStore("my_file", "password".toCharArray(), null);
    }

    @Test(expectedExceptions={CryptoException.class}, expectedExceptionsMessageRegExp="Invalid input parameter. Certificate can not be null")
    public void testCheckIfCertificateIsTrustedUsingInvalidInput_ThrowsCryptoException() throws Exception {
        JKSTrustStore trustStore = new JKSTrustStore("truststore.jks", null);
        trustStore.isTrusted(null, null);
    }

    @Test
    public void testCheckIfCertificateIsTrusted_Ok() throws Exception {
        JKSTrustStore trustStore = new JKSTrustStore("truststore.jks", null);
        Assert.assertTrue((boolean)trustStore.isTrusted((X509Certificate)X509CertUtil.toCert((byte[])Util.toByteArray((InputStream)TestUtil.load((String)"server.crt"))), null));
    }

    @Test
    public void testCheckIfCertificateIsTrustedWithEmail_Ok() throws Exception {
        JKSTrustStore trustStore = new JKSTrustStore("truststore.jks", null, (CertSelector)new X509CertificateSubjectRdnSelector("E=publications@guardtime.com"));
        Assert.assertTrue((boolean)trustStore.isTrusted((X509Certificate)X509CertUtil.toCert((byte[])Util.toByteArray((InputStream)TestUtil.load((String)"server.crt"))), null));
    }

    @Test(expectedExceptions={InvalidCertificateException.class}, expectedExceptionsMessageRegExp="Invalid certificated subject with subjectDN EMAILADDRESS=publications@guardtime.com.*")
    public void testCheckIfCertificateIsTrustedWithInvalidEmail_ThrowsInvalidCertificateSubjectException() throws Exception {
        JKSTrustStore trustStore = new JKSTrustStore("truststore.jks", null, (CertSelector)new X509CertificateSubjectRdnSelector("E=invalid_publications@guardtime.com"));
        Assert.assertTrue((boolean)trustStore.isTrusted((X509Certificate)X509CertUtil.toCert((byte[])Util.toByteArray((InputStream)TestUtil.load((String)"server.crt"))), null));
    }

    @Test
    public void testCheckUntrustedCertificate_Ok() throws Exception {
        JKSTrustStore trustStore = new JKSTrustStore("truststore.jks", null);
        Assert.assertFalse((boolean)trustStore.isTrusted((X509Certificate)X509CertUtil.toCert((byte[])Util.toByteArray((InputStream)TestUtil.load((String)"cert.crt"))), null));
    }

    @Test(expectedExceptions={CryptoException.class}, expectedExceptionsMessageRegExp="General security error occurred. Uninitialized keystore")
    public void testUseUninitializedKeyStore_ThrowsCryptoException() throws Exception {
        JKSTrustStore trustStore = new JKSTrustStore(KeyStore.getInstance("JKS"), null);
        trustStore.isTrusted((X509Certificate)X509CertUtil.toCert((byte[])Util.toByteArray((InputStream)TestUtil.load((String)"server.crt"))), null);
    }
}

