/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.trust;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.trust.X509CertificateSubjectRdnSelector;
import com.guardtime.ksi.util.X509CertUtil;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.testng.Assert;
import org.testng.annotations.Test;

public class X509CertificateSubjectRdnSelectorTest {
    private static final AttributeTypeAndValue EMAIL = new AttributeTypeAndValue(BCStyle.EmailAddress, (ASN1Encodable)new DERIA5String("publications@guardtime.com"));
    private static final AttributeTypeAndValue EMAIL_INVALID = new AttributeTypeAndValue(BCStyle.EmailAddress, (ASN1Encodable)new DERIA5String("pub@kala.com"));

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="Invalid input parameter.At least one RDN must be present")
    public void testCreateSelectorWithMissingRdnArray_ThrowsKSIException() throws Exception {
        new X509CertificateSubjectRdnSelector((RDN[])null);
    }

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="Invalid input parameter.At least one RDN must be present")
    public void testCreateSelectorWithEmptyRdnArray_ThrowsKSIException() throws Exception {
        new X509CertificateSubjectRdnSelector(new RDN[0]);
    }

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="Invalid input parameter. RDN string must be present")
    public void testCreateSelectorWithMissingRdnString_ThrowsKSIException() throws Exception {
        new X509CertificateSubjectRdnSelector((String)null);
    }

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="Invalid input parameter. RDN string must be present")
    public void testCreateSelectorWithEmptyRdnString_ThrowsKSIException() throws Exception {
        new X509CertificateSubjectRdnSelector("");
    }

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="Multi-valued certificate constraints aren't supported")
    public void testMultiValuedRdn_ThrowsKSIException() throws Exception {
        new X509CertificateSubjectRdnSelector("CN=Test+E=publications@guardtime.com");
    }

    @Test
    public void testX509CertificateMatches_Ok() throws Exception {
        X509CertificateSubjectRdnSelector certSelector = new X509CertificateSubjectRdnSelector("E=publications@guardtime.com");
        Assert.assertTrue((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testX509CertificateMatchesUsingLongRdnType_Ok() throws Exception {
        X509CertificateSubjectRdnSelector certSelector = new X509CertificateSubjectRdnSelector("EMAILADDRESS=publications@guardtime.com");
        Assert.assertTrue((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testX509CertificateMatchesUsingDifferentRdnValues_Ok() throws Exception {
        X509CertificateSubjectRdnSelector certSelector = new X509CertificateSubjectRdnSelector("EMAILADDRESS=publications@guardtime.com,L=Tallinn, C=EE, C=EE");
        Assert.assertTrue((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testX509CertificateDoesNotMatch_Ok() throws Exception {
        X509CertificateSubjectRdnSelector certSelector = new X509CertificateSubjectRdnSelector("E=publications2@guardtime.com");
        Assert.assertFalse((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testX509CertificateDoesNotMatchUsingMultipleRdnValues_Ok() throws Exception {
        X509CertificateSubjectRdnSelector certSelector = new X509CertificateSubjectRdnSelector("E=publications@guardtime.com,E=publications2@guardtime.com");
        Assert.assertFalse((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testMultipleDifferentRdnWithSameOid() throws Exception {
        TestX509CertificateSubjectRdnSelector certSelector = new TestX509CertificateSubjectRdnSelector("E=publications@guardtime.com", new AttributeTypeAndValue[]{EMAIL_INVALID, EMAIL});
        Assert.assertFalse((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testMultipleSameRdnWithSameOid() throws Exception {
        TestX509CertificateSubjectRdnSelector certSelector = new TestX509CertificateSubjectRdnSelector("E=publications@guardtime.com", new AttributeTypeAndValue[]{EMAIL, EMAIL});
        Assert.assertTrue((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testMultiValuedRdnInCertificate() throws Exception {
        TestX509CertificateSubjectRdnSelector certSelector = new TestX509CertificateSubjectRdnSelector("E=publications@guardtime.com", new AttributeTypeAndValue[]{EMAIL, EMAIL}, true);
        Assert.assertTrue((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testMultiValuedRdnContainingInvalidEmail() throws Exception {
        TestX509CertificateSubjectRdnSelector certSelector = new TestX509CertificateSubjectRdnSelector("E=publications@guardtime.com", new AttributeTypeAndValue[]{EMAIL_INVALID, EMAIL}, true);
        Assert.assertFalse((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    @Test
    public void testDifferentAsn1Encodings() throws Exception {
        TestX509CertificateSubjectRdnSelector certSelector = new TestX509CertificateSubjectRdnSelector("E=publications@guardtime.com", new AttributeTypeAndValue[]{new AttributeTypeAndValue(BCStyle.EmailAddress, (ASN1Encodable)new DERPrintableString("publications@guardtime.com"))}, true);
        Assert.assertTrue((boolean)certSelector.match(X509CertUtil.toCert((byte[])TestUtil.loadBytes("server.crt"))));
    }

    static class TestX509CertificateSubjectRdnSelector
    extends X509CertificateSubjectRdnSelector {
        private final AttributeTypeAndValue[] typeValues;
        private boolean multiValue;

        public TestX509CertificateSubjectRdnSelector(String rdnString, AttributeTypeAndValue[] typeValues, boolean multiValue) throws KSIException {
            super(rdnString);
            this.typeValues = typeValues;
            this.multiValue = multiValue;
        }

        public TestX509CertificateSubjectRdnSelector(String rdnString, AttributeTypeAndValue[] typeValues) throws KSIException {
            this(rdnString, typeValues, false);
        }

        X500Name getX500SubjectName(X509Certificate cert) throws CertificateEncodingException {
            X500NameBuilder nameBuilder = new X500NameBuilder(X500Name.getDefaultStyle());
            if (this.multiValue) {
                nameBuilder.addMultiValuedRDN(this.typeValues);
            } else {
                for (AttributeTypeAndValue typeValue : this.typeValues) {
                    nameBuilder.addRDN(typeValue);
                }
            }
            return nameBuilder.build();
        }
    }
}

