/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.unisignature.CalendarHashChain;
import com.guardtime.ksi.unisignature.CalendarHashChainUtil;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureComponentFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CalendarHashChainUtilTest {
    private InMemoryKsiSignatureComponentFactory signatureComponentFactory;
    private CalendarHashChain calendarHashChain_ok;

    @BeforeMethod
    public void setUp() throws Exception {
        this.signatureComponentFactory = new InMemoryKsiSignatureComponentFactory();
        this.calendarHashChain_ok = this.readCalendarHashChainFromFile("components/calendar-hash-chain/calendar-hash-chain-ok.tlv");
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="CalendarHashChain can not be null")
    public void testCalendarHashChainConsistency_firstChainNull_throwsNullPointerException() {
        CalendarHashChainUtil.areRightLinksConsistent(null, (CalendarHashChain)this.calendarHashChain_ok);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="CalendarHashChain can not be null")
    public void testCalendarHashChainConsistency_secondChainNull_throwsNullPointerException() {
        CalendarHashChainUtil.areRightLinksConsistent((CalendarHashChain)this.calendarHashChain_ok, null);
    }

    @Test
    public void testCalendarHashChainConsistency_firstChainHasMoreRightLinks() throws Exception {
        boolean areChainsConsistent = CalendarHashChainUtil.areRightLinksConsistent((CalendarHashChain)this.calendarHashChain_ok, (CalendarHashChain)this.readCalendarHashChainFromFile("components/calendar-hash-chain/ok-sig-2014-06-2-extended-calendar-chain-right-link-missing.tlv"));
        Assert.assertFalse((boolean)areChainsConsistent);
    }

    @Test
    public void testCalendarHashChainConsistency_secondChainHasMoreRightLinks() throws Exception {
        boolean areChainsConsistent = CalendarHashChainUtil.areRightLinksConsistent((CalendarHashChain)this.calendarHashChain_ok, (CalendarHashChain)this.readCalendarHashChainFromFile("components/calendar-hash-chain/ok-sig-2014-06-2-extended-calendar-chain-right-link-extra.tlv"));
        Assert.assertFalse((boolean)areChainsConsistent);
    }

    @Test
    public void testCalendarHashChainConsistency_calendarHashChainValueDifferent() throws Exception {
        boolean areChainsConsistent = CalendarHashChainUtil.areRightLinksConsistent((CalendarHashChain)this.calendarHashChain_ok, (CalendarHashChain)this.readCalendarHashChainFromFile("components/calendar-hash-chain/ok-sig-2014-06-2-extended-calendar-chain-right-link-data-hash-mismatch.tlv"));
        Assert.assertFalse((boolean)areChainsConsistent);
    }

    @Test
    public void testCalendarHashChainConsistency_Ok() throws Exception {
        boolean areChainsConsistent = CalendarHashChainUtil.areRightLinksConsistent((CalendarHashChain)this.calendarHashChain_ok, (CalendarHashChain)this.calendarHashChain_ok);
        Assert.assertTrue((boolean)areChainsConsistent);
    }

    private CalendarHashChain readCalendarHashChainFromFile(String calendarChainFileName) throws Exception {
        return this.signatureComponentFactory.createCalendarHashChain(CommonTestUtil.loadTlv((String)calendarChainFileName));
    }
}

