/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.tlv.TLVElement;
import com.guardtime.ksi.unisignature.AggregationChainLink;
import com.guardtime.ksi.unisignature.LinkMetadata;
import com.guardtime.ksi.unisignature.inmemory.InMemoryLinkMetadata;
import com.guardtime.ksi.unisignature.inmemory.InvalidAggregationHashChainException;
import com.guardtime.ksi.unisignature.inmemory.LeftAggregationChainLink;
import com.guardtime.ksi.unisignature.inmemory.RightAggregationChainLink;
import com.guardtime.ksi.util.Base16;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AggregationChainLinkTest {
    private static final byte[] LEGACY_ID_CONTENT = Base16.decode((String)"03:00034142430000000000000000000000000000000000000000000000");
    public static final String TEST_CLIENT_ID = "abc";
    private TLVElement siblingHash;
    private TLVElement legacyId;
    private TLVElement metadata;

    @BeforeClass
    public void init() throws Exception {
        this.siblingHash = new TLVElement(false, false, 2);
        this.siblingHash.setDataHashContent(new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        this.metadata = new TLVElement(false, false, 4);
        TLVElement clientIdElement = new TLVElement(false, false, 1);
        clientIdElement.setStringContent(TEST_CLIENT_ID);
        this.metadata.addChildElement(clientIdElement);
        this.legacyId = new TLVElement(false, false, 3);
        this.legacyId.setContent(LEGACY_ID_CONTENT);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Unsupported level correction amount 257")
    public void testCorrectionLevelExceeds8bits_ThrowsInvalidAggregationHashChainException() throws Exception {
        TLVElement element = new TLVElement(false, false, 8);
        TLVElement correctionLevel = new TLVElement(false, false, 1);
        correctionLevel.setLongContent(257L);
        element.addChildElement(correctionLevel);
        new RightAggregationChainLink(element);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="AggregationChainLink sibling data must consist of one of the following: 'sibling hash', 'legacy id' or 'metadata'")
    public void testLinkMustHaveSiblingHashOrLegacyIdOrMetaData_ThrowsInvalidAggregationHashChainException() throws Exception {
        TLVElement element = new TLVElement(false, false, 7);
        element.setStringContent("");
        new LeftAggregationChainLink(element);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Multiple sibling data items in hash step. Sibling hash and legacy id are present")
    public void testLinkMustNotHaveSiblingHashAndLegacyId_ThrowsInvalidAggregationHashChainException() throws Exception {
        TLVElement element = new TLVElement(false, false, 7);
        element.addChildElement(this.siblingHash);
        element.addChildElement(this.legacyId);
        new LeftAggregationChainLink(element);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Multiple sibling data items in hash step. Sibling hash and metadata are present")
    public void testLinkMustNotHaveSiblingHashAndMetadata_ThrowsInvalidAggregationHashChainException() throws Exception {
        TLVElement element = new TLVElement(false, false, 7);
        element.addChildElement(this.siblingHash);
        element.addChildElement(this.metadata);
        new LeftAggregationChainLink(element);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Multiple sibling data items in hash step. Legacy id and metadata are present")
    public void testLinkMustNotHaveLegacyIdAndMetadata_ThrowsInvalidAggregationHashChainException() throws Exception {
        TLVElement element = new TLVElement(false, false, 7);
        element.addChildElement(this.legacyId);
        element.addChildElement(this.metadata);
        new LeftAggregationChainLink(element);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="AggregationChainLink metadata does not contain clientId element")
    public void testLinkMetadataDoesNotContainClientId_ThrowsInvalidAggregationHashChainException() throws Exception {
        TLVElement metadata = new TLVElement(false, false, 4);
        TLVElement element = new TLVElement(false, false, 7);
        element.addChildElement(metadata);
        new LeftAggregationChainLink(element);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Unsupported level correction amount -2")
    public void testNegativeLevelCorrectionWithMetadata_ThrowsInvalidAggregationHashChainException() throws Exception {
        new LeftAggregationChainLink((LinkMetadata)new InMemoryLinkMetadata(TEST_CLIENT_ID), -2L);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Unsupported level correction amount 300")
    public void testLargeLevelCorrectionWithMetadata_ThrowsInvalidAggregationHashChainException() throws Exception {
        new LeftAggregationChainLink((LinkMetadata)new InMemoryLinkMetadata(TEST_CLIENT_ID), 300L);
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Unsupported level correction amount -2")
    public void testNegativeLevelCorrectionSiblingHash_ThrowsInvalidAggregationHashChainException() throws Exception {
        new LeftAggregationChainLink(new DataHash(HashAlgorithm.SHA2_256, new byte[32]), -2L);
    }

    @Test
    public void testDecodeLinkWithMetadata_Ok() throws Exception {
        TLVElement metadata = new TLVElement(false, false, 4);
        TLVElement clientId = new TLVElement(false, false, 1);
        clientId.setStringContent(TEST_CLIENT_ID);
        TLVElement machineId = new TLVElement(false, false, 2);
        machineId.setStringContent("123");
        TLVElement sequenceNumber = new TLVElement(false, false, 3);
        sequenceNumber.setLongContent(888L);
        TLVElement requestTime = new TLVElement(false, false, 4);
        requestTime.setLongContent(new Date().getTime());
        metadata.addChildElement(clientId);
        metadata.addChildElement(machineId);
        metadata.addChildElement(sequenceNumber);
        metadata.addChildElement(requestTime);
        TLVElement element = new TLVElement(false, false, 7);
        element.addChildElement(metadata);
        LeftAggregationChainLink link = new LeftAggregationChainLink(element);
        Assert.assertNotNull((Object)link);
        Assert.assertEquals((String)link.getLinkIdentity().getDecodedClientId(), (String)TEST_CLIENT_ID);
    }

    @Test
    public void testDecodeLinkWithLegacyId_Ok() throws Exception {
        TLVElement element = new TLVElement(false, false, 8);
        element.addChildElement(this.legacyId);
        RightAggregationChainLink link = new RightAggregationChainLink(element);
        Assert.assertNotNull((Object)link);
        Assert.assertEquals((String)link.getLinkIdentity().getDecodedClientId().toLowerCase(), (String)TEST_CLIENT_ID);
    }

    @Test
    public void testCreateNewLinkWithZeroLevelCorrection() throws Exception {
        RightAggregationChainLink link = new RightAggregationChainLink((LinkMetadata)new InMemoryLinkMetadata(TEST_CLIENT_ID), 0L);
        Assert.assertEquals((int)link.getRootElement().getChildElements(1).size(), (int)0);
    }

    @Test
    public void testCreateNewLeftLink() throws Exception {
        InMemoryLinkMetadata metadata = new InMemoryLinkMetadata(TEST_CLIENT_ID);
        LeftAggregationChainLink link = new LeftAggregationChainLink((LinkMetadata)metadata, 20L);
        LeftAggregationChainLink decodedChanLink = new LeftAggregationChainLink(link.getRootElement());
        Assert.assertEquals((Object)link, (Object)decodedChanLink);
        Assert.assertEquals((Object)link.getLinkIdentity().getType(), (Object)decodedChanLink.getLinkIdentity().getType());
    }

    @Test
    public void testCreateNewLeftLinkFromAnotherLinkWithMetadata() throws Exception {
        InMemoryLinkMetadata metadata = new InMemoryLinkMetadata(TEST_CLIENT_ID);
        LeftAggregationChainLink link = new LeftAggregationChainLink((LinkMetadata)metadata, 0L);
        LeftAggregationChainLink newLink = new LeftAggregationChainLink((AggregationChainLink)link, 3L);
        this.compareLinks((AggregationChainLink)link, (AggregationChainLink)newLink, 3L, true);
    }

    @Test
    public void testCreateNewRightLinkFromAnotherLinkWithMetadata() throws Exception {
        InMemoryLinkMetadata metadata = new InMemoryLinkMetadata(TEST_CLIENT_ID);
        RightAggregationChainLink link = new RightAggregationChainLink((LinkMetadata)metadata, 0L);
        RightAggregationChainLink newLink = new RightAggregationChainLink((AggregationChainLink)link, 3L);
        this.compareLinks((AggregationChainLink)link, (AggregationChainLink)newLink, 3L, false);
    }

    @Test
    public void testCreateNewLeftLinkFromAnotherLinkWithSiblingHash() throws Exception {
        LeftAggregationChainLink link = new LeftAggregationChainLink(new DataHash(HashAlgorithm.SHA2_256, new byte[32]), 0L);
        LeftAggregationChainLink newLink = new LeftAggregationChainLink((AggregationChainLink)link, 3L);
        this.compareLinks((AggregationChainLink)link, (AggregationChainLink)newLink, 3L, true);
    }

    @Test
    public void testCreateNewRightLinkFromAnotherLinkWithSiblingHash() throws Exception {
        RightAggregationChainLink link = new RightAggregationChainLink(new DataHash(HashAlgorithm.SHA2_256, new byte[32]), 0L);
        RightAggregationChainLink newLink = new RightAggregationChainLink((AggregationChainLink)link, 3L);
        this.compareLinks((AggregationChainLink)link, (AggregationChainLink)newLink, 3L, false);
    }

    @Test
    public void testCreateNewLeftLinkFromAnotherLinkWithLegacyId() throws Exception {
        TLVElement element = new TLVElement(false, false, 7);
        element.addChildElement(this.legacyId);
        LeftAggregationChainLink link = new LeftAggregationChainLink(element);
        LeftAggregationChainLink newLink = new LeftAggregationChainLink((AggregationChainLink)link, 3L);
        this.compareLinks((AggregationChainLink)link, (AggregationChainLink)newLink, 3L, true);
    }

    @Test
    public void testCreateNewRightLinkFromAnotherLinkWithLegacyId() throws Exception {
        TLVElement element = new TLVElement(false, false, 8);
        element.addChildElement(this.legacyId);
        RightAggregationChainLink link = new RightAggregationChainLink(element);
        RightAggregationChainLink newLink = new RightAggregationChainLink((AggregationChainLink)link, 3L);
        this.compareLinks((AggregationChainLink)link, (AggregationChainLink)newLink, 3L, false);
    }

    private void compareLinks(AggregationChainLink link, AggregationChainLink newLink, long level, boolean isLeft) throws KSIException {
        if (link.getLinkIdentity() == null) {
            Assert.assertNull((Object)newLink.getLinkIdentity());
        } else {
            Assert.assertEquals((Object)newLink.getLinkIdentity().getType(), (Object)link.getLinkIdentity().getType());
            Assert.assertEquals((String)newLink.getLinkIdentity().getDecodedClientId(), (String)link.getLinkIdentity().getDecodedClientId());
        }
        Assert.assertEquals((long)newLink.getLevelCorrection(), (long)level);
        Assert.assertEquals((Object)newLink.getMetadata(), (Object)link.getMetadata());
        Assert.assertEquals((byte[])newLink.getSiblingData(), (byte[])link.getSiblingData());
        Assert.assertEquals((boolean)newLink.isLeft(), (boolean)isLeft);
    }
}

