/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.SignatureVerifier;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.pdu.PduVersion;
import com.guardtime.ksi.publication.PublicationData;
import com.guardtime.ksi.publication.PublicationRecord;
import com.guardtime.ksi.publication.adapter.PublicationsFileClientAdapter;
import com.guardtime.ksi.service.client.KSIExtenderClient;
import com.guardtime.ksi.unisignature.AggregationHashChain;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.KSISignatureComponentFactory;
import com.guardtime.ksi.unisignature.SignaturePublicationRecord;
import com.guardtime.ksi.unisignature.inmemory.AggregationHashChainPrependingException;
import com.guardtime.ksi.unisignature.inmemory.InMemoryAggregationHashChain;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureComponentFactory;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignatureFactory;
import com.guardtime.ksi.unisignature.inmemory.InvalidSignatureContentException;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicy;
import com.guardtime.ksi.unisignature.verifier.policies.ContextAwarePolicyAdapter;
import com.guardtime.ksi.util.Base16;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InMemoryKsiSignatureFactoryTest {
    private static final String PUBLICATION_STRING = "AAAAAA-CTJR3I-AANBWU-RY76YF-7TH2M5-KGEZVA-WLLRGD-3GKYBG-AM5WWV-4MCLSP-XPRDDI-UFMHBA";
    private InMemoryKsiSignatureComponentFactory signatureComponentFactory = new InMemoryKsiSignatureComponentFactory();
    private InMemoryKsiSignatureFactory signatureFactory;
    private ContextAwarePolicy policy = ContextAwarePolicyAdapter.createInternalPolicy();
    private SignatureVerifier verifier = new SignatureVerifier();

    @BeforeMethod
    public void setUp() throws Exception {
        PublicationsFileClientAdapter mockedPublicationsFileAdapter = (PublicationsFileClientAdapter)Mockito.mock(PublicationsFileClientAdapter.class);
        Mockito.when((Object)mockedPublicationsFileAdapter.getPublicationsFile()).thenReturn((Object)TestUtil.loadPublicationsFile("publications-files/publications.tlv"));
        KSIExtenderClient extenderClient = (KSIExtenderClient)Mockito.mock(KSIExtenderClient.class);
        Mockito.when((Object)extenderClient.getPduVersion()).thenReturn((Object)PduVersion.V2);
        this.signatureFactory = new InMemoryKsiSignatureFactory(this.policy, (KSISignatureComponentFactory)new InMemoryKsiSignatureComponentFactory());
    }

    @Test
    public void testCreateValidKsiSignature_Ok() throws Exception {
        KSISignature signature = this.signatureFactory.createSignature(TestUtil.loadTlv((String)"signatures/ok-sig-2017-03-14.ksig"), null);
        Assert.assertNotNull((Object)signature);
    }

    @Test
    public void testCreateSignatureWithAggregationHashChainWithLeftLinksOnly_Ok() throws Exception {
        this.createSignatureWithAggregationChainAndVerify("components/aggregation-hash-chain/aggregation-hash-chain-with-height-3.tlv", "signatures/signature-with-level-correction-3.ksig", "01580192B0D06E48884432DFFC26A67C6C685BEAF0252B9DD2A0B4B05D1724C5F2");
    }

    @Test
    public void testCreateSignatureWithAggregationHashChainWithLeftAndRightLinks_Ok() throws Exception {
        this.createSignatureWithAggregationChainAndVerify("components/aggregation-hash-chain/aggregation-hash-chain-with-left-and-right-links-and-height-3.tlv", "signatures/signature-with-level-correction-3.ksig", "018D982C6911831201C5CF15E937514686A2169E2AD57BA36FD92CBEBD99A67E34");
    }

    @Test
    public void testCreateSignatureWithAggregationHashChainWithRightLinksOnly_Ok() throws Exception {
        this.createSignatureWithAggregationChainAndVerify("components/aggregation-hash-chain/aggregation-hash-chain-with-right-links-and-height-3.tlv", "signatures/signature-with-level-correction-3.ksig", "019D982C6911831201C5CF15E937514686A2169E2AD57BA36FD92CBEBD99A67E32");
    }

    @Test
    public void testCreateSignatureWithAggregationHashChainWithLeftLinksAndMetadata_Ok() throws Exception {
        this.createSignatureWithAggregationChainAndVerify("components/aggregation-hash-chain/aggregation-hash-chain-with-left-links-and-height-5.tlv", "signatures/signature-with-level-correction-5.ksig", "04000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    }

    @Test
    public void testCreateSignatureWithAggregationHashChainWithHeightLessThanLevelCorrection_Ok() throws Exception {
        this.createSignatureWithAggregationChainAndVerify("components/aggregation-hash-chain/aggregation-hash-chain-with-left-link-and-height-1.tlv", "signatures/signature-with-level-correction-14.ksig", "0111A700B0C8066C47ECBA05ED37BC14DCADB238552D86C659342D1D7E87B8772D");
    }

    @Test(expectedExceptions={AggregationHashChainPrependingException.class}, expectedExceptionsMessageRegExp="The aggregation hash chain cannot be added as lowest level chain. Its output level .* is bigger than level correction of the first link of the first aggregation hash chain of the base signature .*")
    public void testCreateSignatureWithInvalidChainHeight_throwsKSIException() throws Exception {
        InMemoryAggregationHashChain chain = new InMemoryAggregationHashChain(CommonTestUtil.loadTlv((String)"signatures/single-long-aggregation-hash-chain-ok.tlv").getFirstChildElement(2049));
        this.signatureFactory.createSignature(TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"), (AggregationHashChain)chain, null);
    }

    @Test(expectedExceptions={AggregationHashChainPrependingException.class}, expectedExceptionsMessageRegExp="The aggregation hash chain cannot be added as lowest level chain. Its output hash .* does not match base signature input hash .*")
    public void testCreateSignatureWithInvalidOutputHash_throwsKSIException() throws Exception {
        InMemoryAggregationHashChain chain = new InMemoryAggregationHashChain(CommonTestUtil.loadTlv((String)"components/aggregation-hash-chain/aggregation-hash-chain-with-height-2.tlv"));
        KSISignature signature = TestUtil.loadSignature("signatures/signature-with-level-correction-3.ksig");
        this.signatureFactory.createSignature(signature, (AggregationHashChain)chain, null);
    }

    @Test(expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp="Signature .* is invalid: GEN_04.*Wrong input hash algorithm.*")
    public void testCreateSignatureWithInvalidInputHashAlgorithm_ThrowsInvalidSignatureContentException() throws Exception {
        this.signatureFactory.createSignature(TestUtil.loadTlv((String)"signatures/ok-sig-2017-03-14.ksig"), new DataHash(HashAlgorithm.SHA1, new byte[20]));
    }

    @Test(expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp="Signature .* is invalid: GEN_01.*Wrong document.*")
    public void testCreateSignatureWithInvalidInputHash_ThrowsInvalidSignatureContentException() throws Exception {
        this.signatureFactory.createSignature(TestUtil.loadTlv((String)"signatures/ok-sig-2017-03-14.ksig"), new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
    }

    @Test(expectedExceptions={InvalidSignatureContentException.class}, expectedExceptionsMessageRegExp="Signature .* is invalid: INT_07.*")
    public void testCreateSignatureFromInvalidComponents_ThrowsInvalidSignatureContentException() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        SignaturePublicationRecord publicationRecord = this.signatureComponentFactory.createPublicationRecord(new PublicationData(PUBLICATION_STRING), null, null);
        this.signatureFactory.createSignature(Arrays.asList(signature.getAggregationHashChains()), signature.getCalendarHashChain(), signature.getCalendarAuthenticationRecord(), (PublicationRecord)publicationRecord, null);
    }

    private void createSignatureWithAggregationChainAndVerify(String chainFilename, String signatureFilename, String inputHashImprint) throws Exception {
        InMemoryAggregationHashChain chain = new InMemoryAggregationHashChain(CommonTestUtil.loadTlv((String)chainFilename));
        KSISignature signature = TestUtil.loadSignature(signatureFilename);
        DataHash inputHash = new DataHash(Base16.decode((String)inputHashImprint));
        ByteArrayOutputStream signatureBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream signatureBytesAfterSignatureCreation = new ByteArrayOutputStream();
        signature.writeTo((OutputStream)signatureBytes);
        KSISignature newSignature = this.signatureFactory.createSignature(signature, (AggregationHashChain)chain, inputHash);
        signature.writeTo((OutputStream)signatureBytesAfterSignatureCreation);
        Assert.assertEquals((byte[])signatureBytesAfterSignatureCreation.toByteArray(), (byte[])signatureBytes.toByteArray());
        VerificationResult result = this.verifier.verify(newSignature, inputHash, this.policy);
        Assert.assertTrue((boolean)result.isOk());
    }
}

