/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.exceptions.KSIException;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.unisignature.Identity;
import com.guardtime.ksi.unisignature.IdentityType;
import com.guardtime.ksi.unisignature.KSISignature;
import com.guardtime.ksi.unisignature.inmemory.InMemoryKsiSignature;
import com.guardtime.ksi.unisignature.inmemory.InvalidAggregationHashChainException;
import com.guardtime.ksi.unisignature.inmemory.InvalidSignatureException;
import com.guardtime.ksi.unisignature.inmemory.InvalidSignatureRFC3161RecordException;
import com.guardtime.ksi.util.Base16;
import com.guardtime.ksi.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InMemoryKsiSignatureTest {
    @Test
    public void testParseKSISignature_Ok() throws Exception {
        InMemoryKsiSignature signature = this.load(TestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig"));
        Assert.assertNotNull((Object)signature);
    }

    @Test
    public void testSignatureContainsIdentity_Ok() throws Exception {
        InMemoryKsiSignature signature = this.load(TestUtil.load((String)"signatures/signature-with-mixed-aggregation-chains.ksig"));
        Assert.assertNotNull((Object)signature.getAggregationHashChainIdentity());
        Identity[] chainIdentity = signature.getAggregationHashChainIdentity();
        Assert.assertNotNull((Object)chainIdentity);
        Assert.assertEquals((String)chainIdentity[0].getDecodedClientId(), (String)"GT");
        Assert.assertEquals((Object)chainIdentity[0].getType(), (Object)IdentityType.LEGACY);
        Assert.assertEquals((String)chainIdentity[chainIdentity.length - 1].getDecodedClientId(), (String)"anon");
        Assert.assertEquals((Object)chainIdentity[chainIdentity.length - 1].getType(), (Object)IdentityType.METADATA);
    }

    @Test
    public void testLoadSignatureFromFile_Ok() throws Exception {
        InMemoryKsiSignature signature = this.load(TestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig"));
        Assert.assertEquals((Object)signature.getInputHash(), (Object)new DataHash(Base16.decode((String)"0111A700B0C8066C47ECBA05ED37BC14DCADB238552D86C659342D1D7E87B8772D")));
        Assert.assertFalse((boolean)signature.isPublished());
        Assert.assertEquals((Object)signature.getPublicationTime(), (Object)new Date(1489520040000L));
        Assert.assertEquals((Object)signature.getAggregationTime(), (Object)new Date(1489520040000L));
    }

    @Test
    public void testLoadSignatureFromFileAndSerialize() throws Exception {
        InputStream input = TestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig");
        byte[] bytes = Util.toByteArray((InputStream)input);
        input.close();
        InMemoryKsiSignature signature = this.load(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        signature.writeTo((OutputStream)outBytes);
        Assert.assertEquals((byte[])bytes, (byte[])outBytes.toByteArray());
    }

    @Test(expectedExceptions={KSIException.class}, expectedExceptionsMessageRegExp="Output stream can not be null")
    public void testWriteUniSignatureToNullStream_ThrowsKSIException() throws Exception {
        InMemoryKsiSignature signature = this.load(TestUtil.load((String)"signatures/ok-sig-2017-03-14.ksig"));
        signature.writeTo(null);
    }

    @Test
    public void testGetInputHashWhenRfc3161RecordIsMissing() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig");
        Assert.assertEquals((Object)signature.getInputHash(), (Object)signature.getAggregationHashChains()[0].getInputHash());
    }

    @Test
    public void testGetInputHashWhenRfc3161RecordIsPresent() throws Exception {
        KSISignature signature = TestUtil.loadSignature("valid-signatures/rfc3161-signature.ksig");
        Assert.assertNotEquals((Object)signature.getInputHash(), (Object)signature.getAggregationHashChains()[0].getInputHash());
        Assert.assertEquals((Object)signature.getInputHash(), (Object)signature.getRfc3161Record().getInputHash());
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Aggregation chain index list can not be empty")
    public void verifyWithEmptyChainIndex_ThrowsException() throws Exception {
        TestUtil.loadSignature("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-chain-index-missing-tag.tlv");
    }

    @Test
    public void testParseSignatureWithMixedAggregationChains_Ok() throws Exception {
        KSISignature signature = TestUtil.loadSignature("signatures/signature-with-mixed-aggregation-chains.ksig");
        Assert.assertNotNull((Object)signature);
    }

    @Test(expectedExceptions={InvalidSignatureException.class}, expectedExceptionsMessageRegExp="Found calendar authentication record and publication record. Given elements can not coexist")
    public void testParseSignatureWithPublicationRecordAndCalendarAuthenticationRecord_ThrowsInvalidSignatureException() throws Exception {
        TestUtil.loadSignature("invalid-signatures/calendar-hash-chain/invalid-signature-calendar-chain-cal-aut-present-pub-rec-present.tlv");
    }

    @Test(expectedExceptions={InvalidSignatureRFC3161RecordException.class}, expectedExceptionsMessageRegExp="RFC3161 record chain index is null")
    public void testParseSignatureWithRfc3161RecordIsMissingChainIndex() throws Exception {
        TestUtil.loadSignature("invalid-signatures/rfc3161-record/invalid-signature-rfc3161-all-chain-index-missing-tag.tlv");
    }

    @Test(expectedExceptions={InvalidSignatureException.class}, expectedExceptionsMessageRegExp="Found calendar authentication record without calendar hash chain")
    public void testParseSignatureWithPublicationRecordAndWithoutCalendarHashChain_ThrowsInvalidSignatureException() throws Exception {
        TestUtil.loadSignature("invalid-signatures/calendar-hash-chain/invalid-signature-calendar-chain-missing-pub-rec-present.tlv");
    }

    @Test(expectedExceptions={InvalidSignatureException.class}, expectedExceptionsMessageRegExp="Found calendar authentication record without calendar hash chain")
    public void testParseSignatureWithCalendarAuthenticationRecordAndWithoutCalendarHashChain_ThrowsInvalidSignatureException() throws Exception {
        TestUtil.loadSignature("invalid-signatures/calendar-hash-chain/invalid-signature-calendar-chain-missing-cal-aut-present.tlv");
    }

    @Test(expectedExceptions={InvalidSignatureException.class}, expectedExceptionsMessageRegExp="At least one aggregation chain required")
    public void testParseSignatureWithoutAggregationHashChains_ThrowsInvalidSignatureException() throws Exception {
        TestUtil.loadSignature("invalid-signatures/calendar-hash-chain/invalid-signature-calendar-chain-no-aggregation-chains.tlv");
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Invalid legacyId length")
    public void testParseSignatureWithInvalidLegacyIdLength() throws Exception {
        TestUtil.loadSignature("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-legacy-id-value-too-long.tlv");
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Invalid legacyId prefix")
    public void testParseSignatureWithInvalidLegacyIdPrefix() throws Exception {
        TestUtil.loadSignature("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-legacy-id-invalid-prefix.tlv");
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Invalid legacyId embedded data length")
    public void testParseSignatureWithInvalidLegacyIdOctetStringLength() throws Exception {
        TestUtil.loadSignature("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-legacy-id-invalid-octet-string-padding.tlv");
    }

    @Test(expectedExceptions={InvalidAggregationHashChainException.class}, expectedExceptionsMessageRegExp="Invalid legacyId padding")
    public void testParseSignatureWithInvalidLegacyIdOctetStringPadding() throws Exception {
        TestUtil.loadSignature("invalid-signatures/aggregation-chain/invalid-signature-aggr-chain-left-link-legacy-id-invalid-ending-byte.tlv");
    }

    private InMemoryKsiSignature load(InputStream file) throws Exception {
        return new InMemoryKsiSignature(CommonTestUtil.loadTlv((InputStream)file));
    }
}

