/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.tlv.TLVElement;
import com.guardtime.ksi.unisignature.inmemory.InMemoryLinkMetadata;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InMemoryLinkMetadataTest {
    private static final String TEST_CLIENT_ID = "test-client-id";
    private static final String TEST_MACHINE_ID = "test-machine-id";
    private static final Long CURRENT_TIME = System.currentTimeMillis();
    private static final Long TEST_SEQUENCE_NUMBER = 1L;

    @Test
    public void testCreateNewLeftLink() throws Exception {
        InMemoryLinkMetadata metadata = new InMemoryLinkMetadata(TEST_CLIENT_ID, TEST_MACHINE_ID, TEST_SEQUENCE_NUMBER, CURRENT_TIME);
        Assert.assertEquals((String)metadata.getDecodedClientId(), (String)TEST_CLIENT_ID);
        TLVElement rootElement = metadata.getRootElement();
        Assert.assertEquals((int)5, (int)rootElement.getChildElements().size());
        int paddingLength = 2;
        Assert.assertEquals((int)((TLVElement)rootElement.getChildElements().get(0)).getContentLength(), (int)paddingLength);
        Assert.assertEquals((String)((TLVElement)rootElement.getChildElements().get(1)).getDecodedString(), (String)TEST_CLIENT_ID);
        Assert.assertEquals((String)((TLVElement)rootElement.getChildElements().get(2)).getDecodedString(), (String)TEST_MACHINE_ID);
        Assert.assertEquals((Object)((TLVElement)rootElement.getChildElements().get(3)).getDecodedLong(), (Object)TEST_SEQUENCE_NUMBER);
        Assert.assertEquals((Object)((TLVElement)rootElement.getChildElements().get(4)).getDecodedLong(), (Object)CURRENT_TIME);
    }

    @Test
    public void testCreateNewLeftLinkWithClientId() throws Exception {
        InMemoryLinkMetadata metadata = new InMemoryLinkMetadata(TEST_CLIENT_ID);
        Assert.assertEquals((String)metadata.getDecodedClientId(), (String)TEST_CLIENT_ID);
        TLVElement rootElement = metadata.getRootElement();
        Assert.assertEquals((int)2, (int)rootElement.getChildElements().size());
        int paddingLength = 1;
        Assert.assertEquals((int)((TLVElement)rootElement.getChildElements().get(0)).getContentLength(), (int)paddingLength);
        Assert.assertEquals((String)((TLVElement)rootElement.getChildElements().get(1)).getDecodedString(), (String)TEST_CLIENT_ID);
    }
}

