/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.hashing.DataHash;
import com.guardtime.ksi.hashing.HashAlgorithm;
import com.guardtime.ksi.publication.inmemory.InvalidPublicationRecordException;
import com.guardtime.ksi.unisignature.inmemory.InMemorySignaturePublicationRecord;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InMemorySignaturePublicationRecordTest {
    @Test
    public void testDecodeInMemorySignaturePublicationRecord_Ok() throws Exception {
        InMemorySignaturePublicationRecord publicationRecord = this.load(TestUtil.load((String)"components/publication-record/publication-record-signature-ok.tlv"));
        Assert.assertNotNull((Object)publicationRecord.getPublicationData());
        Assert.assertNotNull((Object)publicationRecord.getPublicationData().getPublicationTime());
        Assert.assertEquals((Object)publicationRecord.getPublicationData().getPublicationDataHash(), (Object)new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        Assert.assertTrue((boolean)publicationRecord.getPublicationReferences().isEmpty());
        Assert.assertTrue((boolean)publicationRecord.getPublicationRepositoryURIs().isEmpty());
    }

    @Test
    public void testDecodeInMemorySignaturePublicationRecordWithReferencesAndRepositoryURI_Ok() throws Exception {
        InMemorySignaturePublicationRecord publicationRecord = this.load(TestUtil.load((String)"components/publication-record/publication-record-signature-with-ref-and-uri-ok.tlv"));
        Assert.assertNotNull((Object)publicationRecord.getPublicationData());
        Assert.assertNotNull((Object)publicationRecord.getPublicationData().getPublicationTime());
        Assert.assertEquals((Object)publicationRecord.getPublicationData().getPublicationDataHash(), (Object)new DataHash(HashAlgorithm.SHA2_256, new byte[32]));
        Assert.assertFalse((boolean)publicationRecord.getPublicationReferences().isEmpty());
        Assert.assertEquals((int)publicationRecord.getPublicationReferences().size(), (int)3);
        Assert.assertFalse((boolean)publicationRecord.getPublicationRepositoryURIs().isEmpty());
        Assert.assertEquals((int)publicationRecord.getPublicationRepositoryURIs().size(), (int)4);
    }

    @Test(expectedExceptions={InvalidPublicationRecordException.class}, expectedExceptionsMessageRegExp="Required field publicationData\\(TLV\\[0x10\\]\\) missing in # PublicationRecord TLV\\[0x803\\]")
    public void testDecodeInMemorySignaturePublicationRecordWithoutPublicationData_ThrowsInvalidPublicationRecordException() throws Exception {
        this.load(new ByteArrayInputStream(new byte[]{-120, 3, 0, 0}));
    }

    private InMemorySignaturePublicationRecord load(InputStream file) throws Exception {
        return new InMemorySignaturePublicationRecord(CommonTestUtil.loadTlv((InputStream)file));
    }
}

