/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.inmemory;

import com.guardtime.ksi.CommonTestUtil;
import com.guardtime.ksi.unisignature.inmemory.InMemorySignatureData;
import com.guardtime.ksi.unisignature.inmemory.InvalidSignatureDataException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SignatureDataTest {
    @Test
    public void testReadSignatureData_Ok() throws Exception {
        InMemorySignatureData data = SignatureDataTest.load("components/calendar-auth-signature-data/signature-data-ok.tlv");
        Assert.assertEquals((int)data.getElementType(), (int)11);
        Assert.assertNotNull((Object)data.getSignatureType());
        Assert.assertNotNull((Object)data.getSignatureValue());
        Assert.assertNotNull((Object)data.getCertificateId());
        Assert.assertNull((Object)data.getCertificateRepositoryUri());
    }

    @Test(expectedExceptions={InvalidSignatureDataException.class}, expectedExceptionsMessageRegExp="Signature data signature type can not be null")
    public void testReadSignatureDataWithoutSignatureType_ThrowsInvalidSignatureDataException() throws Exception {
        SignatureDataTest.load("components/calendar-auth-signature-data/signature-data-without-signature-type.tlv");
    }

    @Test(expectedExceptions={InvalidSignatureDataException.class}, expectedExceptionsMessageRegExp="Signature data signature value can not be null")
    public void testReadSignatureDataWithoutSignatureValue_ThrowsInvalidSignatureDataException() throws Exception {
        SignatureDataTest.load("components/calendar-auth-signature-data/signature-data-without-signature-value.tlv");
    }

    @Test(expectedExceptions={InvalidSignatureDataException.class}, expectedExceptionsMessageRegExp="Signature data certificate id can not be null")
    public void testReadSignatureDataWithoutCertificateId_ThrowsInvalidSignatureDataException() throws Exception {
        SignatureDataTest.load("components/calendar-auth-signature-data/signature-data-without-certificate-id.tlv");
    }

    @Test
    public void testReadSignatureDataWithCertificateRepositoryUri_Ok() throws Exception {
        InMemorySignatureData data = SignatureDataTest.load("components/calendar-auth-signature-data/signature-data-with-repository-uri.tlv");
        Assert.assertNotNull((Object)data.getCertificateRepositoryUri());
        Assert.assertEquals((String)data.getCertificateRepositoryUri(), (String)"http://localhost/rep_uri");
    }

    static InMemorySignatureData load(String file) throws Exception {
        return new InMemorySignatureData(CommonTestUtil.loadTlv((String)file));
    }
}

