/*
 * Decompiled with CFR 0.152.
 */
package com.guardtime.ksi.unisignature.verifier;

import com.guardtime.ksi.TestUtil;
import com.guardtime.ksi.unisignature.verifier.KSISignatureVerifier;
import com.guardtime.ksi.unisignature.verifier.KSIVerificationContext;
import com.guardtime.ksi.unisignature.verifier.PolicyVerificationResult;
import com.guardtime.ksi.unisignature.verifier.RuleResult;
import com.guardtime.ksi.unisignature.verifier.SignatureVerifier;
import com.guardtime.ksi.unisignature.verifier.VerificationContext;
import com.guardtime.ksi.unisignature.verifier.VerificationErrorCode;
import com.guardtime.ksi.unisignature.verifier.VerificationResult;
import com.guardtime.ksi.unisignature.verifier.VerificationResultCode;
import com.guardtime.ksi.unisignature.verifier.policies.Policy;
import com.guardtime.ksi.unisignature.verifier.rules.Rule;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SignatureVerifierTest {
    private SignatureVerifier verifier;
    private Policy mockedPolicy;
    private Policy fallbackPolicy;
    private VerificationContext context;

    @BeforeMethod
    public void setUp() throws Exception {
        this.mockedPolicy = (Policy)Mockito.mock(Policy.class);
        this.fallbackPolicy = (Policy)Mockito.mock(Policy.class);
        this.verifier = new KSISignatureVerifier();
        this.context = (VerificationContext)Mockito.mock(VerificationContext.class);
        Mockito.when((Object)this.context.getSignature()).thenReturn((Object)TestUtil.loadSignature("signatures/ok-sig-2017-03-14.ksig"));
    }

    @Test
    public void testVerifySignatureWithoutAnyRules_Ok() throws Exception {
        Mockito.when((Object)this.mockedPolicy.getRules()).thenReturn(new LinkedList());
        VerificationResult result = this.verifier.verify(this.context, this.mockedPolicy);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((boolean)result.isOk(), (boolean)false);
        Assert.assertEquals((int)result.getPolicyVerificationResults().size(), (int)1);
        Assert.assertEquals((Object)((PolicyVerificationResult)result.getPolicyVerificationResults().get(0)).getPolicyStatus(), (Object)VerificationResultCode.NA);
    }

    @Test
    public void testWhenVerifyingInvalidSignatureThenResultIsInvalid_Ok() throws Exception {
        Rule mockedRule = (Rule)Mockito.mock(Rule.class);
        RuleResult mockedResult = (RuleResult)Mockito.mock(RuleResult.class);
        Mockito.when((Object)mockedResult.getResultCode()).thenReturn((Object)VerificationResultCode.FAIL);
        Mockito.when((Object)mockedRule.verify((VerificationContext)Mockito.any(KSIVerificationContext.class))).thenReturn((Object)mockedResult);
        Mockito.when((Object)this.mockedPolicy.getRules()).thenReturn(this.toList(mockedRule));
        VerificationResult result = this.verifier.verify(this.context, this.mockedPolicy);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((boolean)result.isOk(), (boolean)false);
        Assert.assertEquals((int)result.getPolicyVerificationResults().size(), (int)1);
        Assert.assertEquals((Object)((PolicyVerificationResult)result.getPolicyVerificationResults().get(0)).getPolicyStatus(), (Object)VerificationResultCode.FAIL);
    }

    @Test
    public void testWhenVerifyingSignatureWithoutEnoughDataThenResultIsNa_Ok() throws Exception {
        Rule mockedRule = (Rule)Mockito.mock(Rule.class);
        RuleResult mockedResult = (RuleResult)Mockito.mock(RuleResult.class);
        Mockito.when((Object)mockedResult.getResultCode()).thenReturn((Object)VerificationResultCode.OK);
        Mockito.when((Object)mockedRule.verify((VerificationContext)Mockito.any(KSIVerificationContext.class))).thenReturn((Object)mockedResult);
        RuleResult mockedResult2 = (RuleResult)Mockito.mock(RuleResult.class);
        Mockito.when((Object)mockedResult2.getResultCode()).thenReturn((Object)VerificationResultCode.NA);
        Rule mockedRule2 = (Rule)Mockito.mock(Rule.class);
        Mockito.when((Object)mockedRule2.verify((VerificationContext)Mockito.any(KSIVerificationContext.class))).thenReturn((Object)mockedResult2);
        Mockito.when((Object)this.mockedPolicy.getRules()).thenReturn(this.toList(mockedRule, mockedRule2));
        VerificationResult result = this.verifier.verify(this.context, this.mockedPolicy);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((boolean)result.isOk(), (boolean)false);
        Assert.assertEquals((Object)((PolicyVerificationResult)result.getPolicyVerificationResults().get(0)).getPolicyStatus(), (Object)VerificationResultCode.NA);
        Assert.assertEquals((Object)((RuleResult)((PolicyVerificationResult)result.getPolicyVerificationResults().get(0)).getRuleResults().get(mockedRule)).getResultCode(), (Object)VerificationResultCode.OK);
        Assert.assertEquals((Object)((RuleResult)((PolicyVerificationResult)result.getPolicyVerificationResults().get(0)).getRuleResults().get(mockedRule2)).getResultCode(), (Object)VerificationResultCode.NA);
    }

    @Test
    public void testFallbackPolicy() throws Exception {
        Rule mockedRule = (Rule)Mockito.mock(Rule.class);
        RuleResult mockedResult = (RuleResult)Mockito.mock(RuleResult.class);
        Mockito.when((Object)mockedResult.getErrorCode()).thenReturn((Object)VerificationErrorCode.GEN_01);
        Mockito.when((Object)mockedResult.getResultCode()).thenReturn((Object)VerificationResultCode.NA);
        Mockito.when((Object)mockedRule.verify((VerificationContext)Mockito.any(KSIVerificationContext.class))).thenReturn((Object)mockedResult);
        RuleResult mockedResult2 = (RuleResult)Mockito.mock(RuleResult.class);
        Mockito.when((Object)mockedResult2.getResultCode()).thenReturn((Object)VerificationResultCode.OK);
        Rule mockedRule2 = (Rule)Mockito.mock(Rule.class);
        Mockito.when((Object)mockedRule2.verify((VerificationContext)Mockito.any(KSIVerificationContext.class))).thenReturn((Object)mockedResult2);
        Mockito.when((Object)this.mockedPolicy.getRules()).thenReturn(this.toList(mockedRule));
        Mockito.when((Object)this.fallbackPolicy.getRules()).thenReturn(this.toList(mockedRule2));
        Mockito.when((Object)this.mockedPolicy.getFallbackPolicy()).thenReturn((Object)this.fallbackPolicy);
        VerificationResult result = this.verifier.verify(this.context, this.mockedPolicy);
        Assert.assertTrue((boolean)result.isOk());
        Assert.assertNull((Object)result.getErrorCode());
    }

    List<Rule> toList(Rule ... rules) {
        return Arrays.asList(rules);
    }
}

